<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\Loan;

class LoanController extends Controller
{
    //
    public function allEmployeeId()
    {

        try {
            $employees = Employee::all();

            $employee_arr = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($employee_arr, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['employee_id']]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $employee_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }







    public function allEmployeeName()
    {

        try {
            $employees = Employee::all();

            $employee_arr = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($employee_arr, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['name_withinitial']]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $employee_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function getEmployeeByID($id)
    {
        try {
            $employee = Employee::find($id);
            $responseBody = $this->responseBody(true, "Employee", "all", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function save(Request $request)
    {
        try {
            $employee_id = $request->get('employee_id');
            $amount = $request->get('txtAmount');
            $no_of_terms = $request->get('txtNoOfTearms');
            $intere = $request->get('txtInterest');
            $tran_date = $request->get('txtTranDate');
            $year = $request->get('selcDeductYear');
            $month = $request->get('selcDeductMonth');
            $reason = $request->get('txtReason');

            $loan = new Loan();
            $loan->employee_id = $employee_id;
            $loan->amount = $amount;
            $loan->no_of_terms = $no_of_terms;
            $loan->interest_percentage = $intere;
            $loan->paid_amount = 0.00;
            $loan->paid_terms = 0.00;
            $loan->tran_date = $tran_date;
            $loan->deduct_year = $year;
            $loan->deduct_month = $month;
            $loan->requested_by = 0;
            $loan->approved_by = 0;
            $loan->status = 0;
            $loan->reason = $reason;
            $save = $loan->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "Loan", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Loan", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function update(Request $request, $id)
    {
        try {
            $employee_id = $request->get('employee_id');
            $amount = $request->get('txtAmount');
            $no_of_terms = $request->get('txtNoOfTearms');
            $intere = $request->get('txtInterest');
            $tran_date = $request->get('txtTranDate');
            $year = $request->get('selcDeductYear');
            $month = $request->get('selcDeductMonth');
            $reason = $request->get('txtReason');

            $loan = Loan::find($id);
            $loan->employee_id = $employee_id;
            $loan->amount = $amount;
            $loan->no_of_terms = $no_of_terms;
            $loan->interest_percentage = $intere;
            $loan->tran_date = $tran_date;
            $loan->deduct_year = $year;
            $loan->deduct_month = $month;
            $loan->reason = $reason;
            $update = $loan->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Loan", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Loan", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function delete($id)
    {
        try {
            $loan = Loan::find($id);
            $delete = $loan->delete();
            if ($delete) {
                $responseBody = $this->responseBody(true, "Loan", "deleted", null);
            } else {
                $responseBody = $this->responseBody(false, "Loan", "not deleted", $delete);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Loan", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function allLoan()
    {
        try {
            $query = "SELECT `loans`.id AS id, `loans`.deduct_year AS year, `loans`.deduct_month AS month, `loans`.employee_id AS employee_id,`loans`.status AS status, `employees`.name_withinitial AS name, `loans`.amount AS amount FROM `hr_employees` employees INNER JOIN `hr_loans` loans ON employees.employee_id = loans.employee_id";
            $loan = DB::select($query);
            $responseBody = $this->responseBody(true, "Loan", "all", $loan);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Loan", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function loanFromList($id)
    {

        try {
            $loan = Loan::find($id);
            $employee = Employee::find($loan->employee_id);
            $loan->employee = $employee;
            $responseBody = $this->responseBody(true, "Loan", "all", $loan);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Loan", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }






    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
