<?php

namespace Modules\Ar\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Sc\Entities\category_level_2;

use function PHPUnit\Framework\isEmpty;

class RDSaleSummaryReportController extends Controller
{
    private $font_size = "11px";
    private static $data_source = [];
    private static $branch_data_source = [];
    private static $item_data_source = [];


    public function rdSaleSummaryReport($filters)
    {
        $json_filters = json_decode($filters);
        $this->getBranchDataSource();
        $this->getItemDataSource();

        $todate = $json_filters[1]->todate;
        $border = '0px';
        $route_bg_color = "#9B59B6";
        $font_color = "white";
        $rd_bg_color = "B0F798";
        $qty_bg_color = "EBD412";
        $value_bg_color = "#85C1E9";

        $HTML_REPORT = "<div class='body' style='width:100%;border:" . $border . " solid black;text-align:center;'>";
        $HTML_REPORT .= $this->reportTitle("RD Area Wise Reportx");
        $HTML_REPORT .= '</div>';


        $categories = $this->getCategory();
        $routes =  $this->createReportColumnHeader($json_filters);
        $MAIN_ARRAY = [];
        $branches = [];
        $main_grand_total_array = [];

        $MAIN_CATEGORY_GRAND_TOTAL_ARRAY = [];
        foreach ($categories as $category) {
            $SUB_CATEGORY_TOTAL_ARRAY = [];
            $items = $this->getItemData($json_filters, $category->item_category_level_2_id);

            if (count($items) > 0) {

                $HTML_REPORT .= '<div><h4>' . $category->category_level_2 . '</h4></div>';



                $HTML_REPORT .= '<table>';
                $HTML_REPORT .= '<thead>';
                $HTML_REPORT .= '<tr>';

                $column_width = 200;
                $main_total_quantity_array = [];
                foreach ($routes as $route) {
                    if (array_keys($route)[0] == "Items") {
                        $route_bg_color = "black";
                        $column_width = 400;
                    } else {
                        $route_bg_color = "#9B59B6";
                    }

                    $HTML_REPORT .= '<th style="color:' . $font_color . ';font-size:' . $this->font_size . ';background-color:' . $route_bg_color . ';height:40px;min-width:' . $column_width . 'px;">';
                    $HTML_REPORT .=  array_keys($route)[0];
                    $HTML_REPORT .= '</th>';
                }
                $HTML_REPORT .= '</tr>';
                $HTML_REPORT .= '</thead>';



                $HTML_REPORT .= '<tbody>';
                $HTML_REPORT .= '<tr>';
                $total_qty_rd_main_array = [];
                $total_value_rd_main_array = [];
                $total_qty_stock_main_array = [];
                $total_value_stock_main_array = [];

                foreach ($routes as $route) {
                    $total_qty_rd_sub_array = [];
                    $total_value_rd_sub_array = [];
                    $total_qty_stock_sub_array = [];
                    $total_value_stock_sub_array = [];

                    $HTML_REPORT .= '<td style="padding:0px;">';
                    $HTML_REPORT .= '<table>';
                    $HTML_REPORT .= '<tr style="padding:0px;">';
                    foreach ($routes as $route2) {
                        if (isset($route2[array_keys($route)[0]])) {
                            $column_width = 200;
                            if (array_keys($route)[0] == "Items") {
                                $column_width = 400;
                                $rd_bg_color = "black";
                            } else {
                                $rd_bg_color = "B0F798";
                            }
                            foreach ($route2[array_keys($route)[0]] as $branch) {
                                $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';background-color:' . $rd_bg_color . ';height:50px;min-width:' . $column_width . 'px;text-align:center;" colspan="2">';
                                $HTML_REPORT .= str_replace('@', ' ', $branch);
                                $HTML_REPORT .= '</td>';
                            }
                        }
                    }
                    $HTML_REPORT .= '</tr>';

                    $HTML_REPORT .= '<tr style="padding:0px;">';
                    foreach ($routes as $route2) {
                        if (isset($route2[array_keys($route)[0]])) {
                            $col_name1 = "Quantity";
                            $col_name2 = "Value";
                            if (array_keys($route)[0] == "Items") {
                                $col_name1 = "";
                                $col_name2 = "";
                                $qty_bg_color = "black";
                                $value_bg_color = "black";
                            } else {
                                $qty_bg_color = "EBD412";
                                $value_bg_color = "#85C1E9";
                            }
                            foreach ($route2[array_keys($route)[0]] as $branch) {
                                $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';background-color:' . $rd_bg_color . ';height:20px;min-width:200px;text-align:center;" colspan="2">';
                                $HTML_REPORT .= '<table>';
                                $HTML_REPORT .= '<tr>';
                                $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';background-color:' . $qty_bg_color . ';height:20px;min-width:100px;text-align:center;">';
                                $HTML_REPORT .= $col_name1;
                                $HTML_REPORT .= '</td>';
                                $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';background-color:' . $value_bg_color . ';height:20px;min-width:100px;text-align:center;">';
                                $HTML_REPORT .= $col_name2;
                                $HTML_REPORT .= '</td>';
                                $HTML_REPORT .= '</tr>';
                                $HTML_REPORT .= '</table>';
                                $HTML_REPORT .= '</td>';
                            }
                        }
                    }
                    $HTML_REPORT .= '</tr>';



                    //set item data
                    $total_quantity_array = [];
                    $rd_qty_index = 0;
                    $rd_value_index = 0;
                    $stock_qty_index = 0;
                    $stock_value_index = 0;
                    for ($i = 0; $i < count($items); $i++) {
                        $total_rd_qty = 0;
                        $total_rd_value = 0;
                        $quantity_array = [];

                        $HTML_REPORT .= '<tr style="border:1px solid black;">';


                        foreach ($routes as $route2) {

                            if (isset($route2[array_keys($route)[0]])) {
                                if (array_keys($route)[0] == "Items") {
                                    $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:200px;text-align:center;" colspan="2">';
                                    $HTML_REPORT .= '<table>';
                                    $HTML_REPORT .= '<tr>';
                                    $HTML_REPORT .= '<td style="border-right: 0px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:300px;text-align:left;">';
                                    $HTML_REPORT .= $items[$i];
                                    $HTML_REPORT .= '</td>';
                                    $HTML_REPORT .= '</tr>';
                                    $HTML_REPORT .= '</table>';
                                    $HTML_REPORT .= '</td>';
                                } else {

                                    foreach ($route2[array_keys($route)[0]] as $branch) {
                                        $qty = 0;
                                        $value = 0;
                                        $branch_stock_col = explode("@", $branch);
                                        $bool_slock_balance = isset($branch_stock_col[1]);
                                        if ($bool_slock_balance) {
                                            $item_id = $this->getItemID($items[$i]);
                                            $branch_id = $this->getBranchID($branch_stock_col[0]);
                                            $qty = $this->getStockQuantityByBranchItemRoute($branch_id, $item_id, $todate);
                                            $value = $this->getStockValueByBranchItemRoute($branch_id, $item_id, $todate);
                                            array_push($quantity_array, $qty);
                                            array_push($quantity_array, $value);
                                            array_push($total_qty_stock_sub_array, $qty);
                                            array_push($total_value_stock_sub_array, $value);
                                            if (!in_array($branch_id, $branches)) {
                                                array_push($branches, $branch_id);
                                            }
                                            $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:200px;text-align:center;" colspan="2">';
                                            $HTML_REPORT .= '<table>';
                                            $HTML_REPORT .= '<tr>';
                                            $HTML_REPORT .= '<td style="border-right: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                            $HTML_REPORT .= $qty;
                                            $HTML_REPORT .= '</td>';
                                            $HTML_REPORT .= '<td style="border-right: 0px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                            $HTML_REPORT .= number_format($value, 2, '.', ',');
                                            $HTML_REPORT .= '</td>';
                                            $HTML_REPORT .= '</tr>';
                                            $HTML_REPORT .= '</table>';
                                            $HTML_REPORT .= '</td>';
                                        } else {
                                            //if (str_replace('@', ' ', $branch) != "Tranz Pharma Direct") {
                                            $qty = $this->getQuantityByBranchItemRoute($branch, $items[$i], array_keys($route)[0]);
                                            $value = $this->getValueByBranchItemRoute($branch, $items[$i], array_keys($route)[0]);
                                            $total_rd_qty += $qty;
                                            $total_rd_value += $value;
                                            //}
                                            if (str_replace('@', ' ', $branch) == "Total RD") {
                                                $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:200px;text-align:center;" colspan="2">';
                                                $HTML_REPORT .= '<table>';
                                                $HTML_REPORT .= '<tr>';
                                                $HTML_REPORT .= '<td style="border-right: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                                $HTML_REPORT .= $total_rd_qty;
                                                $HTML_REPORT .= '</td>';
                                                $HTML_REPORT .= '<td style="border-right: 0px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                                $HTML_REPORT .= number_format($total_rd_value, 2, '.', ',');
                                                $HTML_REPORT .= '</td>';
                                                $HTML_REPORT .= '</tr>';
                                                $HTML_REPORT .= '</table>';
                                                $HTML_REPORT .= '</td>';
                                                array_push($quantity_array, $total_rd_qty);
                                                array_push($quantity_array, $total_rd_value);
                                                array_push($total_qty_rd_sub_array, $total_rd_qty);
                                                array_push($total_value_rd_sub_array, $total_rd_value);
                                            } else if (str_replace('@', ' ', $branch) == "RD") {
                                                $rd_qty = $this->getTotal($total_qty_rd_main_array, $rd_qty_index++);
                                                $rd_value = $this->getTotal($total_value_rd_main_array, $rd_value_index++);
                                                $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:200px;text-align:center;" colspan="2">';
                                                $HTML_REPORT .= '<table>';
                                                $HTML_REPORT .= '<tr>';
                                                $HTML_REPORT .= '<td style="border-right: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                                $HTML_REPORT .= $rd_qty;
                                                $HTML_REPORT .= '</td>';
                                                $HTML_REPORT .= '<td style="border-right: 0px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                                $HTML_REPORT .= number_format($rd_value, 2, '.', ',');
                                                $HTML_REPORT .= '</td>';
                                                $HTML_REPORT .= '</tr>';
                                                $HTML_REPORT .= '</table>';
                                                $HTML_REPORT .= '</td>';
                                                array_push($quantity_array, $rd_qty);
                                                array_push($quantity_array, $rd_value);
                                            } else if (str_replace('@', ' ', $branch) == "Stock Balance") {
                                                $item_id = $this->getItemID($items[$i]);
                                                $stock_qty = $this->getTotalStockQuantity($branches, $item_id, $todate);
                                                $stock_value = $this->getTotalStockValue($branches, $item_id, $todate);
                                                $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:200px;text-align:center;" colspan="2">';
                                                $HTML_REPORT .= '<table>';
                                                $HTML_REPORT .= '<tr>';
                                                $HTML_REPORT .= '<td style="border-right: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                                $HTML_REPORT .= $stock_qty;
                                                $HTML_REPORT .= '</td>';
                                                $HTML_REPORT .= '<td style="border-right: 0px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                                $HTML_REPORT .= number_format($stock_value, 2, '.', ',');
                                                $HTML_REPORT .= '</td>';
                                                $HTML_REPORT .= '</tr>';
                                                $HTML_REPORT .= '</table>';
                                                $HTML_REPORT .= '</td>';
                                                array_push($quantity_array, $stock_qty);
                                                array_push($quantity_array, $stock_value);
                                            } else {
                                                $qty =  $this->getQuantityByBranchItemRoute($branch, $items[$i], array_keys($route)[0]);
                                                $value = $this->getValueByBranchItemRoute($branch, $items[$i], array_keys($route)[0]);
                                                array_push($quantity_array, $qty);
                                                array_push($quantity_array, $value);

                                                $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:200px;text-align:center;" colspan="2">';
                                                $HTML_REPORT .= '<table>';
                                                $HTML_REPORT .= '<tr>';
                                                $HTML_REPORT .= '<td style="border-right: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                                $HTML_REPORT .= $qty;
                                                $HTML_REPORT .= '</td>';
                                                $HTML_REPORT .= '<td style="border-right: 0px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                                $HTML_REPORT .= number_format($value, 2, '.', ',');
                                                $HTML_REPORT .= '</td>';
                                                $HTML_REPORT .= '</tr>';
                                                $HTML_REPORT .= '</table>';
                                                $HTML_REPORT .= '</td>';
                                            }
                                        }
                                    }
                                }
                            }
                        }

                        if (count($quantity_array) > 0) {
                            array_push($total_quantity_array, $quantity_array);
                        }
                        $HTML_REPORT .= '</tr>';
                    }

                    array_push($main_total_quantity_array, $total_quantity_array);
                    $HTML_REPORT .= '<tr>';




                    $grand_total_array = [];
                    foreach ($main_total_quantity_array as $total_quantity_array) {
                        $total_array = []; // Initialize once outside the main loop
                        foreach ($total_quantity_array as $quantity_child_array) {
                            for ($i = 0; $i < count($quantity_child_array); $i++) {
                                // Ensure $total_array[$i] is initialized before adding to it
                                if (!isset($total_array[$i])) {
                                    $total_array[$i] = 0;
                                }
                                $total_array[$i] += (float) $quantity_child_array[$i];
                            }
                        }
                        if (!in_array($total_array, $grand_total_array) && count($total_array) != 0) {
                            array_push($grand_total_array, $total_array);
                        }
                    }








                    foreach ($routes as $route2) {
                        if (isset($route2[array_keys($route)[0]])) {
                            $count = 0;
                            foreach ($route2[array_keys($route)[0]] as $branch) {
                                if (array_keys($route)[0] == "Items") {
                                    $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:200px;text-align:center;" colspan="2">';
                                    $HTML_REPORT .= '<table>';
                                    $HTML_REPORT .= '<tr>';
                                    $HTML_REPORT .= '<td style="border-right: 0px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:300px;text-align:left;">';
                                    $HTML_REPORT .= '<strong>Total :</strong>';;
                                    $HTML_REPORT .= '</td>';
                                    $HTML_REPORT .= '</tr>';
                                    $HTML_REPORT .= '</table>';
                                    $HTML_REPORT .= '</td>';
                                } else if (array_keys($route)[0] == "Total") {
                                    $category_name = explode("-", $category->category_level_2)[1];
                                    if (!in_array([$category_name => $grand_total_array], $main_grand_total_array)) {
                                        //array_push($MAIN_CATEGORY_GRAND_TOTAL_ARRAY, $grand_total_array);
                                        array_push($main_grand_total_array, [$category_name => $grand_total_array]);
                                    }

                                    $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:200px;text-align:center;" colspan="2">';
                                    $HTML_REPORT .= '<table>';
                                    $HTML_REPORT .= '<tr>';
                                    $HTML_REPORT .= '<td style="border-right: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                    $HTML_REPORT .= '<strong>' . $total_array[$count++] . '</strong>';
                                    $HTML_REPORT .= '</td>';
                                    $HTML_REPORT .= '<td style="border-right: 0px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                    $HTML_REPORT .= '<strong>' . number_format($total_array[$count++], 2, '.', ',') . '</strong>';
                                    $HTML_REPORT .= '</td>';
                                    $HTML_REPORT .= '</tr>';
                                    $HTML_REPORT .= '</table>';
                                    $HTML_REPORT .= '</td>';
                                } else {

                                    $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:200px;text-align:center;" colspan="2">';
                                    $HTML_REPORT .= '<table>';
                                    $HTML_REPORT .= '<tr>';
                                    $HTML_REPORT .= '<td style="border-right: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                    $HTML_REPORT .= '<strong>' . $total_array[$count++] . '</strong>';
                                    $HTML_REPORT .= '</td>';
                                    $HTML_REPORT .= '<td style="border-right: 0px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                    $HTML_REPORT .= '<strong>' . number_format($total_array[$count++], 2, '.', ',') . '</strong>';
                                    $HTML_REPORT .= '</td>';
                                    $HTML_REPORT .= '</tr>';
                                    $HTML_REPORT .= '</table>';
                                    $HTML_REPORT .= '</td>';
                                }
                            }
                        }
                    }


                    $HTML_REPORT .= '</tr>';


                    $HTML_REPORT .= '</table>';
                    $HTML_REPORT .= '</td>';
                    if (count($total_qty_rd_sub_array) > 0) {
                        array_push($total_qty_rd_main_array, $total_qty_rd_sub_array);
                    }
                    if (count($total_value_rd_sub_array) > 0) {
                        array_push($total_value_rd_main_array, $total_value_rd_sub_array);
                    }
                    if (count($total_qty_stock_sub_array) > 0) {
                        array_push($total_qty_stock_main_array, $total_qty_stock_sub_array);
                    }
                    if (count($total_value_stock_sub_array) > 0) {
                        array_push($total_value_stock_main_array, $total_value_stock_sub_array);
                    }
                }
                array_push($MAIN_ARRAY, $main_total_quantity_array);



                $HTML_REPORT .= '</tr>';
                $HTML_REPORT .= '</tbody>';


                $HTML_REPORT .= '</table>';
            }
        }
        //dd($main_grand_total_array);
        return $HTML_REPORT .= $this->grandTotal($filters, $main_grand_total_array);
    }



    private function grandTotal($filters, $main_grand_total_array)
    {



        //dd($main_grand_total_array);
        $json_filters = json_decode($filters);
        $this->getBranchDataSource();
        $this->getItemDataSource();

        $todate = $json_filters[1]->todate;
        $border = '0px';
        $route_bg_color = "#9B59B6";
        $font_color = "white";
        $rd_bg_color = "B0F798";
        $qty_bg_color = "EBD412";
        $value_bg_color = "#85C1E9";
        $HTML_REPORT = '';


        $categories = $this->getCategory();
        $routes =  $this->createReportGrandTotalColumnHeader($json_filters);
        $MAIN_ARRAY = [];
        $branches = [];

        //$items = $this->getItemData($json_filters, $category->item_category_level_2_id);



        $HTML_REPORT .= '<div><h4></h4></div>';



        $HTML_REPORT .= '<table>';
        $HTML_REPORT .= '<thead>';
        $HTML_REPORT .= '<tr>';

        $column_width = 200;

        foreach ($routes as $route) {
            if (array_keys($route)[0] == "Category") {
                $route_bg_color = "black";
                $column_width = 400;
            } else {
                $route_bg_color = "#9B59B6";
            }

            $HTML_REPORT .= '<th style="color:' . $font_color . ';font-size:' . $this->font_size . ';background-color:' . $route_bg_color . ';height:40px;min-width:' . $column_width . 'px;">';
            $HTML_REPORT .=  array_keys($route)[0];
            $HTML_REPORT .= '</th>';
        }
        $HTML_REPORT .= '</tr>';
        $HTML_REPORT .= '</thead>';



        $HTML_REPORT .= '<tbody>';
        $HTML_REPORT .= '<tr>';


        foreach ($routes as $route) {
            $total_qty_rd_sub_array = [];
            $total_value_rd_sub_array = [];
            $total_qty_stock_sub_array = [];
            $total_value_stock_sub_array = [];

            $HTML_REPORT .= '<td style="padding:0px;">';
            $HTML_REPORT .= '<table>';
            $HTML_REPORT .= '<tr style="padding:0px;">';
            foreach ($routes as $route2) {
                if (isset($route2[array_keys($route)[0]])) {
                    $column_width = 200;
                    if (array_keys($route)[0] == "Category") {
                        $column_width = 400;
                        $rd_bg_color = "black";
                    } else {
                        $rd_bg_color = "B0F798";
                    }
                    foreach ($route2[array_keys($route)[0]] as $branch) {
                        $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';background-color:' . $rd_bg_color . ';height:50px;min-width:' . $column_width . 'px;text-align:center;" colspan="2">';
                        $HTML_REPORT .= str_replace('@', ' ', $branch);
                        $HTML_REPORT .= '</td>';
                    }
                }
            }
            $HTML_REPORT .= '</tr>';

            $HTML_REPORT .= '<tr style="padding:0px;">';
            foreach ($routes as $route2) {
                if (isset($route2[array_keys($route)[0]])) {
                    $col_name1 = "Quantity";
                    $col_name2 = "Value";
                    if (array_keys($route)[0] == "Category") {
                        $col_name1 = "";
                        $col_name2 = "";
                        $qty_bg_color = "black";
                        $value_bg_color = "black";
                    } else {
                        $qty_bg_color = "EBD412";
                        $value_bg_color = "#85C1E9";
                    }
                    foreach ($route2[array_keys($route)[0]] as $branch) {
                        $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';background-color:' . $rd_bg_color . ';height:20px;min-width:200px;text-align:center;" colspan="2">';
                        $HTML_REPORT .= '<table>';
                        $HTML_REPORT .= '<tr>';
                        $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';background-color:' . $qty_bg_color . ';height:20px;min-width:100px;text-align:center;">';
                        $HTML_REPORT .= $col_name1;
                        $HTML_REPORT .= '</td>';
                        $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';background-color:' . $value_bg_color . ';height:20px;min-width:100px;text-align:center;">';
                        $HTML_REPORT .= $col_name2;
                        $HTML_REPORT .= '</td>';
                        $HTML_REPORT .= '</tr>';
                        $HTML_REPORT .= '</table>';
                        $HTML_REPORT .= '</td>';
                    }
                }
            }
            $HTML_REPORT .= '</tr>';


            $category_name = [];
            foreach ($categories as $category) {
                $name_array = explode("-", $category->category_level_2);
                if (!in_array($name_array[1], $category_name)) {
                    array_push($category_name, $name_array[1]);
                }
            }


            $MAIN_ARRAY = [];
            foreach ($category_name as $name) {
                $ARRAY = [];
                foreach ($main_grand_total_array as $grand_total_array) {
                    if (isset($grand_total_array[$name])) {
                        array_push($ARRAY, $grand_total_array);
                    }
                }
                array_push($MAIN_ARRAY, $ARRAY);
            }

            $final = [];

            foreach ($MAIN_ARRAY as $group) {
                foreach ($group as $companyData) {
                    foreach ($companyData as $companyName => $rows) {
                        $companyName = trim($companyName); // remove leading space
                        foreach ($rows as $rowIndex => $columns) {
                            foreach ($columns as $colIndex => $value) {
                                if (!isset($final[$companyName][$rowIndex][$colIndex])) {
                                    $final[$companyName][$rowIndex][$colIndex] = 0;
                                }
                                $final[$companyName][$rowIndex][$colIndex] += $value;
                            }
                        }
                    }
                }
            }


            //dd($final);


            foreach ($category_name as $name) {
                $companyName = trim($companyName);

                $HTML_REPORT .=  '<tr>';
                foreach ($routes as $route2) {
                    if (isset($route2[array_keys($route)[0]])) {
                        $count = 0;
                        $branch_count = 0;
                        foreach ($route2[array_keys($route)[0]] as $branch) {
                           
                            if (array_keys($route)[0] == "Category") {
                                $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:200px;text-align:center;" colspan="2">';
                                $HTML_REPORT .= '<table>';
                                $HTML_REPORT .= '<tr>';
                                $HTML_REPORT .= '<td style="border-right: 0px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:300px;text-align:left;">';
                                $HTML_REPORT .= '<strong>' . $name . '</strong>';;
                                $HTML_REPORT .= '</td>';
                                $HTML_REPORT .= '</tr>';
                                $HTML_REPORT .= '</table>';
                                $HTML_REPORT .= '</td>';
                            } else {
                                $HTML_REPORT .= '<td style="border: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:200px;text-align:center;" colspan="2">';
                                $HTML_REPORT .= '<table>';
                                $HTML_REPORT .= '<tr>';
                                $HTML_REPORT .= '<td style="border-right: 1px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                $HTML_REPORT .= '<strong>' . $final[$companyName][$branch_count][$count++] . '</strong>';
                                $HTML_REPORT .= '</td>';
                                $HTML_REPORT .= '<td style="border-right: 0px solid black;border-collapse: collapse;font-size:' . $this->font_size . ';height:20px;min-width:100px;text-align:right;">';
                                $HTML_REPORT .= '<strong>' . $final[$companyName][$branch_count][$count++] . '</strong>';
                                $HTML_REPORT .= '</td>';
                                $HTML_REPORT .= '</tr>';
                                $HTML_REPORT .= '</table>';
                                $HTML_REPORT .= '</td>';
                            }
                            $branch_count++;
                        }
                        //dd($count);
                    }
                }
                $HTML_REPORT .= '</tr>';
            }


            $HTML_REPORT .= '</table>';
            $HTML_REPORT .= '</td>';
        }

        $HTML_REPORT .= '</tr>';
        $HTML_REPORT .= '</tbody>';


        $HTML_REPORT .= '</table>';
        return  $HTML_REPORT;
    }


    private function reportTitle($title)
    {
        $html = "<div style='text-align:center;'><h4>";
        $html .= $title;
        $html .= "</h4></div>";
        return $html;
    }


    private function createReportColumnHeader($filters)
    {

        $fromdate = $filters[0]->fromdate;
        $todate = $filters[1]->todate;

        $query = "SELECT DISTINCT MR.route_name,B.branch_name
        FROM sales_with_sales_returns S 
        INNER JOIN branches B ON S.branch_id=B.branch_id
        INNER JOIN customers C ON C.customer_id=S.customer_id
        INNER JOIN marketing_routes MR ON MR.marketing_route_id=C.marketing_route_id
        WHERE   S.transaction_date BETWEEN '" . $fromdate . "' AND '" . $todate . "'  GROUP BY C.marketing_route_id, S.branch_id , S.item_id ORDER BY C.marketing_route_id";

        $result = DB::select($query);
        $routes = [];
        array_push($routes, ["Items" => array()]);
        foreach ($result as $res) {
            if (!in_array([$res->route_name => array()], $routes)) {
                array_push($routes, [$res->route_name => array()]);
            }
        }
        array_push($routes, ["Total" => array()]);

        $bool = true;
        foreach ($result as $res) {
            foreach ($routes as &$route) {
                if (isset($route["Items"])) {
                    if ($bool) {
                        array_push($route["Items"], "");
                        $bool = false;
                    }
                }
                if (isset($route[$res->route_name])) {
                    if ($res->branch_name != "Tranz Pharma Direct") {
                        array_push($route[$res->route_name], $res->branch_name);
                    }
                }
            }
        }
        foreach ($result as $res) {
            foreach ($routes as &$route) {
                if (isset($route[$res->route_name])) {
                    if (!in_array("Tranz Pharma Direct", $route[$res->route_name])) {
                        array_push($route[$res->route_name], "Tranz Pharma Direct");
                    }
                }
            }
        }
        foreach ($result as $res) {
            foreach ($routes as &$route) {
                if (isset($route[$res->route_name])) {
                    if (!in_array("Total RD", $route[$res->route_name])) {
                        array_push($route[$res->route_name], "Total RD");
                    }
                }
            }
        }
        foreach ($result as $res) {
            foreach ($routes as &$route) {
                if (isset($route[$res->route_name])) {
                    if ($res->branch_name != "Tranz Pharma Direct") {
                        array_push($route[$res->route_name], $res->branch_name . "@Stock Balance");
                    }
                }
            }
        }

        if (isset($route["Total"])) {
            array_push($route["Total"], "RD");
            array_push($route["Total"], "Stock Balance");
        }
        return $routes;
    }


    private function createReportGrandTotalColumnHeader($filters)
    {

        $fromdate = $filters[0]->fromdate;
        $todate = $filters[1]->todate;

        $query = "SELECT DISTINCT MR.route_name,B.branch_name
        FROM sales_with_sales_returns S 
        INNER JOIN branches B ON S.branch_id=B.branch_id
        INNER JOIN customers C ON C.customer_id=S.customer_id
        INNER JOIN marketing_routes MR ON MR.marketing_route_id=C.marketing_route_id
        WHERE   S.transaction_date BETWEEN '" . $fromdate . "' AND '" . $todate . "'  GROUP BY C.marketing_route_id, S.branch_id , S.item_id ORDER BY C.marketing_route_id";

        $result = DB::select($query);
        $routes = [];
        array_push($routes, ["Category" => array()]);
        foreach ($result as $res) {
            if (!in_array([$res->route_name => array()], $routes)) {
                array_push($routes, [$res->route_name => array()]);
            }
        }
        array_push($routes, ["Total" => array()]);

        $bool = true;
        foreach ($result as $res) {
            foreach ($routes as &$route) {
                if (isset($route["Category"])) {
                    if ($bool) {
                        array_push($route["Category"], "");
                        $bool = false;
                    }
                }
                if (isset($route[$res->route_name])) {
                    if ($res->branch_name != "Tranz Pharma Direct") {
                        array_push($route[$res->route_name], $res->branch_name);
                    }
                }
            }
        }
        foreach ($result as $res) {
            foreach ($routes as &$route) {
                if (isset($route[$res->route_name])) {
                    if (!in_array("Tranz Pharma Direct", $route[$res->route_name])) {
                        array_push($route[$res->route_name], "Tranz Pharma Direct");
                    }
                }
            }
        }
        foreach ($result as $res) {
            foreach ($routes as &$route) {
                if (isset($route[$res->route_name])) {
                    if (!in_array("Total RD", $route[$res->route_name])) {
                        array_push($route[$res->route_name], "Total RD");
                    }
                }
            }
        }
        foreach ($result as $res) {
            foreach ($routes as &$route) {
                if (isset($route[$res->route_name])) {
                    if ($res->branch_name != "Tranz Pharma Direct") {
                        array_push($route[$res->route_name], $res->branch_name . "@Stock Balance");
                    }
                }
            }
        }

        if (isset($route["Total"])) {
            array_push($route["Total"], "RD");
            array_push($route["Total"], "Stock Balance");
        }
        return $routes;
    }


    private function getCategory()
    {
        $query = "SELECT item_category_level_2s.item_category_level_2_id,item_category_level_2s.category_level_2 FROM item_category_level_2s";
        $category_level_2 = DB::select($query);
        return $category_level_2;
    }



    private function getItemData($filters, $category_level_2)
    {
        $fromdate = $filters[0]->fromdate;
        $todate = $filters[1]->todate;
        $item = $filters[3]->selecteitem;

        $query = "SELECT I.item_id, I.category_level_2_id,
            C.marketing_route_id, MR.route_name AS marketing_route,
            S.branch_id, B.branch_name, I.Item_code, I.item_Name, I.package_unit,
            ROUND(SUM(S.quantity) * -1, 0) AS Quantity,
            ROUND(SUM((S.quantity * S.price) - (((S.quantity * S.price) / 100) * (IFNULL(S.discount_percentage, 0) + IFNULL(S.item_discount_percentage, 0)))), 2) * -1 AS Sales,
            ROUND((SELECT SUM(IH.quantity) FROM item_historys IH WHERE IH.item_id = S.item_id AND IH.branch_id = S.branch_id AND IH.transaction_date <= '" . $todate . "')) AS Stock,
            ROUND((SELECT (SUM(IH.quantity) * IH.cost_price)  FROM item_historys IH WHERE IH.item_id = S.item_id AND IH.branch_id = S.branch_id AND IH.transaction_date <= '" . $todate . "')) AS StockValue
            FROM sales_with_sales_returns S
            INNER JOIN customers C ON C.customer_id = S.customer_id
            INNER JOIN items I ON I.item_id = S.item_id
            INNER JOIN branches B ON S.branch_id = B.branch_id
            INNER JOIN marketing_routes MR ON MR.marketing_route_id = C.marketing_route_id
            WHERE S.transaction_date BETWEEN '" . $fromdate . "' AND '" . $todate . "'
            AND I.category_level_2_id = '" . $category_level_2 . "'";

        if ($item) {
            $query .= " AND I.item_id IN ('" . implode("','", $item) . "')";
        }

        $query .= " GROUP BY C.marketing_route_id, S.branch_id, S.item_id ORDER BY C.marketing_route_id";
        $result = DB::select($query);
        RDSaleSummaryReportController::$data_source = $result;
        $items = [];
        foreach ($result as $item_result) {
            if (!in_array($item_result->item_Name, $items)) {
                $items[] = $item_result->item_Name;
            }
        }
        return $items;
    }



    private function getQuantityByBranchItemRoute($branch, $itemName, $marketingRoute)
    {




        // Ensure the data source has been set
        if (empty(RDSaleSummaryReportController::$data_source)) {
            return 0; // or handle as needed
        }

        foreach (RDSaleSummaryReportController::$data_source as $data) {
            if (
                $data->branch_name === str_replace('@', ' ', $branch) &&
                $data->item_Name === $itemName &&
                $data->marketing_route === $marketingRoute
            ) {
                return $data->Quantity; // Return Quantity if all conditions match
            }
        }

        return 0; // Return null if no match is found
    }



    private function getValueByBranchItemRoute($branch, $itemName, $marketingRoute)
    {
        // Ensure the data source has been set
        if (empty(RDSaleSummaryReportController::$data_source)) {
            return 0; // or handle as needed
        }

        foreach (RDSaleSummaryReportController::$data_source as $data) {
            if (
                $data->branch_name === str_replace('@', ' ', $branch) &&
                $data->item_Name === $itemName &&
                $data->marketing_route === $marketingRoute
            ) {
                return $data->Sales; // Return Quantity if all conditions match
            }
        }

        return 0; // Return null if no match is found
    }


    private function getStockQuantityByBranchItemRoute($branch, $item, $date)
    {
        $query = "SELECT ROUND(SUM(IH.quantity)) AS qty FROM item_historys IH WHERE IH.item_id = '" . $item . "' AND IH.branch_id = '" . $branch . "' AND IH.transaction_date <= '" . $date . "'";
        $result = DB::select($query);
        if (isset($result[0])) {
            return $result[0]->qty;
        } else {
            return 0;
        }
        return 0;
    }



    private function getStockValueByBranchItemRoute($branch, $item, $date)
    {
        $query = "SELECT ROUND((SUM(IH.quantity) * IH.cost_price)) AS value  FROM item_historys IH WHERE IH.item_id = '" . $item . "' AND IH.branch_id = '" . $branch . "' AND IH.transaction_date <= '" . $date . "'";
        $result = DB::select($query);
        if (isset($result[0])) {
            return $result[0]->value;
        } else {
            return 0;
        }
        return 0;
    }



    private function getBranchDataSource()
    {
        RDSaleSummaryReportController::$branch_data_source = DB::select('SELECT BR.branch_id,BR.branch_name FROM branches BR');
    }



    private function getBranchID($branch)
    {
        // Ensure the data source has been set
        if (empty(RDSaleSummaryReportController::$branch_data_source)) {
            return 0; // or handle as needed
        }

        foreach (RDSaleSummaryReportController::$branch_data_source as $data) {
            if (
                $data->branch_name === str_replace('@', ' ', $branch)
            ) {
                return $data->branch_id; // Return branch id if all conditions match
            }
        }

        return 0; // Return null if no match is found
    }



    private function getItemDataSource()
    {
        RDSaleSummaryReportController::$item_data_source = DB::select('SELECT I.item_id,I.item_Name FROM items I');
    }



    private function getItemID($item)
    {
        // Ensure the data source has been set
        if (empty(RDSaleSummaryReportController::$item_data_source)) {
            return 0; // or handle as needed
        }

        foreach (RDSaleSummaryReportController::$item_data_source as $data) {
            if (
                $data->item_Name === $item
            ) {
                return $data->item_id; // Return branch id if all conditions match
            }
        }

        return 0; // Return null if no match is found
    }


    private function getTotal($total_array, $index)
    {
        $total = 0;
        foreach ($total_array as $array) {
            $total += (float) $array[$index];
        }
        return $total;
    }




    private function getTotalStockQuantity($branches, $item, $date)
    {

        $query = "SELECT ROUND(SUM(IH.quantity)) AS qty FROM item_historys IH WHERE IH.item_id = '" . $item . "' AND IH.branch_id IN ('" . implode("','", $branches) . "') AND IH.transaction_date <= '" . $date . "'";
        $result = DB::select($query);
        if (isset($result[0])) {
            return $result[0]->qty;
        } else {
            return 0;
        }
    }


    private function getTotalStockValue($branches, $item, $date)
    {

        $query = "SELECT ROUND((SUM(IH.quantity) * IH.cost_price)) AS value FROM item_historys IH WHERE IH.item_id = '" . $item . "' AND IH.branch_id IN ('" . implode("','", $branches) . "') AND IH.transaction_date <= '" . $date . "'";
        $result = DB::select($query);
        if (isset($result[0])) {
            return $result[0]->value;
        } else {
            return 0;
        }
    }
}
