<?php

/**
 * SalaryDataController -source code
 *
 * @author  Sampath Perera
 * @since   2020-12-01
 */


namespace Modules\Hr\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Company;
use Modules\Hr\Entities\DebtorLoan;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeCategory;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\Hr\Entities\EmployeeSalary;
use Modules\Hr\Entities\EmployeeSection;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Hr\Entities\EmployeeSubsection;
use Modules\Hr\Entities\GlobalSettings;
use Modules\Hr\Entities\Loan;
use Modules\Hr\Entities\OtherEarningDeduction;
use Modules\Hr\Entities\SalaryAdvance;
use Modules\Hr\Entities\SalaryData;
use Modules\Hr\Entities\TransactionItemSetup;

class SalaryDataController extends Controller
{

    /**
     * allEmployeeId
     * This function is used to get all employee's id for auto complete.
     */
    public function employeeID()
    {

        try {
            $employees = Employee::all();

            $employee_arr = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($employee_arr, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['employee_id']]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $employee_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    /**
     * allEmployeeName
     * This function is used to get all employee's name for autocomplete.
     */
    public function employeeName()
    {

        try {
            $employees = Employee::all();

            $employee_arr = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($employee_arr, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['name_withinitial']]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $employee_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function currentMonthSalary($employee_id)
    {
        try {
            $date = Carbon::now();
            $salary_year = explode("-", $date)[0];
            $salary_month = explode("-", $date)[1];

            $salary = SalaryData::where([['employee_id', '=', $employee_id], ['salary_month', '=', $salary_month], ['salary_year', '=', $salary_year]])->first();
            $responseBody = $this->responseBody(true, "SalaryData", "currentMonthSalary", $salary);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SalaryData", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    /**
     * getEmployeeByID
     * This function is used to search employee by employee_id.
     * @param id This is the paramter for search employee.
     */
    public function employeeData($id)
    {
        try {
            $employee = Employee::find($id);
            $employee->category_name = EmployeeCategory::find($employee->category_id)->category;
            $employee->category_work_day = EmployeeCategory::find($employee->category_id)->work_days_month;
            $employee->category_work_hour = EmployeeCategory::find($employee->category_id)->work_hour_day;
            $employee->category_epf_employer = EmployeeCategory::find($employee->category_id)->epf_employer;
            $employee->category_epf_employee = EmployeeCategory::find($employee->category_id)->epf_employee;
            $employee->category_etf_employee = EmployeeCategory::find($employee->category_id)->etf_employee;

            $employee->category_ot_rate1 = EmployeeCategory::find($employee->category_id)->ot_rate1;
            $employee->category_ot_rate2 = EmployeeCategory::find($employee->category_id)->ot_rate2;
            $employee->category_ot_rate3 = EmployeeCategory::find($employee->category_id)->ot_rate3;

            $employee->category_budget_allowance1 = EmployeeCategory::find($employee->category_id)->budget_allowance1;
            $employee->category_budget_allowance2 = EmployeeCategory::find($employee->category_id)->budget_allowance2;
            $employee->category_fine_rate = EmployeeCategory::find($employee->category_id)->fine_rate;

            $employee->site_name = EmployeeSite::find($employee->site_id)->site;
            $employee->department_name = EmployeeDepartment::find($employee->department_id)->department;
            $employee->section_name = EmployeeSection::find($employee->section_id)->section;
            $employee->subsection_name = EmployeeSubsection::find($employee->subsection_id)->subsection;
            $employee->company_name = Company::find($employee->company_id)->company;
            $employee->basic_salary = $this->basicSalary($employee->employee_id);
            $employee->earnings = $this->earnings($employee->employee_id);
            $employee->deductions = $this->deductions($employee->employee_id);

            $responseBody = $this->responseBody(true, "Employee", "employeeData", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    private function basicSalary($id)
    {
        $basic_salary =  EmployeeSalary::where([['employee_id', '=', $id], ['status', '=', '1']])->get();
        $salary = 0;
        if (count($basic_salary) > 0) {
            $salary = $basic_salary[0]->salary;
        }
        return $salary;
    }


    private function earnings($employee_id)
    {
        $earning_arr = [
            ["earn_trans_id_01" => 0, "earn_01" => 0, "item_id" => 0],
            ["earn_trans_id_02" => 0, "earn_02" => 0, "item_id" => 0],
            ["earn_trans_id_03" => 0, "earn_03" => 0, "item_id" => 0],
            ["earn_trans_id_04" => 0, "earn_04" => 0, "item_id" => 0],
            ["earn_trans_id_05" => 0, "earn_05" => 0, "item_id" => 0],
            ["earn_trans_id_06" => 0, "earn_06" => 0, "item_id" => 0],
            ["earn_trans_id_07" => 0, "earn_07" => 0, "item_id" => 0],
            ["earn_trans_id_08" => 0, "earn_08" => 0, "item_id" => 0],
            ["earn_trans_id_09" => 0, "earn_09" => 0, "item_id" => 0],
            ["earn_trans_id_10" => 0, "earn_10" => 0, "item_id" => 0],
        ];

        $query = "SELECT hr_transaction_item_setups.item_id,hr_transaction_item_setups.narration,hr_employee_other_earning_deductions.amount FROM hr_employee_other_earning_deductions
        INNER JOIN hr_other_earning_deduction ON hr_employee_other_earning_deductions.earn_deduct_id = hr_other_earning_deduction.earn_deduct_id
        INNER JOIN hr_transaction_item_setups ON hr_other_earning_deduction.item_id = hr_transaction_item_setups.item_id WHERE hr_employee_other_earning_deductions.employee_id ='" . $employee_id . "' AND hr_transaction_item_setups.`status` ='1' AND hr_other_earning_deduction.type ='1'";

        $result = DB::select($query);
        if (count($result) > 0) {
            $earning_arr[0]["earn_trans_id_01"] = $result[0]->narration;
            $earning_arr[0]["earn_01"] = $result[0]->amount;
            $earning_arr[0]["item_id"] = $result[0]->item_id;
        }

        if (count($result) > 1) {
            $earning_arr[1]["earn_trans_id_02"] = $result[1]->narration;
            $earning_arr[1]["earn_02"] = $result[1]->amount;
            $earning_arr[1]["item_id"] = $result[1]->item_id;
        }

        if (count($result) > 2) {
            $earning_arr[2]["earn_trans_id_03"] = $result[2]->narration;
            $earning_arr[2]["earn_03"] = $result[2]->amount;
            $earning_arr[2]["item_id"] = $result[2]->item_id;
        }

        if (count($result) > 3) {
            $earning_arr[3]["earn_trans_id_04"] = $result[3]->narration;
            $earning_arr[3]["earn_04"] = $result[3]->amount;
            $earning_arr[3]["item_id"] = $result[3]->item_id;
        }

        if (count($result) > 4) {
            $earning_arr[4]["earn_trans_id_05"] = $result[4]->narration;
            $earning_arr[4]["earn_05"] = $result[4]->amount;
            $earning_arr[4]["item_id"] = $result[4]->item_id;
        }

        if (count($result) > 5) {
            $earning_arr[5]["earn_trans_id_06"] = $result[5]->narration;
            $earning_arr[5]["earn_06"] = $result[5]->amount;
            $earning_arr[5]["item_id"] = $result[5]->item_id;
        }

        if (count($result) > 6) {
            $earning_arr[6]["earn_trans_id_07"] = $result[6]->narration;
            $earning_arr[6]["earn_07"] = $result[6]->amount;
            $earning_arr[6]["item_id"] = $result[6]->item_id;
        }

        if (count($result) > 7) {
            $earning_arr[7]["earn_trans_id_08"] = $result[7]->narration;
            $earning_arr[7]["earn_08"] = $result[7]->amount;
            $earning_arr[7]["item_id"] = $result[7]->item_id;
        }

        if (count($result) > 8) {
            $earning_arr[8]["earn_trans_id_09"] = $result[8]->narration;
            $earning_arr[8]["earn_09"] = $result[8]->amount;
            $earning_arr[8]["item_id"] = $result[8]->item_id;
        }

        if (count($result) > 9) {
            $earning_arr[9]["earn_trans_id_10"] = $result[9]->narration;
            $earning_arr[9]["earn_10"] = $result[9]->amount;
            $earning_arr[9]["item_id"] = $result[9]->item_id;
        }

        return $earning_arr;
    }


    private function deductions($employee_id)
    {
        $deduction_arr = [
            ["deduct_trans_id_01" => 0, "deduct_01" => 0, "item_id" => 0],
            ["deduct_trans_id_02" => 0, "deduct_02" => 0, "item_id" => 0],
            ["deduct_trans_id_03" => 0, "deduct_03" => 0, "item_id" => 0],
            ["deduct_trans_id_04" => 0, "deduct_04" => 0, "item_id" => 0],
            ["deduct_trans_id_05" => 0, "deduct_05" => 0, "item_id" => 0],
            ["deduct_trans_id_06" => 0, "deduct_06" => 0, "item_id" => 0],
            ["deduct_trans_id_07" => 0, "deduct_07" => 0, "item_id" => 0],
            ["deduct_trans_id_08" => 0, "deduct_08" => 0, "item_id" => 0],
            ["deduct_trans_id_09" => 0, "deduct_09" => 0, "item_id" => 0],
            ["deduct_trans_id_10" => 0, "deduct_10" => 0, "item_id" => 0],
        ];

        $query = "SELECT hr_transaction_item_setups.item_id,hr_transaction_item_setups.narration,hr_employee_other_earning_deductions.amount FROM hr_employee_other_earning_deductions
        INNER JOIN hr_other_earning_deduction ON hr_employee_other_earning_deductions.earn_deduct_id = hr_other_earning_deduction.earn_deduct_id
        INNER JOIN hr_transaction_item_setups ON hr_other_earning_deduction.item_id = hr_transaction_item_setups.item_id WHERE hr_employee_other_earning_deductions.employee_id ='" . $employee_id . "' AND hr_transaction_item_setups.`status` ='1' AND hr_other_earning_deduction.type ='3'";

        $result = DB::select($query);
        if (count($result) > 0) {
            $deduction_arr[0]["deduct_trans_id_01"] = $result[0]->narration;
            $deduction_arr[0]["deduct_01"] = $result[0]->amount;
            $deduction_arr[0]["item_id"] = $result[0]->item_id;
        }

        if (count($result) > 1) {
            $deduction_arr[1]["deduct_trans_id_02"] = $result[1]->narration;
            $deduction_arr[1]["deduct_02"] = $result[1]->amount;
            $deduction_arr[1]["item_id"] = $result[1]->item_id;
        }

        if (count($result) > 2) {
            $deduction_arr[2]["deduct_trans_id_03"] = $result[2]->narration;
            $deduction_arr[2]["deduct_03"] = $result[2]->amount;
            $deduction_arr[2]["item_id"] = $result[2]->item_id;
        }

        if (count($result) > 3) {
            $deduction_arr[3]["deduct_trans_id_04"] = $result[3]->narration;
            $deduction_arr[3]["deduct_04"] = $result[3]->amount;
            $deduction_arr[3]["item_id"] = $result[3]->item_id;
        }

        if (count($result) > 4) {
            $deduction_arr[4]["deduct_trans_id_05"] = $result[4]->narration;
            $deduction_arr[4]["deduct_05"] = $result[4]->amount;
            $deduction_arr[4]["item_id"] = $result[4]->item_id;
        }

        if (count($result) > 5) {
            $deduction_arr[5]["deduct_trans_id_06"] = $result[5]->narration;
            $deduction_arr[5]["deduct_06"] = $result[5]->amount;
            $deduction_arr[5]["item_id"] = $result[5]->item_id;
        }

        if (count($result) > 6) {
            $deduction_arr[6]["deduct_trans_id_07"] = $result[6]->narration;
            $deduction_arr[6]["deduct_07"] = $result[6]->amount;
            $deduction_arr[6]["item_id"] = $result[6]->item_id;
        }

        if (count($result) > 7) {
            $deduction_arr[7]["deduct_trans_id_08"] = $result[7]->narration;
            $deduction_arr[7]["deduct_08"] = $result[7]->amount;
            $deduction_arr[7]["item_id"] = $result[7]->item_id;
        }

        if (count($result) > 8) {
            $deduction_arr[8]["deduct_trans_id_09"] = $result[8]->narration;
            $deduction_arr[8]["deduct_09"] = $result[8]->amount;
            $deduction_arr[8]["item_id"] = $result[8]->item_id;
        }

        if (count($result) > 9) {
            $deduction_arr[9]["deduct_trans_id_10"] = $result[9]->narration;
            $deduction_arr[9]["deduct_10"] = $result[9]->amount;
            $deduction_arr[9]["item_id"] = $result[9]->item_id;
        }

        return $deduction_arr;
    }




    public function employeeSalaryData($id)
    {
        try {
            $salary_data = SalaryData::find($id);
            if ($salary_data) {
                $employee = Employee::find($salary_data->employee_id);
                $employee->category_name = EmployeeCategory::find($employee->category_id)->category;
                $employee->category_work_day = EmployeeCategory::find($employee->category_id)->work_days_month;
                $employee->category_work_hour = EmployeeCategory::find($employee->category_id)->work_hour_day;
                $employee->category_epf_employer = EmployeeCategory::find($employee->category_id)->epf_employer;
                $employee->category_epf_employee = EmployeeCategory::find($employee->category_id)->epf_employee;
                $employee->category_etf_employee = EmployeeCategory::find($employee->category_id)->etf_employee;

                $employee->category_ot_rate1 = EmployeeCategory::find($employee->category_id)->ot_rate1;
                $employee->category_ot_rate2 = EmployeeCategory::find($employee->category_id)->ot_rate2;
                $employee->category_ot_rate3 = EmployeeCategory::find($employee->category_id)->ot_rate3;

                $employee->category_budget_allowance1 = EmployeeCategory::find($employee->category_id)->budget_allowance1;
                $employee->category_budget_allowance2 = EmployeeCategory::find($employee->category_id)->budget_allowance2;
                $employee->category_fine_rate = EmployeeCategory::find($employee->category_id)->fine_rate;

                $employee->site_name = EmployeeSite::find($employee->site_id)->site;
                $employee->department_name = EmployeeDepartment::find($employee->department_id)->department;
                $employee->section_name = EmployeeSection::find($employee->section_id)->section;
                $employee->subsection_name = EmployeeSubsection::find($employee->subsection_id)->subsection;
                $employee->company_name = Company::find($employee->company_id)->company;
                $employee->basic_salary = $this->basicSalary($employee->employee_id);
                $employee->earnings = $this->salaryDataEarnings($id);
                $employee->deductions = $this->salaryDataDeductions($id);
            }
            $salary_data->employee_data = $employee;
            $responseBody = $this->responseBody(true, "Employee", "employeeData", $salary_data);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    private function salaryDataEarnings($salary_id)
    {
        $earning_arr = [
            ["earn_trans_id_01" => 0, "earn_01" => 0, "item_id" => 0],
            ["earn_trans_id_02" => 0, "earn_02" => 0, "item_id" => 0],
            ["earn_trans_id_03" => 0, "earn_03" => 0, "item_id" => 0],
            ["earn_trans_id_04" => 0, "earn_04" => 0, "item_id" => 0],
            ["earn_trans_id_05" => 0, "earn_05" => 0, "item_id" => 0],
            ["earn_trans_id_06" => 0, "earn_06" => 0, "item_id" => 0],
            ["earn_trans_id_07" => 0, "earn_07" => 0, "item_id" => 0],
            ["earn_trans_id_08" => 0, "earn_08" => 0, "item_id" => 0],
            ["earn_trans_id_09" => 0, "earn_09" => 0, "item_id" => 0],
            ["earn_trans_id_10" => 0, "earn_10" => 0, "item_id" => 0],
        ];

        $query = "SELECT 
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = earn_trans_id_01 AND hr_transaction_item_setups.`status` = '1') AS earn_trans_id_01,earn_01,earn_trans_id_01 AS earn_trans_item_id_01,
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = earn_trans_id_02 AND hr_transaction_item_setups.`status` = '1') AS earn_trans_id_02,earn_02,earn_trans_id_02 AS earn_trans_item_id_02, 
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = earn_trans_id_03 AND hr_transaction_item_setups.`status` = '1') AS earn_trans_id_03,earn_03,earn_trans_id_03 AS earn_trans_item_id_03,
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = earn_trans_id_04 AND hr_transaction_item_setups.`status` = '1') AS earn_trans_id_04,earn_04,earn_trans_id_04 AS earn_trans_item_id_04, 
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = earn_trans_id_05 AND hr_transaction_item_setups.`status` = '1') AS earn_trans_id_05,earn_05,earn_trans_id_05 AS earn_trans_item_id_05,
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = earn_trans_id_06 AND hr_transaction_item_setups.`status` = '1') AS earn_trans_id_06,earn_06,earn_trans_id_06 AS earn_trans_item_id_06, 
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = earn_trans_id_07 AND hr_transaction_item_setups.`status` = '1') AS earn_trans_id_07,earn_07,earn_trans_id_07 AS earn_trans_item_id_07,
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = earn_trans_id_08 AND hr_transaction_item_setups.`status` = '1') AS earn_trans_id_08,earn_08,earn_trans_id_08 AS earn_trans_item_id_08, 
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = earn_trans_id_09 AND hr_transaction_item_setups.`status` = '1') AS earn_trans_id_09,earn_09,earn_trans_id_09 AS earn_trans_item_id_09,
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = earn_trans_id_10 AND hr_transaction_item_setups.`status` = '1') AS earn_trans_id_10,earn_10,earn_trans_id_10 AS earn_trans_item_id_10
        FROM hr_salary_data WHERE id = '" . $salary_id . "'";

        $result = DB::select($query);
        if (count($result) > 0) {
            $earning_arr[0]["earn_trans_id_01"] = $result[0]->earn_trans_id_01;
            $earning_arr[0]["earn_01"] = $result[0]->earn_01;
            $earning_arr[0]["item_id"] = $result[0]->earn_trans_item_id_01;

            $earning_arr[1]["earn_trans_id_02"] = $result[0]->earn_trans_id_02;
            $earning_arr[1]["earn_02"] = $result[0]->earn_02;
            $earning_arr[1]["item_id"] = $result[0]->earn_trans_item_id_02;

            $earning_arr[2]["earn_trans_id_03"] = $result[0]->earn_trans_id_03;
            $earning_arr[2]["earn_03"] = $result[0]->earn_03;
            $earning_arr[2]["item_id"] = $result[0]->earn_trans_item_id_03;

            $earning_arr[3]["earn_trans_id_04"] = $result[0]->earn_trans_id_04;
            $earning_arr[3]["earn_04"] = $result[0]->earn_04;
            $earning_arr[3]["item_id"] = $result[0]->earn_trans_item_id_04;

            $earning_arr[4]["earn_trans_id_05"] = $result[0]->earn_trans_id_05;
            $earning_arr[4]["earn_05"] = $result[0]->earn_05;
            $earning_arr[4]["item_id"] = $result[0]->earn_trans_item_id_05;

            $earning_arr[5]["earn_trans_id_06"] = $result[0]->earn_trans_id_06;
            $earning_arr[5]["earn_06"] = $result[0]->earn_06;
            $earning_arr[5]["item_id"] = $result[0]->earn_trans_item_id_06;

            $earning_arr[6]["earn_trans_id_07"] = $result[0]->earn_trans_id_07;
            $earning_arr[6]["earn_07"] = $result[0]->earn_07;
            $earning_arr[6]["item_id"] = $result[0]->earn_trans_item_id_07;

            $earning_arr[7]["earn_trans_id_08"] = $result[0]->earn_trans_id_08;
            $earning_arr[7]["earn_08"] = $result[0]->earn_08;
            $earning_arr[7]["item_id"] = $result[0]->earn_trans_item_id_08;

            $earning_arr[8]["earn_trans_id_09"] = $result[0]->earn_trans_id_09;
            $earning_arr[8]["earn_09"] = $result[0]->earn_09;
            $earning_arr[8]["item_id"] = $result[0]->earn_trans_item_id_09;
        }

        return $earning_arr;
    }




    private function salaryDataDeductions($salary_id)
    {
        $deduction_arr = [
            ["deduct_trans_id_01" => 0, "deduct_01" => 0, "item_id" => 0],
            ["deduct_trans_id_02" => 0, "deduct_02" => 0, "item_id" => 0],
            ["deduct_trans_id_03" => 0, "deduct_03" => 0, "item_id" => 0],
            ["deduct_trans_id_04" => 0, "deduct_04" => 0, "item_id" => 0],
            ["deduct_trans_id_05" => 0, "deduct_05" => 0, "item_id" => 0],
            ["deduct_trans_id_06" => 0, "deduct_06" => 0, "item_id" => 0],
            ["deduct_trans_id_07" => 0, "deduct_07" => 0, "item_id" => 0],
            ["deduct_trans_id_08" => 0, "deduct_08" => 0, "item_id" => 0],
            ["deduct_trans_id_09" => 0, "deduct_09" => 0, "item_id" => 0],
            ["deduct_trans_id_10" => 0, "deduct_10" => 0, "item_id" => 0],
        ];

        $query = "SELECT 
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = deduct_trans_id_01 AND hr_transaction_item_setups.`status` = '1') AS deduct_trans_id_01,deduct_01,deduct_trans_id_01 AS deduct_trans_item_id_01,
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = deduct_trans_id_02 AND hr_transaction_item_setups.`status` = '1') AS deduct_trans_id_02,deduct_02,deduct_trans_id_02 AS deduct_trans_item_id_02, 
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = deduct_trans_id_03 AND hr_transaction_item_setups.`status` = '1') AS deduct_trans_id_03,deduct_03,deduct_trans_id_03 AS deduct_trans_item_id_03,
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = deduct_trans_id_04 AND hr_transaction_item_setups.`status` = '1') AS deduct_trans_id_04,deduct_04,deduct_trans_id_04 AS deduct_trans_item_id_04, 
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = deduct_trans_id_05 AND hr_transaction_item_setups.`status` = '1') AS deduct_trans_id_05,deduct_05,deduct_trans_id_05 AS deduct_trans_item_id_05,
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = deduct_trans_id_06 AND hr_transaction_item_setups.`status` = '1') AS deduct_trans_id_06,deduct_06,deduct_trans_id_06 AS deduct_trans_item_id_06, 
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = deduct_trans_id_07 AND hr_transaction_item_setups.`status` = '1') AS deduct_trans_id_07,deduct_07,deduct_trans_id_07 AS deduct_trans_item_id_07,
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = deduct_trans_id_08 AND hr_transaction_item_setups.`status` = '1') AS deduct_trans_id_08,deduct_08,deduct_trans_id_08 AS deduct_trans_item_id_08, 
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = deduct_trans_id_09 AND hr_transaction_item_setups.`status` = '1') AS deduct_trans_id_09,deduct_09,deduct_trans_id_09 AS deduct_trans_item_id_09,
        (SELECT hr_transaction_item_setups.narration FROM hr_transaction_item_setups WHERE hr_transaction_item_setups.item_id = deduct_trans_id_10 AND hr_transaction_item_setups.`status` = '1') AS deduct_trans_id_10,deduct_10,deduct_trans_id_10 AS deduct_trans_item_id_10
        FROM hr_salary_data WHERE id = '" . $salary_id . "'";

        $result = DB::select($query);
        if (count($result) > 0) {
            $deduction_arr[0]["deduct_trans_id_01"] = $result[0]->deduct_trans_id_01;
            $deduction_arr[0]["deduct_01"] = $result[0]->deduct_01;
            $deduction_arr[0]["item_id"] = $result[0]->deduct_trans_item_id_01;

            $deduction_arr[1]["deduct_trans_id_02"] = $result[0]->deduct_trans_id_02;
            $deduction_arr[1]["deduct_02"] = $result[0]->deduct_02;
            $deduction_arr[1]["item_id"] = $result[0]->deduct_trans_item_id_02;

            $deduction_arr[2]["deduct_trans_id_03"] = $result[0]->deduct_trans_id_03;
            $deduction_arr[2]["deduct_03"] = $result[0]->deduct_03;
            $deduction_arr[2]["item_id"] = $result[0]->deduct_trans_item_id_03;

            $deduction_arr[3]["deduct_trans_id_04"] = $result[0]->deduct_trans_id_04;
            $deduction_arr[3]["deduct_04"] = $result[0]->deduct_04;
            $deduction_arr[3]["item_id"] = $result[0]->deduct_trans_item_id_04;

            $deduction_arr[4]["deduct_trans_id_05"] = $result[0]->deduct_trans_id_05;
            $deduction_arr[4]["deduct_05"] = $result[0]->deduct_05;
            $deduction_arr[4]["item_id"] = $result[0]->deduct_trans_item_id_05;

            $deduction_arr[5]["deduct_trans_id_06"] = $result[0]->deduct_trans_id_06;
            $deduction_arr[5]["deduct_06"] = $result[0]->deduct_06;
            $deduction_arr[5]["item_id"] = $result[0]->deduct_trans_item_id_06;

            $deduction_arr[6]["deduct_trans_id_07"] = $result[0]->deduct_trans_id_07;
            $deduction_arr[6]["deduct_07"] = $result[0]->deduct_07;
            $deduction_arr[6]["item_id"] = $result[0]->deduct_trans_item_id_07;

            $deduction_arr[7]["deduct_trans_id_08"] = $result[0]->deduct_trans_id_08;
            $deduction_arr[7]["deduct_08"] = $result[0]->deduct_08;
            $deduction_arr[7]["item_id"] = $result[0]->deduct_trans_item_id_08;

            $deduction_arr[8]["deduct_trans_id_09"] = $result[0]->deduct_trans_id_09;
            $deduction_arr[8]["deduct_09"] = $result[0]->deduct_09;
            $deduction_arr[8]["item_id"] = $result[0]->deduct_trans_item_id_09;
        }

        return $deduction_arr;
    }







    /**
     * save
     * This function is used to save salary sheet.
     * @param request This is the paramter for save details.
     */
    public function save(Request $request)
    {

        try {
            $date = Carbon::now();
            $salary_year = explode("-", $date)[0];
            $salary_month = explode("-", $date)[1];

            $salaryData = new SalaryData();
            $salaryData->employee_id = $request->get('employee_id');
            $salaryData->category_id = $request->get('category_id');
            $salaryData->site_id = $request->get('site_id');
            $salaryData->department_id = $request->get('department_id');
            $salaryData->section_id = $request->get('section_id');
            $salaryData->subsection_id = $request->get('subsection_id');
            $salaryData->company_id = $request->get('company_id');
            $salaryData->basic_salary = $request->get('basic_salary');
            $salaryData->ot_hours1 = $request->get('ot_hours1');
            $salaryData->ot_rate1 = $request->get('ot_rate1');
            $salaryData->ot_rate1_amount = $request->get('ot_rate1_amount');
            $salaryData->ot_amount1 = $request->get('ot_amount1');
            $salaryData->ot_hours2 = $request->get('ot_hours2');
            $salaryData->ot_rate2 = $request->get('ot_rate2');
            $salaryData->ot_rate2_amount = $request->get('ot_rate2_amount');
            $salaryData->ot_amount2 = $request->get('ot_amount2');
            $salaryData->ot_hours3 = $request->get('ot_hours3');
            $salaryData->ot_rate3 = $request->get('ot_rate3');
            $salaryData->ot_rate3_amount = $request->get('ot_rate3_amount');
            $salaryData->ot_amount3 = $request->get('ot_amount3');
            $salaryData->advance = $request->get('advance');
            $salaryData->loan = $request->get('loan');
            $salaryData->loan_interest = $request->get('loan_interest');
            $salaryData->debtor_loan = $request->get('debtor_loan');
            $salaryData->debtor_loan_interest = $request->get('debtor_loan_interest');
            $salaryData->worked_days = $request->get('worked_days');
            $salaryData->additional_worked_days = $request->get('additional_worked_days');
            $salaryData->nopay_days = $request->get('nopay_days');
            $salaryData->nopay_amount = $request->get('nopay_amount');
            $salaryData->budget1 = $request->get('budget1');
            $salaryData->budget2 = $request->get('budget2');
            $salaryData->employer_epf = $request->get('employer_epf');
            $salaryData->employee_epf = $request->get('employee_epf');

            $salaryData->employee_etf = $request->get('employee_etf');
            $salaryData->tax1 = $request->get('tax1');
            $salaryData->tax2 = $request->get('tax2');
            $salaryData->fine_hours = $request->get('fine_hours');
            $salaryData->fine_amount = $request->get('fine_amount');
            $salaryData->earn_trans_id_01 = $request->get('earn_trans_id_01');
            $salaryData->earn_01 = $request->get('earn_01');
            $salaryData->earn_trans_id_02 = $request->get('earn_trans_id_02');
            $salaryData->earn_02 = $request->get('earn_02');
            $salaryData->earn_trans_id_03 = $request->get('earn_trans_id_03');
            $salaryData->earn_03 = $request->get('earn_03');
            $salaryData->earn_trans_id_04 = $request->get('earn_trans_id_04');
            $salaryData->earn_04 = $request->get('earn_04');
            $salaryData->earn_trans_id_05 = $request->get('earn_trans_id_05');
            $salaryData->earn_05 = $request->get('earn_05');
            $salaryData->earn_trans_id_06 = $request->get('earn_trans_id_06');
            $salaryData->earn_06 = $request->get('earn_06');
            $salaryData->earn_trans_id_07 = $request->get('earn_trans_id_07');
            $salaryData->earn_07 = $request->get('earn_07');
            $salaryData->earn_trans_id_08 = $request->get('earn_trans_id_08');
            $salaryData->earn_08 = $request->get('earn_08');
            $salaryData->earn_trans_id_09 = $request->get('earn_trans_id_09');
            $salaryData->earn_09 = $request->get('earn_09');
            $salaryData->earn_trans_id_10 = $request->get('earn_trans_id_10');
            $salaryData->earn_10 = $request->get('earn_10');

            $salaryData->deduct_trans_id_01 = $request->get('deduct_trans_id_01');
            $salaryData->deduct_01 = $request->get('deduct_01');
            $salaryData->deduct_trans_id_02 = $request->get('deduct_trans_id_02');
            $salaryData->deduct_02 = $request->get('deduct_02');
            $salaryData->deduct_trans_id_03 = $request->get('deduct_trans_id_03');
            $salaryData->deduct_03 = $request->get('deduct_03');
            $salaryData->deduct_trans_id_04 = $request->get('deduct_trans_id_04');
            $salaryData->deduct_04 = $request->get('deduct_04');
            $salaryData->deduct_trans_id_05 = $request->get('deduct_trans_id_05');
            $salaryData->deduct_05 = $request->get('deduct_05');
            $salaryData->deduct_trans_id_06 = $request->get('deduct_trans_id_06');
            $salaryData->deduct_06 = $request->get('deduct_06');
            $salaryData->deduct_trans_id_07 = $request->get('deduct_trans_id_07');
            $salaryData->deduct_07 = $request->get('deduct_07');
            $salaryData->deduct_trans_id_08 = $request->get('deduct_trans_id_08');
            $salaryData->deduct_08 = $request->get('deduct_08');
            $salaryData->deduct_trans_id_09 = $request->get('deduct_trans_id_09');
            $salaryData->deduct_09 = $request->get('deduct_09');
            $salaryData->deduct_trans_id_10 = $request->get('deduct_trans_id_10');
            $salaryData->deduct_10 = $request->get('deduct_10');
            $salaryData->last_adjustment = $request->get('last_adjustment');
            $salaryData->this_adjustment = $request->get('this_adjustment');
            $salaryData->gross_salary = $request->get('gross_salary');
            $salaryData->total_deduction = $request->get('total_deduction');
            $salaryData->net_salary = $request->get('net_salary');
            $salaryData->salary_year = $salary_year;
            $salaryData->salary_month = $salary_month;
            $save = $salaryData->save();

            $responseBody = $this->responseBody(false, "SalaryData", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SalaryData", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }








    /**
     * update
     * This function is used to update salary sheet.
     * @param request This is the paramter for update details.
     */
    public function update(Request $request, $id)
    {

        try {
            $salaryData = SalaryData::find($id);
            $salaryData->employee_id = $request->get('employee_id');
            $salaryData->category_id = $request->get('category_id');
            $salaryData->site_id = $request->get('site_id');
            $salaryData->department_id = $request->get('department_id');
            $salaryData->section_id = $request->get('section_id');
            $salaryData->subsection_id = $request->get('subsection_id');
            $salaryData->company_id = $request->get('company_id');
            $salaryData->basic_salary = $request->get('basic_salary');
            $salaryData->ot_hours1 = $request->get('ot_hours1');
            $salaryData->ot_rate1_amount = $request->get('ot_rate1_amount');
            $salaryData->ot_amount1 = $request->get('ot_amount1');
            $salaryData->ot_hours2 = $request->get('ot_hours2');
            $salaryData->ot_rate2_amount = $request->get('ot_rate2_amount');
            $salaryData->ot_amount2 = $request->get('ot_amount2');
            $salaryData->ot_hours3 = $request->get('ot_hours3');
            $salaryData->ot_rate3_amount = $request->get('ot_rate3_amount');
            $salaryData->ot_amount3 = $request->get('ot_amount3');
            $salaryData->advance = $request->get('advance');
            $salaryData->loan = $request->get('loan');
            $salaryData->loan_interest = $request->get('loan_interest');
            $salaryData->debtor_loan = $request->get('debtor_loan');
            $salaryData->debtor_loan_interest = $request->get('debtor_loan_interest');
            $salaryData->worked_days = $request->get('worked_days');
            $salaryData->additional_worked_days = $request->get('additional_worked_days');
            $salaryData->nopay_days = $request->get('nopay_days');
            $salaryData->nopay_amount = $request->get('nopay_amount');
            $salaryData->budget1 = $request->get('budget1');
            $salaryData->budget2 = $request->get('budget2');
            $salaryData->employer_epf = $request->get('employer_epf');
            $salaryData->employee_epf = $request->get('employee_epf');

            $salaryData->employee_etf = $request->get('employee_etf');
            $salaryData->tax1 = $request->get('tax1');
            $salaryData->tax2 = $request->get('tax2');
            $salaryData->fine_hours = $request->get('fine_hours');
            $salaryData->fine_amount = $request->get('fine_amount');
            $salaryData->earn_trans_id_01 = $request->get('earn_trans_id_01');
            $salaryData->earn_01 = $request->get('earn_01');
            $salaryData->earn_trans_id_02 = $request->get('earn_trans_id_02');
            $salaryData->earn_02 = $request->get('earn_02');
            $salaryData->earn_trans_id_03 = $request->get('earn_trans_id_03');
            $salaryData->earn_03 = $request->get('earn_03');
            $salaryData->earn_trans_id_04 = $request->get('earn_trans_id_04');
            $salaryData->earn_04 = $request->get('earn_04');
            $salaryData->earn_trans_id_05 = $request->get('earn_trans_id_05');
            $salaryData->earn_05 = $request->get('earn_05');
            $salaryData->earn_trans_id_06 = $request->get('earn_trans_id_06');
            $salaryData->earn_06 = $request->get('earn_06');
            $salaryData->earn_trans_id_07 = $request->get('earn_trans_id_07');
            $salaryData->earn_07 = $request->get('earn_07');
            $salaryData->earn_trans_id_08 = $request->get('earn_trans_id_08');
            $salaryData->earn_08 = $request->get('earn_08');
            $salaryData->earn_trans_id_09 = $request->get('earn_trans_id_09');
            $salaryData->earn_09 = $request->get('earn_09');
            $salaryData->earn_trans_id_10 = $request->get('earn_trans_id_10');
            $salaryData->earn_10 = $request->get('earn_10');

            $salaryData->deduct_trans_id_01 = $request->get('deduct_trans_id_01');
            $salaryData->deduct_01 = $request->get('deduct_01');
            $salaryData->deduct_trans_id_02 = $request->get('deduct_trans_id_02');
            $salaryData->deduct_02 = $request->get('deduct_02');
            $salaryData->deduct_trans_id_03 = $request->get('deduct_trans_id_03');
            $salaryData->deduct_03 = $request->get('deduct_03');
            $salaryData->deduct_trans_id_04 = $request->get('deduct_trans_id_04');
            $salaryData->deduct_04 = $request->get('deduct_04');
            $salaryData->deduct_trans_id_05 = $request->get('deduct_trans_id_05');
            $salaryData->deduct_05 = $request->get('deduct_05');
            $salaryData->deduct_trans_id_06 = $request->get('deduct_trans_id_06');
            $salaryData->deduct_06 = $request->get('deduct_06');
            $salaryData->deduct_trans_id_07 = $request->get('deduct_trans_id_07');
            $salaryData->deduct_07 = $request->get('deduct_07');
            $salaryData->deduct_trans_id_08 = $request->get('deduct_trans_id_08');
            $salaryData->deduct_08 = $request->get('deduct_08');
            $salaryData->deduct_trans_id_09 = $request->get('deduct_trans_id_09');
            $salaryData->deduct_09 = $request->get('deduct_09');
            $salaryData->deduct_trans_id_10 = $request->get('deduct_trans_id_10');
            $salaryData->deduct_10 = $request->get('deduct_10');
            $salaryData->last_adjustment = $request->get('last_adjustment');
            $salaryData->this_adjustment = $request->get('this_adjustment');
            $salaryData->gross_salary = $request->get('gross_salary');
            $salaryData->total_deduction = $request->get('total_deduction');
            $salaryData->net_salary = $request->get('net_salary');
            $update = $salaryData->update();

            $responseBody = $this->responseBody(false, "SalaryData", "updated", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SalaryData", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function isMonthEndProcess()
    {
        try {

            $global_settings = GlobalSettings::find('1');
            $responseBody = $this->responseBody(true, "Month End Process", "Salary Sheet", ['year' => $global_settings->current_payroll_year, 'month' => $global_settings->current_payroll_month]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Month End Process", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function getBasisMethod($id)
    {
        try {
            $basisMethod = null;
            $employee = Employee::find($id);
            if ($employee) {
                $category = EmployeeCategory::find($employee->category_id);
                if ($category) {
                    if ($category->wage_calculate == 1) {
                        $basisMethod = "Hour Basis";
                    } else if ($category->wage_calculate == 2) {
                        $basisMethod = "Day Basis";
                    }
                    if ($category->wage_calculate == 3) {
                        $basisMethod = "Month Basis";
                    }
                }
            }
            $responseBody = $this->responseBody(true, "Basis Method", "Salary Sheet", $basisMethod);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Month End Process", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
