class Card {

    static newCard(result) {

        return Card.layout(result);
    }

    static layout(result) {
        var layout = '<div class="idcard"><table class="card-main-layout"><tr>';
        layout += Card.frontLayout(result);
        layout += Card.backLayout(result);
        layout += '</tr></table></div>';
        return layout;
    }


    static frontLayout(result) {
        var layout = '<td class="front"><div class="front-container">';
        layout += Card.frontHeaderBand();
        layout += Card.frontDetailBand(result);
        layout += Card.frontFooterBand(result);
        layout += '</div></td>';
        return layout;
    }

    static backLayout(result) {
        var layout = '<td class="back"><div class="back-container">';
        layout += Card.backDetailBand(result);
        layout += Card.backFooterBand(result);
        layout += '</div></td>';
        return layout;
    }

    static frontHeaderBand() {
        var title = 'Office & Leisure Development Project';
        var layout = '<div id="title-div"><label>' + title + '</label></div>';
        return layout;
    }

    static frontDetailBand(result) {
        var image = result['photo_parth'];
        var layout = '<table id="front-layout1" border="0"><tr><td id="front-layout1-col1"><img class="img img-thumbnail" src="' + image + '"></td><td id="front-layout1-col2">';
        layout += Card.frontSubTitleBand();
        layout += Card.frontSubDetailBand(result);
        layout += '</td></tr></table>';
        return layout;
    }

    static frontSubTitleBand() {
        var title1 = 'SKRJ Project';
        var title2 = 'Entering the institution only';
        var layout = '<table id="front-layout1-col2-sublayout1" border="0"><tr><td>' + title1 + '</td></tr><tr><td>' + title2 + '</td></tr></table>';
        return layout;
    }

    static frontSubDetailBand(result) {

        var employee_id = result['employee_id'];
        var nic = result['nic'];
        var designation = result['designation'];
        var name = result['name_withinitial'];

        var layout = '<table id="front-layout1-col2-sublayout2" border="0">' +
            '<tr>' +
            '<td id="front-layout1-col2-sublayout2-col1">EMP N0</td>' +
            '<td id="front-layout1-col2-sublayout2-col2">:' + employee_id + '</td>' +
            '</tr>' +
            '<tr>' +
            '<td id="front-layout1-col2-sublayout2-col1">NIC</td>' +
            '<td id="front-layout1-col2-sublayout2-col2">:' + nic + '</td>' +
            '</tr>' +
            '<tr>' +
            '<td id="front-layout1-col2-sublayout2-col1">DESIG</td>' +
            '<td id="front-layout1-col2-sublayout2-col2">:' + designation + '</td>' +
            '</tr>' +
            '<tr>' +
            '<td id="front-layout1-col2-sublayout2-col1">NAME</td>' +
            '<td id="front-layout1-col2-sublayout2-col2">:' + name + '</td>' +
            '</tr>' +
            '</table>';
        return layout;
    }

    static frontFooterBand(result) {
        var subcontractor = result['subcontractor'];
        var address = result['address'];
        var layout = '<table id="footer-layout" border="0">' +
            '<tr>' +
            '<td id="footer-layout-col1">Sub Con</td>' +
            '<td id="footer-layout-col2">:' + subcontractor + '</td>' +
            '</tr>' +
            '<tr>' +
            '<td id="footer-layout-col1">Address</td>' +
            '<td id="footer-layout-col2">:' + address + '</td>' +
            '</tr>' +
            '</table>';
        return layout;
    }

    static backDetailBand(result) {
        var detail1 = '01.This pass must be with the employee if working at the site.';
        var detail2 = '02.This pass connot be tranferred.';
        var detail3 = '03.This pass must be surrenderd if requested.';
        var detail4 = '04.Use for any other purposes strictly prohibited.';
        var layout = '<table id="back-layout1" border="0">' +
            '<tr>' +
            '<td>' + detail1 + '</td>' +
            '</tr>' +
            '<tr>' +
            '<td>' + detail2 + '</td>' +
            '</tr>' +
            '<tr>' +
            '<td>' + detail3 + '</td>' +
            '</tr>' +
            '<tr>' +
            '<td>' + detail4 + '</td>' +
            '</tr>' +
            '</table>';
        return layout;
    }

    static backFooterBand(result) {
        var issue_date = result['id_issue_date'];
        var expire_date = result['id_expire_date'];

        var layout = '<table id="back-layout2" border="0">' +
            '<tr>' +
            '<td id="back-layout2-col">' +
            '<div>' +
            '<label>Issue Date</label>' +
            '</div>' +
            '<div>' +
            '<label>' + issue_date + '</label>' +
            '</div>' +
            '</td>' +
            '<td id="back-layout2-col">' +
            '<div>' +
            '<label>Expire Date</label>' +
            '</div>' +
            '<div>' +
            '<label>' + expire_date + '</label>' +
            '</div>' +
            '</td>' +
            '</tr>' +
            '<tr>' +
            '<td id="back-layout2-colx1"></td>' +
            '<td id="back-layout2-colx1"></td>' +
            '</tr>' +
            '<tr>' +
            '<td id="back-layout2-col">........................</td>' +
            '<td id="back-layout2-col">........................</td>' +
            '</tr>' +
            '<tr>' +
            '<td id="back-layout2-col">' +
            'Authorized By' +
            '</td>' +
            '<td id="back-layout2-col">' +
            'Card Holder' +
            '</td>' +
            '</tr>' +
            '</table>';
        return layout;
    }
}