$(document).ready(function () {
    $('#btnResetRecruitment').hide();

    $('input[name="dtePost"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });

    $('input[name="dteExpire"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });

    let today = new Date().toISOString().substr(0, 10);
    document.querySelector("#dtePost").value = today;
    document.querySelector("#dteExpire").value = today;


    //Toast library for message
    toastr.options = {
        timeOut: 3000,
        progressBar: true,
        showMethod: "slideDown",
        hideMethod: "slideUp",
        showDuration: 200,
        hideDuration: 200
    };
    ///////////

    allSettings();//when call this function, all settings auto load


    //save recruitment 
    $('#btnSaveRecruitment').click(function (event) {
        event.preventDefault();
        var form = $('#recruitmentForm').get(0);
        var data = new FormData(form);

        if ($('#btnSaveRecruitment').text() == "Save") {
            save(data);
        } else if ($('#btnSaveRecruitment').text() == "Update") {
            //var id = $('#hidUserID').val();
            update2(data);
        }

    });

    /**
        * resetRecruitment
        * This function is used to reset form.
        */
    $('#btnResetRecruitment').click(function (event) {
        event.preventDefault();
        resetRecruitment();
    });

    loadRecruitment();

});

/**
* loadRecrutment
* This function used to load recruitment details and settings, in update and view time
*/
function loadRecruitment() {

    if (window.location.search.length > 0) {
        $('#btnResetRecruitment').show();
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('&');

        if (param.length == 2) {
            $('#btnSaveRecruitment').hide();
        } else {
            $('#btnSaveRecruitment').show();
        }

        var id = param[0];
        $('#hidUserID').val(id);
        $.ajax({
            type: "GET",
            url: "/hr/recruitment/recruitment/" + id,
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {

            },
            success: function (response) {
                console.log(response);
                var job_role = response.data.result['recruitment_request']['job_role'];
                var no_of_vacant = response.data.result['recruitment_request']['no_of_vacant'];
                var post_date = response.data.result['recruitment_request']['post_date'];
                var expire_date = response.data.result['recruitment_request']['expire_date'];
                var age_from = response.data.result['recruitment_request']['age_from'];
                var age_to = response.data.result['recruitment_request']['age_to'];
                var education_qualification = response.data.result['recruitment_request']['education_qualification'];
                var experience = response.data.result['recruitment_request']['experience'];
                var remarks = response.data.result['recruitment_request']['remarks'];

                
                var designation = response.data.result['settings']['designation'];
                var department = response.data.result['settings']['department'];


                $('#txtJobRole').val(job_role);
                $('#txtVacancies').val(no_of_vacant);
                $('#dtePost').val(post_date);
                $('#dteExpire').val(expire_date);
                $('#txtAgeFrom').val(age_from);
                $('#txtTo').val(age_to);
                $('#txtEducation').val(education_qualification);
                $('#txtExperience').val(experience);
                $('#txtRemarks').val(remarks);


                $("#selcDesignation option").filter(function () {
                    return $(this).text() == designation;
                }).prop('selected', true);

                $("#selcDepartment option").filter(function () {
                    return $(this).text() == department;
                }).prop('selected', true);

                $('#btnSaveRecruitment').text('Update');

            },
            error: function (error) {
                console.log(error);

            },
            complete: function () {

            }

        });
    }


}


//**
//* save
//* This function is used to save recruitment.
//* @param dara This is the paramter to ajax data
//*/
function save(data) {

    $.ajax({
        type: "POST",
        enctype: 'multipart/form-data',
        url: '/hr/recruitment_request',
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
           
            if (response.data.success) {

                showSuccessMessage("Recruitment has been saved successfully...");
                resetRecruitment();

            } else {
                showErrorMessage();
            }


        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}


/**
* allSettings
* This function is used to load all settings.
*/
function allSettings() {
    $.ajax({
        type: "GET",
        url: "/hr/recruitment/settings",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var result = response.data.result;
                appendSettings(result);
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}


/**
* appendSettings
* This function is used append option to combobox.
* @param collection This is the paramter to combobox elements item
*/
function appendSettings(collection) {
    
    $.each(collection['Department'], function (index, value) {        
        $('#selcDepartment').append('<option value="' + value['department_id'] + '">' + value['department'] + '</option>');
    });
   
    $.each(collection['Designation'], function (index, value) {
        $('#selcDesignation').append('<option value="' + value['designation_id'] + '">' + value['designation'] + '</option>');
    });
   
}

/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* show WarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}

/**
* update
* This function is used to update recruitment.
* @param data This is the paramter to ajax data
*/
function update2(data) {

    $.ajax({
        type: "POST",
        enctype: 'multipart/form-data',
        url: '/hr/recruitment/update',
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Recruiment has been updated successfully...");

            } else {
                showErrorMessage();
            }


        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            location.href = "/hr/recruitment_request_list";
        }

    });
}



function resetRecruitment() {
    $('#recruitmentForm').trigger("reset");
    $('#btnResetRecruitment').hide();
    $('#btnSaveRecruitment').text('Save');
    $('#btnSaveRecruitment').show();
}


