

$(document).ready(function () {
    $('#tblTeam').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "team_id" },
            { "data": "team" },
            { "data": "leader" },
            { "data": "edit", className: "edit" },
            { "data": "view", className: "view" },
            { "data": "delete", className: "delete" },
            { "data": "status", className: "disable" },
        ],
        columnDefs: [
            { width: 120, targets: 0 },
            { width: 50, targets: 3 },
            { width: 50, targets: 4 },
            { width: 50, targets: 5 },
            { width: 50, targets: 6 }
        ],
    });


    allTeams();
    loadEmployee_Name();
});

/**
* loadEmployee_Name
* This function is used to load allemplyee name 
*/
function loadEmployee_Name() {


    $.ajax({
        type: "GET",
        url: '/hr/team/allEmployeeName',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                $("#auto-comp1").setData(response.data.result);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}



function showModal() {
    resetTeam();
    $('#categoryAddModal').modal('toggle');
}

function hideModal() {
    $('#categoryAddModal').modal('hide');
}

function resetTeam() {
    $('#teamForm').trigger("reset");
    $('#btnAction').show();
    $('#btnAction').text('Save');
}



function actionBtn() {

    var text = $('#btnAction').text();
    if (text == "Save") {
        save();
    } else if (text == "Update") {
        update();
    }
}




/**
* save
* This function is used to save employee salary.
*/
function save() {

    var form = $('#teamForm').get(0);
    var data = new FormData(form);

    $.ajax({
        type: "POST",
        url: "/hr/team",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success == true) {
                showSuccessMessage("Team has been saved successfully...");
                hideModal();
                allTeams();
            } else {
                showErrorMessage();

            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}







function allTeams() {
    $.ajax({
        type: "GET",
        url: "/hr/team/allTeams",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var data = [];
                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['team_id'];
                    var teamLader = response.data.result[i]['leader'];
                    var name = response.data.result[i]['team_name'];
                    var string_id = "'" + id + "'";
                    var status = "";
                    if (response.data.result[i]['status'] == 1) {
                        status = "checked";
                    }
                    data.push({
                        "team_id": generateID(id),
                        "team": name,
                        "leader": teamLader,
                        "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>',
                        "status": '<label class="switch"><input type="checkbox" id="1" onchange="disable(event,' + string_id + ')" ' + status + '><span class="slider round"></span></label>'
                    });
                }

                var table = $('#tblTeam').DataTable();
                table.clear();
                table.rows.add(data).draw();
                table.columns('.view').visible(false);
                table.columns('.edit').visible(false);
                table.columns('.delete').visible(false);
                table.columns('.disable').visible(false);



                if (view_permission == 1) {
                    table.columns('.view').visible(true);
                }

                if (edit_permission == 1) {
                    table.columns('.edit').visible(true);
                }

                if (delete_permission == 1) {
                    table.columns('.delete').visible(true);
                }

                if (disable_permission == 1) {
                    table.columns('.disable').visible(true);
                }


            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}







var update_id = 0;
function edit(id) {
    $.ajax({
        type: "GET",
        url: '/hr/team/team/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                showModal();
                update_id = response.data.result.team_id;
                $('#txtTeam').val(response.data.result.team_name);
                $('#auto-comp1').val(response.data.result.leader);
                $('#auto-comp1').attr("data-id", response.data.result.leader_id);
                $('#txtLeaderID').val(response.data.result.leader_id);
                $('#btnAction').text('Update');

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}






function update() {
    $.ajax({
        type: 'PUT',
        url: '/hr/team/update/' + update_id,
        data: $('#teamForm').serialize(),
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Team has been updated successfully...");
                hideModal();
                resetTeam();
                allTeams();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error.message);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}







function view(id) {
    $.ajax({
        type: "GET",
        url: '/hr/team/team/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                showModal();
                $('#txtTeam').val(response.data.result.team_name);
                $('#auto-comp1').val(response.data.result.leader);
                $('#auto-comp1').attr("data-id", response.data.result.leader_id);
                $('#txtLeaderID').val(response.data.result.leader_id);
                $('#btnAction').hide();

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}







function _delete(id) {

    $.ajax({
        type: 'DELETE',
        url: '/hr/team/delete/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Team has been deleted successfully...");
                allTeams();
            } else {

                var msg = response.data.message;

                if (msg == "assigned") {//assigned settings cannot be disabled
                    showWarningMessage("Team has been assigned...!");
                    allTeams();
                } else if (msg == "error") {
                    showErrorMessage();
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }
    });
}






function disable(event, id) {
    var status = 0;
    if (event.target.checked) {
        status = 1;
    }

    $.ajax({
        type: 'PUT',
        url: '/hr/team/disable/' + id,
        data: {
            _token: $('input[name=_token]').val(),
            "status": status
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                if (status == 0) {
                    showSuccessMessage("Team has been disabled successfully...");
                } else {
                    showSuccessMessage("Team has been enabled successfully...");
                }

                allTeams();
            } else {
                var msg = response.data.message;
                var id = response.data.result;

                if (msg == "assigned") {//assigned settings cannot be disabled
                    showWarningMessage("Team has been assigned...!");
                    allTeams();
                } else if (msg == "error") {
                    showErrorMessage();
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}



function autoCompleteSelectedOption(parent, args) {
    $('#txtLeaderID').val(args.id);
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "000",
        2: "00",
        3: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}


function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}

