@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<!-- Css -->
<link rel="stylesheet" href="{{ url('vendors/dropzone/dropzone.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('hr:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">

<style>
    div {
        border: 0px solid black;
    }

    #imgEmployee {
        margin-top: 26px;
        height: 190px;
        width: 190px;
        min-height: 190px;
        min-width: 190px;

    }

    /*the container must be positioned relative:*/
    .autocomplete {
        position: relative;
        display: inline-block;
    }

    input {
        border: 1px solid transparent;
        background-color: #f1f1f1;
        padding: 10px;
        font-size: 16px;
    }

    .autocomplete-items {
        position: absolute;
        border: 1px solid #d4d4d4;
        border-bottom: none;
        border-top: none;
        z-index: 99;
        /*position the autocomplete items to be the same width as the container:*/
        top: 100%;
        left: 0;
        right: 0;
    }

    .autocomplete-items div {
        padding: 10px;
        cursor: pointer;
        background-color: #fff;
        border-bottom: 1px solid #d4d4d4;
    }

    /*when hovering an item:*/
    .autocomplete-items div:hover {
        background-color: #e9e9e9;
    }

    /*when navigating through the items using the arrow keys:*/
    .autocomplete-active {
        background-color: DodgerBlue !important;
        color: #ffffff;
    }
</style>
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Attachment</h6>
                <div class="row">
                    <!--Left side -->
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-md-12 autocomplete">
                                <i class="fa fa-user-o text-info" aria-hidden="true"></i>
                                <label>Employee (Name With Initials)</label>
                                <input type="text" class="form-control auto-complete" id="auto-comp1" name="txtAutoComplete" onchange="autoCompleteOnChange()">
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-12">
                                <i class="fa fa-address-book-o text-info" aria-hidden="true"></i>
                                <label>Address</label>
                                <textarea class="form-control" id="txtEmployeeAddress" name="txtEmployeeAddress"></textarea>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <br>
                                <button type="button" class="btn btn-primary" onclick="openModal()">Attachment</button>
                            </div>
                        </div>
                    </div>
                    <!--Left side end-->

                    <!--Right side -->
                    <div class="col-md-3">
                        <div class="row">
                            <div class="col-md-12">
                                <img class="img img-thumbnail" id="imgEmployee" src="/images/employee.jpg" width="170" height="170">
                            </div>
                        </div>
                    </div>
                    <!--Right side end-->

                </div>
                <br>
                <hr>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <!-- Required for Responsive -->
                            <table id="myTable" class="table table-striped  datatable">
                                <thead>
                                    <tr>
                                        <th class="thTitle">Title</th>
                                        <th class="thView">View</th>
                                        <th class="thDownload">Down</th>
                                        <th class="thDelete">Delete</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<div class="modal fade" id="attachmentAddModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="attachmentAddModalTitle">Add attachment here</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body" id="attachmentAddModalBody">
                <div class="row">
                    <div class="col-md-12">
                        <form action="{{route('upload')}}" class="dropzone" method="POST" id="myAwesomeDropzone" name="myAwesomeDropzone">
                            @csrf
                            <input type="hidden" id="employee_id" name="employee_id" value="">
                            <div class="fallback">
                                <input name="file" type="file" multiple />
                            </div>
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                    </button>
                    <button type="button" class="btn btn-primary" id="btnSetting" onclick="save()">Save</button>
                </div>
            </div>
        </div>
    </div>
    @endsection

    <!-- Javascript -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @section('script')
    <!-- DataTable -->
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ url('assets/js/examples/datatable.js') }}"></script>
    <script src="{{ url('vendors/dropzone/dropzone.js') }}"></script>

    <!-- AutoComplete -->
    <script src="{{ Module::asset('hr:js/autocomplete2/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>

    <script src="{{ Module::asset('hr:js/attachment.js') }}?random=<?php echo uniqid(); ?>"></script>

    <!-- Prism -->
    <script src="{{ url('vendors/prism/prism.js') }}"></script>
    <script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
    @endsection