@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('hr:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">
<script>
    var delete_permission = "{{Auth::user()->can('employee_earn_deduct_setup_remove')}}";
</script>
<style>
    .amount {
        text-align: right;
    }
</style>

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Employee's Allowance</h6>
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <i class="fa fa-money text-info" aria-hidden="true"></i>
                                <label>Allowance</label>
                                <select class="form-control" id="selcAllowance" name="selcAllowance" onchange="allEmployeesAllowance()"></select>
                            </div>
                            <div class="col-md-2 mb-3">
                                <i class="fa fa-money text-info" aria-hidden="true"></i>
                                <label>Amount</label>
                                <input type="text" id="txtAmount" class="form-control">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <hr>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Category</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcCategory" name="selcCategory" onchange="getEmployeeAllowance('category')"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_create'))
                                                        <button type="button" class="btn btn-primary" onclick="applyAllowance('category','selcCategory')">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_remove'))
                                                        <button type="button" class="btn btn-danger" onclick="denyAllowance('category','selcCategory')">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Site</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcSite" name="selcSite" onchange="getEmployeeAllowance('site')"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_create'))
                                                        <button type="button" class="btn btn-primary" onclick="applyAllowance('site','selcSite')">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_remove'))
                                                        <button type="button" class="btn btn-danger" onclick="denyAllowance('site','selcSite')">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Department</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcDepartment" name="selcDepartment" onchange="getEmployeeAllowance('department')"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_create'))
                                                        <button type="button" class="btn btn-primary" onclick="applyAllowance('department','selcDepartment')">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_remove'))
                                                        <button type="button" class="btn btn-danger" onclick="denyAllowance('department','selcDepartment')">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Section</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcSection" name="selcSection" onchange="getEmployeeAllowance('section')"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_create'))
                                                        <button type="button" class="btn btn-primary" onclick="applyAllowance('section','selcSection')">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_remove'))
                                                        <button type="button" class="btn btn-danger" onclick="denyAllowance('section','selcSection')">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Subsection</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcSubsection" name="selcSubsection" onchange="getEmployeeAllowance('subsection')"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_create'))
                                                        <button type="button" class="btn btn-primary" onclick="applyAllowance('subsection','selcSubsection')">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_remove'))
                                                        <button type="button" class="btn btn-danger" onclick="denyAllowance('subsection','selcSubsection')">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Company</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcCompany" name="selcCompany" onchange="getEmployeeAllowance('company')"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_create'))
                                                        <button type="button" class="btn btn-primary" onclick="applyAllowance('company','selcCompany')">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_remove'))
                                                        <button type="button" class="btn btn-danger" onclick="denyAllowance('company','selcCompany')">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>







                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Team</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcTeam" name="selcTeam" onchange="getEmployeeAllowance('team')"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_create'))
                                                        <button type="button" class="btn btn-primary" onclick="applyAllowance('team','selcTeam')">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_remove'))
                                                        <button type="button" class="btn btn-danger" onclick="denyAllowance('team','selcTeam')">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>





                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Employee</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <input type="text" class="form-control auto-complete" id="auto-comp1" onchange="getEmployeeAllowance('employee')">
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_create'))
                                                        <button type="button" class="btn btn-primary" onclick="applyAllowanceByEmployeeID()">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_earn_deduct_setup_remove'))
                                                        <button type="button" class="btn btn-danger" onclick="denyAllowance('employee','auto-comp1')">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                </div>

                <br>
                <div class="row">
                    <div class="col-md-12 seperator">
                        <div class="card bg-primary">
                            <div class="card-header"></div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <table id="tblEmployeeAllowance" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                            <thead>
                                <tr>
                                    <th class="id">Employee ID</th>
                                    <th>Name</th>
                                    <th>Allowance</th>
                                    <th>Amount</th>
                                    <th class="delete">Delete</th>
                                </tr>
                            </thead>
                            <tbody id="tbody"></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

<!-- JQuery -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<!-- AutoComplete -->
<script src="{{ Module::asset('hr:js/autocomplete2/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/progress_widget.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/employeeAllowance.js') }}?random=<?php echo uniqid(); ?>"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection