@extends('hr::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<script>
    var set_permission = "{{Auth::user()->can('employee_team_assign_set')}}";
    var remove_permission = "{{Auth::user()->can('employee_team_assign_remove')}}";
</script>
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>


<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Employee Team</h6>
                <div class="row">
                    <div class="col-md-7">
                        <div class="row">
                            <div class="col-md-8 mb-3">
                                <i class="fa fa-search text-info" aria-hidden="true"></i>
                                <label>Team</label>
                                <select class="form-control" id="cmbTeam" name="team"></select>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <hr>
                    </div>
                </div>



                <div class="row">
                    <div class="col-md-12 seperator">
                        <div class="card bg-primary">
                            <div class="card-header">Team List</div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <table id="tblEmployeeSchedule" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                            <thead>
                                <tr>
                                    <th class="id">Employee ID</th>
                                    <th>Name</th>
                                    <th>Team</th>
                                    <th>Leader</th>
                                    <th>Remove</th>
                                </tr>
                            </thead>
                            <tbody id="tbody"></tbody>
                        </table>
                    </div>
                </div>



                <div class="row">
                    <div class="col-md-12 mb-3">
                        <hr>
                    </div>
                </div>




                <div class="row">
                    <div class="col-md-12 seperator">
                        <div class="card bg-primary">
                            <div class="card-header">Employee List</div>
                        </div>
                    </div>
                </div>


                <div class="row">
                    <div class="col-md-12">
                        {{csrf_field()}}
                        <table id="tblEmployee" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                            <thead>
                                <tr>
                                    <th class="id">Employee ID</th>
                                    <th>Name</th>
                                    <th>Category</th>
                                    <th>Site</th>
                                    <th>Department</th>
                                    <th>Section</th>
                                    <th>Subsection</th>
                                    <th>Set</th>
                                </tr>
                            </thead>
                            <tbody id="tbody"></tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>





<!--<div class="modal fade" id="scheduleAddModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="scheduleAddModalTitle">Add Schedule</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <form method="POST" id="frmSchedule">
                {{csrf_field()}}
                <input type="hidden" id="scheduleID" name="scheduleID" value>
                <div class="modal-body" id="scheduleAddModalBody">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <i class="fa fa-users text-info" aria-hidden="true"></i>
                                    <label>Shift</label>
                                    <select class="form-control" id="cmbShift" name="shift" onchange=""></select>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <i class="fa fa-clock-o text-info" aria-hidden="true"></i>
                                    <label>In time</label>
                                    <div class="input-group clockpicker-example">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">
                                                <i class="fa fa-clock-o"></i>
                                            </span>
                                        </div>
                                        <input type="text" class="form-control" value="18:30" id="txtIntime" name="intime">
                                    </div>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <i class="fa fa-clock-o text-info" aria-hidden="true"></i>
                                    <label>Out time</label>
                                    <div class="input-group clockpicker-example">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">
                                                <i class="fa fa-clock-o"></i>
                                            </span>
                                        </div>
                                        <input type="text" class="form-control" value="18:30" id="txtOuttime" name="outtime">
                                    </div>
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                    <label>Schedule From</label>
                                    <input type="text" class="form-control" name="date" id="txtFromDate" placeholder="YYYY-MM-DD">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                    <label>Schedule To</label>
                                    <input type="text" class="form-control" name="date" id="txtToDate" placeholder="YYYY-MM-DD">
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                    <label>Remark</label>
                                    <input type="text" class="form-control" id="txtRemark" name="remark">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                    </button>
                    <button type="button" class="btn btn-primary" id="btnSetting">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>!-->

@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ Module::asset('hr:js/employeeTeam.js') }}?random=<?php echo uniqid(); ?>"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection