@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/employee.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('hr:js/autocomplete2/css/autocomplete.min.css') }}">
<script>
    var user_id = "{{Auth::user()->user_id}}";
</script>

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3>Form Page</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">


            <div class="card-body">
                <h6 class="card-title">Leave Application</h6>
                <form method="POST" id="leaveForm" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-row">
                                <div class="col-md-12 mb-3">
                                    <i class="fa fa-id-card text-info" aria-hidden="true"></i>
                                    <label for="txtEmployeeID">Employee ID</label>
                                    <input type="hidden" id="hidUserID" name="hidUserID" value="">
                                    <input type="text" class="form-control auto-complete" id="txtEmployeeID" name="txtEmployeeID" placeholder="Employee ID" required="" autocomplete="off">
                                    <div class="valid-feedback">
                                        Looks good!
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-12 mb-3">
                                    <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                    <label for="txtEmpName">Employee Name</label>
                                    <input class="form-control auto-complete" autocomplete="off" id="txtEmpName" name="txtEmpName" onchange="getEmpName()" placeholder="Employee Name" required="" autocomplete="off">
                                    <div class="valid-feedback">
                                        Looks good!
                                    </div>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="col-md-12 mb-3">
                                    <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                    <label for="dteDate">Date</label>
                                    <input type="text" class="form-control" id="dteDate" name="dteDate" placeholder="" required="">
                                    <div class="valid-feedback">
                                        Looks good!
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="col-md-6 mb-3">
                                <div class="col-md-6 mb-1">
                                    <input type="file" class="form-control imgFile" id="imgFile" name="imgFile" accept="image/*">
                                </div>
                                <div class="imgContainer">
                                    <img class="img" src="/images/employee.jpg" id="imgEmployee" width="160" height="160" alt="image/">
                                    <button type="button" class="btn btn-link" id="btnChooser" onclick="chooseFile('imgFile');"><i class="fa fa-folder-open" aria-hidden="true"></i></button>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                    <label for="dteFrom">From</label>
                                    <input type="text" class="form-control" id="dteFrom" name="dteFrom" placeholder="" required="">
                                    <div class="valid-feedback">
                                        Looks good!
                                    </div>
                                </div>
                            </div>


                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                    <label for="dteTo">To</label>
                                    <input type="text" class="form-control" id="dteTo" name="dteTo" placeholder="" required="">
                                    <div class="valid-feedback">
                                        Looks good!
                                    </div>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                    <label for="dteTo">Day Count</label>
                                    <input type="text" class="form-control" id="txtDayCount" name="dayCount">
                                    <div class="valid-feedback">
                                        Looks good!
                                    </div>
                                </div>
                            </div>


                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <i class="fa fa-angle-down text-info" aria-hidden="true"></i>
                                    <label for="selcType">Type</label>
                                    <select class="form-control" id="selcType" name="selcType" onchange="leaveType()"></select>
                                    <div class="valid-feedback">
                                        Looks good!
                                    </div>
                                </div>
                            </div>


                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                    <label for="txtReason">Reason</label>
                                    <textarea class="form-control" id="txtReason" name="txtReason"></textarea>
                                    <div class="valid-feedback">
                                        Looks good!
                                    </div>
                                </div>
                            </div>

                            @if(Auth::user()->can('hr_leave_save'))
                            <button type="button" class="btn btn-primary" id="btnSaveLeave">Save</button>
                            @endif
                            <button type="reset" class="btn btn-warning ml-2" id="btnResetLeave">Cancel</button>

                        </div>
                    </div>
                </form>
                <br>
                <hr>
                <div class="row">
                    <div class="col-md-12 mb-3">
                        <table id="tblLeave" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                            <thead>
                                <tr>
                                    <th>Leave Type</th>
                                    <th>Allocated</th>
                                    <th>Used</th>
                                    <th>Unlimited</th>
                                    <th>Balence</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>

            <br>




        </div>
    </div>
</div>
@endsection

<!-- App scripts -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('assets/js/examples/datatable.js') }}"></script>
<script src="{{ Module::asset('hr:js/autocomplete2/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>

<!-- Javascript -->
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<script src="{{ Module::asset('hr:js/leave.js') }}?random=<?php echo uniqid(); ?>"></script>
<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection