@extends('hr::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.70/pdfmake.js" integrity="sha512-rn5JpU98RtYVMtZeQJfzmJ67rl4/dqDpGZ393z5f9WMYHXEU4+8Stm/PQAma2gbsLbpClmUHJzT0DaG32OmEyQ==" crossorigin="anonymous"></script>
<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/salarySheet.css') }}" type="text/css">

<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('hr:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">


<meta name="csrf-token" content="{{ csrf_token() }}">

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title" id="salary_month_year_display">Salary Sheet : {{ \Carbon\Carbon::now()->format('F Y') }}</h6>
                <div class="row">
                    <div class="col-md-12 seperator">
                        <div class="card bg-primary">
                            <div class="card-header">Employee's Information</div>
                        </div>
                    </div>
                </div>
                <form id="formSalaryData" method="POST">
                    {{ csrf_field() }}
                    <div class="row">
                        <div class="col-md-7">
                            <div class="row">
                                <div class="col-md-4">
                                    <i class="fa fa-search text-info" aria-hidden="true"></i>
                                    <label>Employee ID</label>
                                    <input type="hidden" value="1" id="employee_id" name="employee_id">
                                    <input type="text" class="form-control auto-complete" id="auto-comp1">
                                </div>
                                <div class="col-md-8">
                                    <i class="fa fa-search text-info" aria-hidden="true"></i>
                                    <label>Name(with initials)</label>
                                    <input type="text" class="form-control auto-complete" id="auto-comp2">
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <i class="fa fa-tag text-info" aria-hidden="true"></i>
                                            <label>Category</label>
                                            <input type="hidden" value="1" id="category_id" name="category_id">
                                            <label class="form-control border" id="txtCategory" name="txtCategory"></label>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12">
                                            <i class="fa fa-tag text-info" aria-hidden="true"></i>
                                            <label>Site</label>
                                            <input type="hidden" value="1" id="site_id" name="site_id">
                                            <label class="form-control border" id="txtSite" name="txtSite"></label>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12">
                                            <i class="fa fa-tag text-info" aria-hidden="true"></i>
                                            <label>Department</label>
                                            <input type="hidden" value="1" id="department_id" name="department_id">
                                            <label class="form-control border" id="txtDepartment" name="txtDepartment"></label>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12">
                                            <i class="fa fa-tag text-info" aria-hidden="true"></i>
                                            <label>Section</label>
                                            <input type="hidden" value="1" id="section_id" name="section_id">
                                            <label class="form-control border" id="txtSection" name="txtSection"></label>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12">
                                            <i class="fa fa-tag text-info" aria-hidden="true"></i>
                                            <label>Sub section</label>
                                            <input type="hidden" value="1" id="subsection_id" name="subsection_id">
                                            <label class="form-control border" id="txtSubSection" name="txtSubSection"></label>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12">
                                            <i class="fa fa-tag text-info" aria-hidden="true"></i>
                                            <label>Company</label>
                                            <input type="hidden" value="1" id="company_id" name="company_id">
                                            <label class="form-control border" id="txtCompany" name="txtCompany"></label>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12">
                                            <label>Salary</label>
                                            <input type="text" class="form-control" id="txtBasic_salary" placeholder="0.00" name="txtBasic_salary">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="imgContainer">
                                        <img class="img img-thumbnail" src="/images/employee.jpg" id="imgEmployee" alt="image/">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>



                    <br>
                    <div class="row">
                        <div class="col-md-12 seperator">
                            <div class="card bg-primary">
                                <div class="card-header">Overtime,Loan and Others</div>
                            </div>
                        </div>
                    </div>





                    <div class="row">
                        <div class="col-md-4">
                            <div class="row cont">
                                <div class="col-md-12 content">
                                    <div class="section1">
                                        <div class="sectionHeadLine">
                                            <h5>Genaral</h5>
                                        </div>
                                        <hr>
                                        <div class="row mb-2">
                                            <div class="col-md-6">
                                                <label class="lblName">Worked Days</label>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <label style="font-size: 10;">(Cat)</label>
                                                        <input type="text" class="form-control" placeholder="0.00" id="txtCategory_Worked_days" name="txtCategory_Worked_days" readonly>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label style="font-size: 10;">(Real)</label>
                                                        <input type="text" class="form-control" placeholder="0.00" id="txtRealWorked_days" name="txtRealWorked_days">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <br>
                                                <label class="lblName">Basic Salary</label>
                                                <input type="hidden" id="genaral_BasicSalary" name="genaral_BasicSalary">
                                                <label class="form-control border amount" id="lblGenaral_BasicSalary" name="lblGenaral_BasicSalary">0.00</label>
                                            </div>
                                        </div>

                                        <div class="row mb-2">
                                            <div class="col-md-6">
                                                <label class="lblName">Nopay Days</label>
                                                <input type="text" class="form-control" placeholder="00" id="txtNopay_days" name="txtNopay_days" readonly>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="lblName">Nopay Amount</label>
                                                <input type="text" class="form-control amount" placeholder="0.00" id="txtNopay_amount" name="txtNopay_amount">
                                            </div>
                                        </div>

                                        <div class="row mb-2">
                                            <div class="col-md-6">
                                                <label class="lblName">Budget-1</label>
                                                <input type="text" class="form-control amount" placeholder="0.00" id="txtBudget1" name="txtBudget1">
                                            </div>
                                            <div class="col-md-6">
                                                <label class="lblName">Budget-2</label>
                                                <input type="text" class="form-control amount" placeholder="0.00" id="txtBudget2" name="txtBudget2">
                                            </div>
                                        </div>

                                        <div class="row mb-2">
                                            <div class="col-md-12">
                                                <label class="lblName" id="lblEmployer_epf">Employer epf(12%)</label>
                                                <input type="text" class="form-control amount" placeholder="0.00" id="txtEmployer_epf" name="txtEmployer_epf">
                                            </div>
                                        </div>

                                        <div class="row mb-2">
                                            <div class="col-md-6">
                                                <label class="lblName" id="lblEmployee_epf">Employee epf(8%)</label>
                                                <input type="text" class="form-control amount" placeholder="0.00" id="txtEmployee_epf" name="txtEmployee_epf">
                                            </div>
                                            <div class="col-md-6">
                                                <label class="lblName" id="lblEmployee_etf">Employee etf</label>
                                                <input type="text" class="form-control amount" placeholder="0.00" id="txtEmployee_etf" name="txtEmployee_etf">
                                            </div>
                                        </div>


                                        <div class="row mb-2">
                                            <div class="col-md-6">
                                                <label class="lblName">Tax1</label>
                                                <input type="text" class="form-control amount" placeholder="0.00" id="txtTax1" name="txtTax1">
                                            </div>
                                            <div class="col-md-6">
                                                <label class="lblName">Tax2</label>
                                                <input type="text" class="form-control amount" placeholder="0.00" id="txtTax2" name="txtTax2">
                                            </div>
                                        </div>


                                        <div class="row mb-2">
                                            <div class="col-md-12">
                                                <label class="lblName">Fine Hours</label>
                                                <input type="text" class="form-control amount" placeholder="0.00" id="txtFine_hours" name="txtFine_hours">
                                            </div>
                                        </div>

                                        <div class="row mb-2">
                                            <div class="col-md-12">
                                                <label class="lblName">Fine Amount</label>
                                                <input type="text" class="form-control amount" placeholder="0.00" id="txtFine_amount" name="txtFine_amount">
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="row cont">
                                <div class="col-md-12 content">
                                    <div class="section2">
                                        <div class="sectionHeadLine">
                                            <h5>Overtime</h5>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <label class="lblName">Hours-1</label>
                                                <input type="text" class="form-control" placeholder="00" id="txtOt_hours1" name="txtOt_hours1">
                                            </div>

                                            <div class="col-md-8">
                                                <label class="lblName">Amount</label>
                                                <input type="hidden" id="hid_ot_rate1_amount">
                                                <label class="form-control border amount" id="lblOt_amount1" name="lblOt_amount1">0.00</label>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-4">
                                                <label class="lblName">Hours-2</label>
                                                <input type="text" class="form-control" placeholder="00" id="txtOt_hours2" name="txtOt_hours2">
                                            </div>

                                            <div class="col-md-8">
                                                <label class="lblName">Amount</label>
                                                <input type="hidden" id="hid_ot_rate2_amount">
                                                <label class="form-control border amount" id="lblOt_amount2" name="lblOt_amount2">0.00</label>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-4">
                                                <label class="lblName">Hours-3</label>
                                                <input type="text" class="form-control" placeholder="00" id="txtOt_hours3" name="txtOt_hours3">
                                            </div>

                                            <div class="col-md-8">
                                                <label class="lblName">Amount</label>
                                                <input type="hidden" id="hid_ot_rate3_amount">
                                                <label class="form-control border amount" id="lblOt_amount3" name="lblOt_amount3">0.00</label>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="col-md-4">
                            <div class="row cont">
                                <div class="col-md-12 content">
                                    <div class="section3">
                                        <div class="sectionHeadLine">
                                            <h5>Loan & Advance</h5>
                                        </div>
                                        <hr>
                                        <div class="row mb-2">
                                            <div class="col-md-12">
                                                <label class="lblName">Advance</label>
                                                <input type="text" class="form-control amount" placeholder="0.00" id="txtAdvance" name="txtAdvance">
                                            </div>
                                        </div>

                                        <div class="row mb-2">
                                            <div class="col-md-12">
                                                <label class="lblName">Loan</label>
                                                <input type="text" class="form-control amount" placeholder="0.00" id="txtLoan" name="txtLoan">
                                            </div>
                                        </div>

                                        <div class="row mb-2">
                                            <div class="col-md-12">
                                                <label class="lblName">Interest</label>
                                                <input type="text" class="form-control amount" placeholder="0.00" id="txtLoan_interest" name="txtLoan_interest">
                                            </div>
                                        </div>

                                        <div class="row mb-2">
                                            <div class="col-md-12">
                                                <label class="lblName">Debtor Loan</label>
                                                <input type="text" class="form-control amount" placeholder="0.00" id="txtDebtor_loan" name="txtDebtor_loan">
                                            </div>
                                        </div>


                                        <div class="row mb-2">
                                            <div class="col-md-12">
                                                <label class="lblName">Debtor Loan Interest</label>
                                                <input type="text" class="form-control amount" placeholder="0.00" id="txtDebtor_loan_interest" name="txtDebtor_loan_interest">
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>





                    <br>
                    <div class="row">
                        <div class="col-md-12 seperator">
                            <div class="card bg-primary">
                                <div class="card-header">Earning and Deduction</div>
                            </div>
                        </div>
                    </div>





                    <!--<div class="row">
                        <div class="col-md-12 transactionHeadLine">
                            <h4>Transaction Setup</h4>
                        </div>
                    </div>!-->
                    <div class="row">
                        <div class="col-md-6 content">
                            <div class="transactionSection">
                                <div class="sectionHeadLine">
                                    <h5>Earning</h5>
                                </div>
                                <hr>
                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="earn_trans_id_01" name="earn_trans_id_01">
                                        <label class="form-control border" id="lbl_earn_trans_id_01"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_earn_01" name="earn_01">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="earn_trans_id_02" name="earn_trans_id_02">
                                        <label class="form-control border" id="lbl_earn_trans_id_02"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_earn_02" name="earn_02">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="earn_trans_id_03" name="earn_trans_id_03">
                                        <label class="form-control border" id="lbl_earn_trans_id_03"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_earn_03" name="earn_03">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="earn_trans_id_04" name="earn_trans_id_04">
                                        <label class="form-control border" id="lbl_earn_trans_id_04"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_earn_04" name="earn_04">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="earn_trans_id_05" name="earn_trans_id_05">
                                        <label class="form-control border" id="lbl_earn_trans_id_05"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_earn_05" name="earn_05">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="earn_trans_id_06" name="earn_trans_id_06">
                                        <label class="form-control border" id="lbl_earn_trans_id_06"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_earn_06" name="earn_06">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="earn_trans_id_07" name="earn_trans_id_07">
                                        <label class="form-control border" id="lbl_earn_trans_id_07"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_earn_07" name="earn_07">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="earn_trans_id_08" name="earn_trans_id_08">
                                        <label class="form-control border" id="lbl_earn_trans_id_08"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_earn_08" name="earn_08">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="earn_trans_id_09" name="earn_trans_id_09">
                                        <label class="form-control border" id="lbl_earn_trans_id_09"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_earn_09" name="earn_09">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="earn_trans_id_10" name="earn_trans_id_10">
                                        <label class="form-control border" id="lbl_earn_trans_id_10"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_earn_10" name="earn_10">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 content">
                            <div class="transactionSection">
                                <div class="sectionHeadLine">
                                    <h5>Deductions</h5>
                                </div>
                                <hr>
                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="deduct_trans_id_01" name="deduct_trans_id_01">
                                        <label class="form-control border" id="lbl_deduct_trans_id_01"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_deduct_01" name="deduct_01">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="deduct_trans_id_02" name="deduct_trans_id_02">
                                        <label class="form-control border" id="lbl_deduct_trans_id_02"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_deduct_02" name="deduct_02">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="deduct_trans_id_03" name="deduct_trans_id_03">
                                        <label class="form-control border" id="lbl_deduct_trans_id_03"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_deduct_03" name="deduct_03">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="deduct_trans_id_04" name="deduct_trans_id_04">
                                        <label class="form-control border" id="lbl_deduct_trans_id_04"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_deduct_04" name="deduct_04">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="deduct_trans_id_05" name="deduct_trans_id_05">
                                        <label class="form-control border" id="lbl_deduct_trans_id_05"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_deduct_05" name="deduct_05">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="deduct_trans_id_06" name="deduct_trans_id_06">
                                        <label class="form-control border" id="lbl_deduct_trans_id_06"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_deduct_06" name="deduct_06">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="deduct_trans_id_07" name="deduct_trans_id_07">
                                        <label class="form-control border" id="lbl_deduct_trans_id_07"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_deduct_07" name="deduct_07">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="deduct_trans_id_08" name="deduct_trans_id_08">
                                        <label class="form-control border" id="lbl_deduct_trans_id_08"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_deduct_08" name="deduct_08">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="deduct_trans_id_09" name="deduct_trans_id_09">
                                        <label class="form-control border" id="lbl_deduct_trans_id_09"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_deduct_09" name="deduct_09">
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-9">
                                        <input type="hidden" value="0" id="deduct_trans_id_10" name="deduct_trans_id_10">
                                        <label class="form-control border" id="lbl_deduct_trans_id_10"></label>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control amount" id="txt_deduct_10" name="deduct_10">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>




                    <br>
                    <div class="row">
                        <div class="col-md-12 seperator">
                            <div class="card bg-primary">
                                <div class="card-header">Net Salary</div>
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6">
                            <i class="fa fa-tag text-info" aria-hidden="true"></i>
                            <label>Gross Salary</label>
                            <input type="hidden" value="0" id="gross_salary" name="gross_salary">
                            <label class="form-control border" id="lblGross_salary" name="lblGross_salary"></label>
                        </div>
                        <div class="col-md-6">
                            <i class="fa fa-tag text-info" aria-hidden="true"></i>
                            <label>Total Deducation</label>
                            <input type="hidden" value="0" id="total_deduction" name="total_deduction">
                            <label class="form-control border" id="lblTotal_deduction" name="lblTotal_deduction"></label>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6">
                            <i class="fa fa-tag text-info" aria-hidden="true"></i>
                            <label>Last Adjustment</label>
                            <input type="hidden" value="0" id="last_adjustment" name="last_adjustment">
                            <label class="form-control border" id="lblLast_adjustment" name="lblLast_adjustment"></label>
                        </div>
                        <div class="col-md-6">
                            <i class="fa fa-tag text-info" aria-hidden="true"></i>
                            <label>This Adjustment</label>
                            <input type="hidden" value="0" id="this_adjustment" name="this_adjustment">
                            <label class="form-control border" id="lblThis_adjustment" name="lblThis_adjustment"></label>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6">
                            <i class="fa fa-tag text-info" aria-hidden="true"></i>
                            <label>Net Salary</label>
                            <input type="hidden" value="0" id="net_salary" name="net_salary">
                            <label class="form-control border" id="lblNet_salary" name="lblNet_salary"></label>
                            <input type="hidden" value="1" id="salary_month" name="salary_month">
                            <input type="hidden" value="1" id="salary_year" name="salary_year">
                        </div>
                        <!--<div class="col-md-6">
                        <label>Salary Month</label>
                        <label class="form-control border"></label>
                    </div>!-->
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-5"></div>
                                <div class="col-md-7">
                                    <br>
                                    <table>
                                        <tr>
                                            <td style="padding-right: 20px;">
                                                @if(Auth::user()->can('employee_salary_sheet_delete'))
                                                <button type="button" class="btn btn-danger" id="btnDelete" onclick="_delete()"><i class="fa fa-trash" aria-hidden="true"></i></button>
                                                @endif
                                            </td>
                                            <td style="min-width: 100px;">
                                                <button type="button" class="btn btn-warning" id="btnReset">Reset</button>
                                            </td>
                                            <td style="min-width: 100px;">
                                                <button type="button" class="btn btn-primary" id="btnPrintAction" onclick="print()">Print</button>
                                            </td>
                                            <td style="min-width: 100px;">
                                                @if(Auth::user()->can('employee_salary_sheet_create'))
                                                <button type="button" class="btn btn-primary" id="btnAction">Save</button>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                    <div class="row">
                                        <div class="col-md-5">
                                        </div>
                                        <div class="col-md-5">
                                        </div>
                                        <div class="col-md-2">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>

                <!--<div class="row">
                    <div class="col-md-6">
                        <label>Salary Year</label>
                        <label class="form-control border"></label>
                    </div>
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-md-9"></div>
                            <div class="col-md-3">
                                <br>
                                <button type="button" class="btn btn-primary" id="btnAction">Save</button>
                            </div>
                        </div>
                    </div>
                </div>!-->
            </div>
        </div>
    </div>
</div>



@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')

<!-- AutoComplete -->
<script src="{{ Module::asset('hr:js/autocomplete2/js/autocomplete.min.js') }}"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.70/vfs_fonts.js" integrity="sha512-vv3EN6dNaQeEWDcxrKPFYSFba/kgm//IUnvLPMPadaUf5+ylZyx4cKxuc4HdBf0PPAlM7560DV63ZcolRJFPqA==" crossorigin="anonymous"></script>
<script type="application/octet-stream" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.70/fonts/Roboto/Roboto-Medium.ttf"></script>
<script src="{{ Module::asset('hr:js/pdf/Page.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/pdf/PDFViewer.js') }}?random=<?php echo uniqid(); ?>"></script>

<script src="{{ Module::asset('hr:js/salarySheet.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/salary/createSalary.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/salary/monthBasis.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/salary/dayBasis.js') }}?random=<?php echo uniqid(); ?>"></script>



<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection