@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/clockpicker/bootstrap-clockpicker.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/shift.css') }}" type="text/css">

<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<script>
    var view_permission = "{{Auth::user()->can('employee_shift_view')}}";
    var edit_permission = "{{Auth::user()->can('employee_shift_edit')}}";
    var delete_permission = "{{Auth::user()->can('employee_shift_delete')}}";
    var disable_permission = "{{Auth::user()->can('employee_shift_enable_disable')}}";
</script>
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Employee Shift</h6>
                <div class="row">
                    <div class="col-md-12 mb-3">
                        @if(Auth::user()->can('employee_shift_create'))
                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal()">
                            <i class="fa fa-plus" aria-hidden="true"></i>
                        </button>
                        @endif
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <!-- Required for Responsive -->
                            <table id="tblShift" class="table table-striped  datatable">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Start time</th>
                                        <th>Hours</th>
                                        <th>Minutes</th>
                                        <th>Hours for breacks</th>
                                        <th>Short leave</th>
                                        <th>Half day time</th>
                                        <th>OT after (Minutes)</th>
                                        <th>Day count as</th>
                                        <th>Edit</th>
                                        <th>View</th>
                                        <th>Delete</th>
                                        <th>status</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="shiftAddModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="shiftAddModalTitle">Add New Shift</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <form action="POST" id="frmShift">
                    {{csrf_field()}}
                    <div class="modal-body" id="settingsAddModalBody">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-9 mb-3">
                                        <label>Name</label>
                                        <input type="text" id="txtShiftName" name="shiftName" class="form-control">
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label>Day count as </label>
                                        <select class="form-control" id="cmbDaysCount" name="daysCount">
                                            <option value="1">1</option>
                                            <option value="0.5">0.5</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label>Start time</label>
                                        <div class="input-group clockpicker-example">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">
                                                    <i class="fa fa-clock-o"></i>
                                                </span>
                                            </div>
                                            <input type="text" class="form-control" value="18:30" id="txtStartTime" name="startTime">
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <label>Hours</label>
                                                <input class="form-control" type="text" id="txtDurationHours" name="durationHours">
                                            </div>
                                            <div class="col-md-6">
                                                <label>Minutes</label>
                                                <input class="form-control" type="text" id="txtDurationMinutes" name="durationMinutes">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label>Hours for breacks</label>
                                        <input type="text" class="form-control" id="txtBreackHours" name="breackHours">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label>Short leave </label>
                                        <input type="text" class="form-control" id="txtShortLeaveDuration" name="shortLeaveDuration">
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label>Half day time</label>
                                        <div class="input-group clockpicker-example">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">
                                                    <i class="fa fa-clock-o"></i>
                                                </span>
                                            </div>
                                            <input type="text" class="form-control" value="18:30" id="txtHalfdayTime" name="halfdayTime">
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label>OT after (Minutes)</label>
                                        <input type="text" class="form-control" value="00" id="txtOtAfterMinutes" name="otAfterMinutes">
                                    </div>
                                </div>



                                <!--<div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label>Day count as </label>
                                        <select class="form-control" id="cmbDaysCount" name="daysCount">
                                            <option value="1">1</option>
                                            <option value="0.5">0.5</option>
                                        </select>
                                    </div>
 
                                </div>!-->

                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>
                        <button type="button" class="btn btn-primary" id="btnAction" onclick="actionBtn(event)">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('vendors/clockpicker/bootstrap-clockpicker.min.js') }}"></script>
<script src="{{ Module::asset('hr:js/shift.js') }}?random=<?php echo uniqid(); ?>"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection