@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/transaction_item.css') }}" type="text/css">

<script>
    var edit_permission = "{{Auth::user()->can('employee_naration_edit')}}";
    var delete_permission = "{{Auth::user()->can('employee_naration_delete')}}";
    var disable_permission = "{{Auth::user()->can('employee_naration_enable_disable')}}";
</script>
<style>
    /*default version*/
    @font-face {
        font-family: 'sinhalaFont';
        src: url('../fonts/FM_Abhaya.TTF');
        src: url('../fonts/FM_Abhaya.TTF') format('embedded-opentype'), url('../fonts/FM_Abhaya.TTF') format('woff'), url('../fonts/FM_Abhaya.TTF') format('truetype'), url('../fonts/FM_Abhaya.TTF') format('svg');
        font-weight: normal;
        font-style: normal;
    }
</style>
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Transaction Item</h6>
                <div class="row">
                    <div class="col-md-1">
                        @if(Auth::user()->can('employee_naration_create'))
                        <button type="button" class="btn btn-primary" onclick="showModal('save','','','',0)">
                            <i class="fa fa-plus" aria-hidden="true"></i>
                        </button>
                        @endif
                    </div>
                </div>
                <br>
                <hr>
                <table id="tblTransactionItem" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                    <thead>
                        <tr>
                            <th class="thId">ID</th>
                            <th class="thNarration">Narration</th>
                            <th class="thType">Type</th>
                            <th class="edit">Edit</th>
                            <th class="delete">Delete</th>
                            <th class="disable">Status</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>



<div class="modal fade" id="transactionItemAddModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="transactionItemAddModal-title">Add transaction item here</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body" id="transactionItemAddModal">
                <form method="POST" id="formTransactionItem" name="formTransactionItem">
                    {{ csrf_field() }}
                    <input type="hidden" id="hidItem_Id" name="hidItem_Id" value="">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-12">
                                    <label>Narration</label>
                                    <input type="text" class="form-control" id="txtNarration" name="txtNarration">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <label>Narration (Sinhala)</label>
                                    <input type="text" class="form-control" id="txtNarrationSinhala" name="txtNarrationSinhala" style="font-family: 'sinhalaFont'; font-size: 18px;">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <label>Type</label>
                                    <select class="form-control" id="selcType" name="selcType">
                                        <option value="0">Earning</option>
                                        <option value="1">Deduction</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>
                        <button type="button" class="btn btn-primary" id="btnTransactionItem-action" onclick="actionPerformed()">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @endsection

    <!-- Javascript -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @section('script')
    <!-- DataTable -->
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ url('assets/js/examples/datatable.js') }}"></script>
    <script src="{{ Module::asset('hr:js/transaction_item.js') }}?random=<?php echo uniqid(); ?>"></script>

    <!-- Prism -->
    <script src="{{ url('vendors/prism/prism.js') }}"></script>
    <script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
    @endsection