<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFinishedGoodsHeadersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pd_finished_goods_headers', function (Blueprint $table) {
            $table->id('internal_id');
            $table->string('external_id', 100);
            $table->string('ref_internal_id',100);
            $table->string('ref_external_id',100);
            $table->date('trans_date');
            $table->integer('store_id');
            $table->integer('document_no');
            $table->integer('customer_order_plan_id');
            $table->string('manufacturing_order_number',100)->nullable();
            $table->string('remarks',200)->nullable();
            $table->integer('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('finished_goods_headers');
    }
}
