<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFinishedGoodsDataTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pd_finished_goods_data', function (Blueprint $table) {
            $table->id('fg_data_id');
            $table->integer('internal_id');
            $table->string('external_id', 100);
            $table->string('product_id',100);
            $table->integer('unit_id');
            $table->double('quantity');
            $table->string('comments',200)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('finished_goods_data');
    }
}
