<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateReasonOfBreakdownsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pd_reason_of_breakdown_supervisor', function (Blueprint $table) {
            $table->id();
            $table->integer('customer_order_plan_data_id');
            $table->date('date');
            $table->integer('machinery_id');
            $table->integer('product_primary_id');
            $table->string('employee_id',45);
            $table->integer('shift_id');
            $table->dateTime('breakdown_time');
            $table->string('reason_of_breakdown',100)->nullable();
            $table->dateTime('recovered_time')->nullable();
            $table->string('recovery_details',100)->nullable();
            $table->string('technical_instruction',100)->nullable();
            $table->integer('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pd_reason_of_breakdown_supervisor');
    }
}
