<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class BreakdownReason extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'pd_breakdown_reasons';
    protected $fillable = [];

    protected static $logAttributes = [
        'id',
        'reason',
        'status',

    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_breakdown_reasons";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    

}
