<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class FinishedGoodsData extends Model
{
    use HasFactory,LogsActivity;

    protected $fillable = [];
    protected $table = 'pd_finished_goods_data';
    protected $primaryKey = 'fg_data_id';
    protected static $logAttributes = [
        'fg_data_id',
        'internal_id',
        'external_id',
        'product_id',
        'unit_id',
        'quantity',
        'comments',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_finished_goods_data";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }

}
