<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class ProductionRecordSupervisorOutside extends Model
{
    use HasFactory, LogsActivity;
    protected $fillable = [];
    protected $table = 'pd_production_record_supervisor_outsides';
    protected static $logAttributes = [
        'id',
        'customer_order_plan_data_id',
        'outside_factory_id',
        'date',
        'quantity',
        'remark',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_production_record_supervisor_outsides";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
