<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class ProductionRecordsSupervisor extends Model
{
    use HasFactory, LogsActivity;

    protected $fillable = [];
    protected $table = 'pd_production_records_supervisor';
    protected static $logAttributes = [
        'id',
        'customer_order_plan_data_id',
        'date',
        'machinery_id',
        'product_primary_id',
        'hour',
        'employee_id',
        'refno',
        'quantity',
        'remark',
        'shift_id',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_production_records_supervisor";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
