<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class ProductionStatusHistory extends Model
{
    use HasFactory;
    protected $table = 'pd_production_status_histories';
    protected $fillable = [];
    protected static $logAttributes = [
        'customer_order_plan_data_id',
        'status_id',
        'user_id',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_production_status_histories";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
