<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class ScheduleCustomerOrderPlanData extends Model
{
    use HasFactory,LogsActivity;

    protected $fillable = [];
    protected $table = 'pd_schedule_customer_order_plan_data';
    protected $primaryKey = 'schedule_customer_order_plan_data_id';
    protected static $logAttributes = [
        'schedule_customer_order_plan_data_id',
        'customer_order_plan_data_id',
        'customer_order_plan_id',
        'order_data_id',
        'manufacturing_order_no',
        'product_id',
        'product_name',
        'quantity',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_schedule_customer_order_plan_data";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }

}
