<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class ScheduleOrderResourceHr extends Model
{
    use HasFactory,LogsActivity;

    protected $fillable = [];
    protected $table = 'pd_schedule_order_resource_hrs';
    protected $primaryKey = 'schedule_order_resource_hr_id';
    protected static $logAttributes = [
        'schedule_order_resource_hr_id',
        'order_resource_hr_id',
        'customer_order_plan_data_id',
        'fg_product_id',
        'shift_id',
        'designation_id',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_schedule_order_resource_hrs";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
