<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class ScheduleOutsideFactory extends Model
{
    use HasFactory,LogsActivity;

    protected $fillable = [];
    protected $table = 'pd_schedule_outside_factories';
    protected $primaryKey = 'schedule_outside_factory_id';
    protected static $logAttributes = [
        'schedule_outside_factory_id',
        'outside_factory_id',
        'customer_order_plan_data_id',
        'starting_date',
        'expected_date',
        'quantity',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_schedule_outside_factories";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    
    protected static function newFactory()
    {
        return \Modules\Pd\Database\factories\ScheduleOutsideFactoryFactory::new();
    }
}
