<?php

namespace Modules\Pd\Http\Controllers;

use App\Http\Controllers\OrderStatusHistoryController;
use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\AttShift;
use Modules\Hr\Entities\Employee;
use Modules\Pd\Entities\DailyProduction;
use Modules\Pd\Entities\ProductionRecordsSupervisor;
use Modules\Pp\Entities\CustomerOrder;
use Modules\Pp\Entities\CustomerOrderData;
use Modules\Pp\Entities\CustomerPlan;
use Modules\Pp\Entities\CustomerPlanData;
use Modules\Pp\Entities\Machinary;
use Modules\St\Entities\Product;

class DailyProductionController extends Controller
{
    public function productionSupervisor()
    {
        try {
            $employees = Employee::all();
            $result = array();
            foreach ($employees as $emp) {
                array_push($result, [
                    "img" => "",
                    "id" => $emp->employee_id,
                    "value" => $emp->name_withinitial,
                ]);
            }
            $responseBody = $this->responseBody(true, "DailyProductionController", "productionSupervisor", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "DailyProductionController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function manufacturingOrderNumber($date)
    {
        try {
            //$result = CustomerPlan::select(['customer_order_plan_id', 'manufacturing_order_number'])->join('pp_customer_orders', 'pp_customer_orders.order_id', 'pp_customer_order_plans.order_id')->where('production_status', '=', '2')->get();

            $query = 'SELECT DISTINCT pd_schedule_customer_order_plans.customer_order_plan_id,
            pd_schedule_customer_order_plan_data.customer_order_plan_data_id,
            pd_schedule_customer_order_plans.manufacturing_order_number,
            st_products.product_name
            FROM pd_schedule_customer_order_plans
            INNER JOIN pp_customer_orders ON pd_schedule_customer_order_plans.order_id = pp_customer_orders.order_id
            INNER JOIN pd_schedule_customer_order_plan_data ON pd_schedule_customer_order_plans.customer_order_plan_id = pd_schedule_customer_order_plan_data.customer_order_plan_id
            INNER JOIN pd_schedule_machinery_plans ON pd_schedule_customer_order_plan_data.customer_order_plan_data_id = pd_schedule_machinery_plans.customer_order_plan_data_id
            INNER JOIN st_products ON pd_schedule_customer_order_plan_data.product_id = st_products.product_primary_id
            WHERE pd_schedule_machinery_plans.date = "' . $date . '"';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "DailyProductionController", "productionSupervisor", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "DailyProductionController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function product($id)
    {
        try {
            $query = 'SELECT DISTINCT st_products.product_id,st_products.product_primary_id,st_products.product_name FROM pp_machinery_plans INNER JOIN pp_customer_order_plans_data ON pp_machinery_plans.customer_order_plan_data_id = pp_customer_order_plans_data.customer_order_plan_data_id
             INNER JOIN st_products ON pp_machinery_plans.product_primary_id = st_products.product_primary_id
             WHERE pp_customer_order_plans_data.customer_order_plan_data_id = "' . $id . '"';
            $result = DB::select($query);
            $data = [];
            for ($j = 0; $j < count($result); $j++) {
                array_push($data, [
                    "img" => "",
                    "id" => $result[0]->product_primary_id,
                    "value" => $result[0]->product_name,
                ]);
            }
            $responseBody = $this->responseBody(true, "DailyProductionController", "product", $data);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "DailyProductionController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function machine($id, $date)
    {
        try {
            $query = 'SELECT DISTINCT pp_machinery.machinery_id,
            pp_machinery.machinery_no,
            pp_machinery.machinery_name 
            FROM pd_schedule_machinery_plans 
            INNER JOIN pd_schedule_customer_order_plan_data ON pd_schedule_machinery_plans.customer_order_plan_data_id = pd_schedule_customer_order_plan_data.customer_order_plan_data_id
            INNER JOIN pp_machinery ON pd_schedule_machinery_plans.machinery_id = pp_machinery.machinery_id
            WHERE pd_schedule_customer_order_plan_data.customer_order_plan_data_id = "' . $id . '" AND pd_schedule_machinery_plans.date = "' . $date . '"';

            $machines = DB::select($query);
            $responseBody = $this->responseBody(true, "DailyProductionController", "machine", $machines);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "DailyProductionController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }


    public function save(Request $request)
    {

        try {
            $productionRecordsSupervisor = new ProductionRecordsSupervisor();
            $productionRecordsSupervisor->date = $request->get('date');
            $productionRecordsSupervisor->customer_order_plan_data_id = $request->get('manufacturing_order_no');
            $productionRecordsSupervisor->employee_id = $request->get('supervisor');
            $productionRecordsSupervisor->product_primary_id = $request->get('product_id');
            $productionRecordsSupervisor->machinery_id = $request->get('machine_id');
            $productionRecordsSupervisor->refno = $request->get('refferance_no');
            $productionRecordsSupervisor->hour = $request->get('hour');
            $productionRecordsSupervisor->quantity = $request->get('quantity');
            $productionRecordsSupervisor->remark = $request->get('remark');
            $productionRecordsSupervisor->shift_id = $request->get('shift');
            if ($productionRecordsSupervisor->save()) {

                $query = 'SELECT pp_customer_orders.order_id,
                pp_customer_orders.production_status
                FROM pp_customer_orders 
                INNER JOIN pp_customer_orders_data ON pp_customer_orders.order_id = pp_customer_orders_data.order_id
                INNER JOIN pd_schedule_customer_order_plan_data ON pp_customer_orders_data.order_data_id = pd_schedule_customer_order_plan_data.order_data_id
                WHERE pd_schedule_customer_order_plan_data.customer_order_plan_data_id = "' . $productionRecordsSupervisor->customer_order_plan_data_id . '"';
                $result = DB::select($query);
                foreach ($result as $res) {
                    if ($res->production_status == 2) {
                        $order = CustomerOrder::find($res->order_id);
                        if ($order) {
                            $order->production_status = 3;
                            $order->update();
                        }

                        $customer_plan_data = CustomerPlanData::find($productionRecordsSupervisor->customer_order_plan_data_id);
                        if($customer_plan_data){
                            $customer_plan_data->production_status = 3;
                            if($customer_plan_data->update()){
                                OrderStatusHistoryController::changeProductionStatus($customer_plan_data);
                            } 
                        }

                    }
                }
            }
            $responseBody = $this->responseBody(true, "DailyProductionController", "save", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "DailyProductionController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }



    public function getDailyProduction($id)
    {
        try {
            $productionRecordsSupervisor = ProductionRecordsSupervisor::find($id);
            if ($productionRecordsSupervisor) {
                $employee = Employee::find($productionRecordsSupervisor->employee_id);
                $productionRecordsSupervisor->supervisor = $employee->name_withinitial;
                $productionRecordsSupervisor->supervisor_id = $employee->employee_id;
                $product = Product::find($productionRecordsSupervisor->product_primary_id);
                $productionRecordsSupervisor->product = $product->product_name;
            }
            $responseBody = $this->responseBody(true, "DailyProductionController", "getDailyProduction", $productionRecordsSupervisor);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "DailyProductionController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function getShift($id, $date)
    {
        try {
            $query = 'SELECT DISTINCT hr_att_shifts.shift_id,hr_att_shifts.shift_name
            FROM hr_att_shifts INNER JOIN pd_schedule_machinery_plans ON hr_att_shifts.shift_id = pd_schedule_machinery_plans.shift_id 
            WHERE pd_schedule_machinery_plans.machinery_id = "' . $id . '" AND pd_schedule_machinery_plans.date = "' . $date . '"';
            $shift = DB::select($query);
            $responseBody = $this->responseBody(true, "DailyProductionController", "getShift", $shift);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "DailyProductionController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function status_change(Request $request,$id)
    {
        try {
            $inhouse = ProductionRecordsSupervisor::find($id);
            if($inhouse){
                $inhouse->status = $request->get('status');
                $inhouse->update();
            }
            $responseBody = $this->responseBody(true, "DailyProductionController", "status_change", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "DailyProductionController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function update(Request $request, $id)
    {

        try {
            $productionRecordsSupervisor = ProductionRecordsSupervisor::find($id);
            $productionRecordsSupervisor->date = $request->get('date');
            $productionRecordsSupervisor->customer_order_plan_data_id = $request->get('manufacturing_order_no');
            $productionRecordsSupervisor->employee_id = $request->get('supervisor');
            $productionRecordsSupervisor->product_primary_id = $request->get('product_id');
            $productionRecordsSupervisor->machinery_id = $request->get('machine_id');
            $productionRecordsSupervisor->refno = $request->get('refferance_no');
            $productionRecordsSupervisor->hour = $request->get('hour');
            $productionRecordsSupervisor->quantity = $request->get('quantity');
            $productionRecordsSupervisor->remark = $request->get('remark');
            $productionRecordsSupervisor->shift_id = $request->get('shift');
            $productionRecordsSupervisor->update();
            $responseBody = $this->responseBody(true, "DailyProductionController", "update", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "DailyProductionController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
