<?php

namespace Modules\Pd\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Pd\Entities\DailyProduction;
use Modules\Pd\Entities\ProductionRecordsSupervisor;

class DailyProductionListController extends Controller
{
    public function allDailyProduction()
    {

        try {
            /*$query = 'SELECT pd_daily_productions.daily_production_id,pd_daily_productions.refferance_no,pp_customer_order_plans.manufacturing_order_number,hr_employees.name_withinitial AS supervisor FROM pd_daily_productions
            INNER JOIN pp_customer_order_plans ON pd_daily_productions.customer_order_plan_id = pp_customer_order_plans.customer_order_plan_id
            INNER JOIN hr_employees ON pd_daily_productions.supervisor_id = hr_employees.employee_id';*/
            $query = 'SELECT
            pd_production_records_supervisor.id,
            pd_production_records_supervisor.date,
            pp_customer_orders.factory_po_num AS factory_po_num,
            pp_machinery.machinery_name,
		    st_products.product_name,
            pd_production_records_supervisor.`hour`,
            pd_production_records_supervisor.quantity,
            pd_production_records_supervisor.status,
            hr_att_shifts.shift_name
            FROM pd_production_records_supervisor
            LEFT JOIN pd_schedule_customer_order_plan_data ON pd_production_records_supervisor.customer_order_plan_data_id = pd_schedule_customer_order_plan_data.customer_order_plan_data_id
            LEFT JOIN pd_schedule_customer_order_plans ON pd_schedule_customer_order_plan_data.customer_order_plan_id = pd_schedule_customer_order_plans.customer_order_plan_id
            INNER JOIN pp_customer_orders ON pd_schedule_customer_order_plans.order_id = pp_customer_orders.order_id
            LEFT JOIN pp_machinery ON pd_production_records_supervisor.machinery_id = pp_machinery.machinery_id
            LEFT JOIN pd_schedule_machinery_plans ON pd_production_records_supervisor.machinery_id = pd_schedule_machinery_plans.machinery_id
            LEFT JOIN hr_att_shifts ON pd_production_records_supervisor.shift_id =  hr_att_shifts.shift_id
			LEFT JOIN st_products ON pd_production_records_supervisor.product_primary_id = st_products.product_primary_id WHERE pd_production_records_supervisor.date BETWEEN "2023-06-01" AND CURDATE() GROUP BY pd_production_records_supervisor.id ORDER BY pd_production_records_supervisor.id DESC';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "DailyProductionListController", "allDailyProduction", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "DailyProductionListController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }


    public function delete($id)
    {
        try {
            $dailyProduction = ProductionRecordsSupervisor::find($id);
            $isDelete = false;
            if ($dailyProduction) {
                $isDelete = $dailyProduction->delete();
            }
            $responseBody = $this->responseBody(true, "DailyProductionListController", "delete", $isDelete);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "DailyProductionListController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
