<?php

namespace Modules\Pd\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Pd\Entities\FinishedGoodsData;
use Modules\Pd\Entities\FinishedGoodsHeader;
use Modules\Pp\Entities\CustomerPlan;
use Modules\Sc\Entities\DocumentNumber;
use Modules\Sc\Entities\ProductHistory;
use Modules\Sc\Entities\StoreLocation;
use Modules\Sc\Http\Controllers\ProductHistorySetOffController;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;

class FinishedGoodsController extends Controller
{
    public function allStores()
    {
        try {
            $stores =  StoreLocation::all();
            $responseBody = $this->responseBody(true, "FinishedGoodsController", "allStores", $stores);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "FinishedGoodsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function allManufacturingNumber()
    {
        try {
            $query = 'SELECT DISTINCT pp_customer_order_plans.customer_order_plan_id,
            pp_customer_order_plans.manufacturing_order_number
            FROM pp_customer_order_plans 
            INNER JOIN pp_customer_order_plans_data 
            ON pp_customer_order_plans.customer_order_plan_id = pp_customer_order_plans_data.customer_order_plan_id
            WHERE pp_customer_order_plans_data.production_status = "3"';
            $manufacturingNumbers =  DB::select($query);
            $responseBody = $this->responseBody(true, "FinishedGoodsController", "allManufacturingNumber", $manufacturingNumbers);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "FinishedGoodsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function refferanceMaxID($store_id)
    {
        try {
            $tbl = FinishedGoodsHeader::all();
            $id = 1;
            if (count($tbl) > 0) {
                $id = $tbl[count($tbl) - 1]['internal_id'] + 1;
            }
            $store = StoreLocation::find($store_id);
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
            }
            $responseBody = $this->responseBody(true, "FinishedGoodsController", "refferanceMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "FinishedGoodsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function allProduct()
    {
        try {
            $products =  Product::select('product_primary_id As id', 'product_id As value0', 'product_name As value1')->where('product_type_id', '=', '4')->get();
            return $this->responseBody(true, "FinishedGoodsController", "allProduct", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "FinishedGoodsController", "error", $exception);
        }
    }



    public function allProductFromManuFacturingOrder($id)
    {
        try {
            $query = 'SELECT st_products.* FROM st_products
            INNER JOIN pp_customer_order_plans_data ON st_products.product_primary_id = pp_customer_order_plans_data.product_id
            WHERE pp_customer_order_plans_data.customer_order_plan_id = "' . $id . '"';
            $products =  DB::select($query);
            return $this->responseBody(true, "FinishedGoodsController", "allProductFromManuFacturingOrder", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "FinishedGoodsController", "error", $exception);
        }
    }


    public function getUom($id)
    {
        try {
            $product =  Product::where('product_primary_id', '=', $id)->first();

            $data = [
                "id" => "0",
                "value" => "",
            ];
            if ($product) {
                $uom =  ProductUnit::find($product->uom_id);
                if ($uom) {
                    $data["id"] = $uom->id;
                    $data["value"] = $uom->name;
                }
            }

            $responseBody = $this->responseBody(true, "FinishedGoodsController", "getUom", $data);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "FinishedGoodsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function save(Request $request)
    {
        try {
            $prefix = $this->getPrefix('600');
            $fg = new FinishedGoodsHeader();
            $fg->external_id = $prefix . "" . $request->get('refferance_id');
            $fg->ref_external_id = $prefix . "" . $request->get('ref_external_id');
            $fg->trans_date = $request->get('trans_date');
            $fg->store_id = $request->get('store_id');
            $fg->document_no = 600;
            $fg->customer_order_plan_id = $request->get('customer_order_plan_id');
            $fg->manufacturing_order_number = $request->get('manufacturing_order_number');
            $fg->remarks = $request->get('remarks');
            $fg->Status = 0;
            if ($fg->save()) {
                $fg = FinishedGoodsHeader::find($fg->internal_id);
                $fg->ref_internal_id = $fg->internal_id;
                $fg->update();
                $fg_arr = $request->get("fg_data");
                for ($i = 0; $i < count($fg_arr); $i++) {
                    $fgData = json_decode($fg_arr[$i]);
                    $fg_data = new FinishedGoodsData();
                    $fg_data->internal_id = $fg->internal_id;
                    $fg_data->external_id = $fg->external_id;
                    $fg_data->product_id =  $fgData->product_id;
                    $fg_data->unit_id =  $fgData->unit_id;
                    $fg_data->quantity =  $fgData->qty;
                    $fg_data->comments =  $fgData->comments;
                    $fg_data->save();
                }
            }
            $responseBody = $this->responseBody(true, "FinishedGoodsController", "save", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "FinishedGoodsController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function getFinishedGoods($id)
    {
        try {
            $fg = FinishedGoodsHeader::find($id);
            if (count(array_filter(explode("-", $fg->external_id))) == 2) {
                $fg->external_id = explode("-", $fg->external_id)[1];
            }
            $fg_data = FinishedGoodsData::where('internal_id', '=', $id)->get();
            foreach ($fg_data as $data) {
                $product = Product::where('product_primary_id', '=', $data->product_id)->first();
                $data->product = $product->product_name;
                $uom = ProductUnit::find($product->uom_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
            }
            $fg->data = $fg_data;
            $responseBody = $this->responseBody(true, "FinishedGoodsListController", "getMaterialIssue", $fg);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "FinishedGoodsListController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function update(Request $request, $id)
    {

        try {
            $fg_header = FinishedGoodsHeader::find($id);
            if ($fg_header) {
                if ($this->delete($fg_header->external_id)) {
                    if ($fg_header->delete()) {
                        $bool =  $this->save($request);
                    }
                }
            }
            $responseBody = $this->responseBody(true, "FinishedGoodsListController", "update", $bool);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "FinishedGoodsListController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function delete($id)
    {
        try {
            $mi_data = FinishedGoodsData::where('external_id', '=', $id)->delete();
            $responseBody = $this->responseBody(true, "FinishedGoodsListController", "delete", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "FinishedGoodsListController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function change_status(Request $request, $id)
    {

        try {

            $finished_goods_header = FinishedGoodsHeader::find($id);
            $finished_goods_header->status = $request->get('status');
            if ($finished_goods_header->update()) {
                $this->addProductToSetoff($id);
            }

            $responseBody = $this->responseBody(true, "GrnHeaderController", "change_status", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnHeaderController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    private function addProductToSetoff($id)
    {
        $query = "SELECT pd_finished_goods_headers.document_no,pd_finished_goods_headers.store_id,pd_finished_goods_data.*FROM pd_finished_goods_data INNER JOIN pd_finished_goods_headers
        ON pd_finished_goods_data.internal_id = pd_finished_goods_headers.internal_id WHERE pd_finished_goods_data.internal_id = '" . $id . "' AND pd_finished_goods_headers.document_no = '600'";

        $result = DB::select($query);
        foreach ($result as $data) {
            $product_history = new ProductHistory();
            $product_history->internal_id = $data->internal_id;
            $product_history->external_id = $data->external_id;
            $product_history->document_no = $data->document_no;
            $product_history->description = "Finished Goods";
            $product_history->product_id = $data->product_id;
            $product_history->unit_id = $data->unit_id;
            $product_history->quantity = $data->quantity;
            $product_history->set_off = 0;
            $product_history->cost_price = 0;
            $product_history->store_id = $data->store_id;
            $product_history->user_id = Auth::user()->id;
            $product_history->save();



            $product_history_setoff = new ProductHistorySetOffController();
            $product_history_setoff->saveGoodsReceived($product_history);
        }
    }



    private function getPrefix($document_no)
    {
        $document_no = DocumentNumber::where('document_number', '=', $document_no)->first();
        $prefix = "";
        if ($document_no) {
            $prefix = $document_no->prefix;
        }

        return $prefix;
    }

    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
