<?php

namespace Modules\Pd\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Pd\Entities\PallatizingAttachment;
use Modules\Pd\Entities\PallatizingData;
use Modules\Pd\Entities\PallatizingEmployee;
use Modules\Pd\Entities\PallatizingHeader;
use Modules\Pp\Entities\CustomerOrder;
use Modules\St\Entities\Product;

class PallatizingController extends Controller
{


    public function getPalletNo()
    {
        try {
            $query = 'SELECT IFNULL(MAX(pd_pallatizing_headers.pallatizing_header_id),0) AS id FROM pd_pallatizing_headers';
            $id = DB::select($query)[0];
            return $this->responseBody(true, "PallatizingController", "getPalletNo", $id);
        } catch (Exception $exception) {
            return $this->responseBody(false, "PallatizingController", "getPalletNo", $exception);
        }
    }



    public function allEmployees()
    {
        try {
            $products =  Employee::select('employee_id As id', 'name_withinitial As value0')->get();
            return $this->responseBody(true, "PallatizingController", "allEmployees", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "PallatizingController", "allEmployees", $exception);
        }
    }


    public function allFactories()
    {
        try {
            $factories =  EmployeeSite::all();
            return $this->responseBody(true, "PallatizingController", "allFactory", $factories);
        } catch (Exception $exception) {
            return $this->responseBody(false, "PallatizingController", "allFactory", $exception);
        }
    }



    public function allOrders()
    {
        try {
            //$orders =  CustomerOrder::select('purchase_order', 'factory_po_num', 'order_id')->where('production_status', '=', '3')->get();
            $orders =  CustomerOrder::select('purchase_order', 'factory_po_num', 'order_id')->where('production_status', '>', '0')->get();

            return $this->responseBody(true, "PallatizingController", "allFactory", $orders);
        } catch (Exception $exception) {
            return $this->responseBody(false, "PallatizingController", "allFactory", $exception);
        }
    }


    public function ongoingProducts($order_id)
    {
        try {
            $query = 'SELECT st_products.product_primary_id AS value,st_products.product_name AS text
            FROM pp_customer_orders 
            INNER JOIN pp_customer_orders_data ON pp_customer_orders.order_id = pp_customer_orders_data.order_id
            INNER JOIN pp_customer_order_plans_data ON pp_customer_orders_data.order_data_id = pp_customer_order_plans_data.order_data_id
            INNER JOIN st_products ON pp_customer_order_plans_data.product_id = st_products.product_primary_id
            WHERE pp_customer_orders.order_id = "' . $order_id . '"';
            $products =  DB::select($query);
            return $this->responseBody(true, "PallatizingController", "ongoingProducts", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "PallatizingController", "ongoingProducts", $exception);
        }
    }




    public function save(Request $request)
    {
        try {
            $pallatizingHeader = new PallatizingHeader();
            $pallatizingHeader->pallet_no = $request->get('pallet_no');
            $pallatizingHeader->pallatize_date = $request->get('pallet_date');
            $pallatizingHeader->pallet_weight = $request->get('pallet_weight');
            $pallatizingHeader->pallet_length = $request->get('pallet_length');
            $pallatizingHeader->pallet_width = $request->get('pallet_width');
            $pallatizingHeader->pallet_height = $request->get('pallet_height');
            $pallatizingHeader->factory_id = $request->get('factory');
            $pallatizingHeader->order_id = $request->get('order_id');
            $pallatizingHeader->supervisor_id = $request->get('supervisor_id');
            $pallatizingHeader->user_id = Auth::user()->id;
            $pallatizingHeader->status = 0;
            if ($pallatizingHeader->save()) {

                $pallet_data_arr = $request->get("pallet_data");
                for ($i = 0; $i < count($pallet_data_arr); $i++) {
                    $palletData = json_decode($pallet_data_arr[$i]);
                    $pallatizing_data = new PallatizingData();
                    $pallatizing_data->pallatizing_header_id = $pallatizingHeader->pallatizing_header_id;
                    $pallatizing_data->layer =  $palletData->layer;
                    $pallatizing_data->total =  $palletData->total;
                    $pallatizing_data->product_primary_id =  $palletData->product;
                    $pallatizing_data->comment =  $palletData->comment;
                    $pallatizing_data->save();
                }


                $employee_data_arr = $request->get("employee_data");
                for ($i = 0; $i < count($employee_data_arr); $i++) {
                    $employeeData = json_decode($employee_data_arr[$i]);
                    $employee_data = new PallatizingEmployee();
                    $employee_data->pallatizing_header_id = $pallatizingHeader->pallatizing_header_id;
                    $employee_data->employee_id =  $employeeData->employee_id;
                    $employee_data->save();
                }


                $attachmnet_token = $request->get("attachment_token");
                $attachments = PallatizingAttachment::where('token', '=', $attachmnet_token)->get();
                foreach ($attachments as $attachmnet) {
                    if ($attachmnet) {
                        $attachmnet->pallatizing_header_id =  $pallatizingHeader->pallatizing_header_id;
                        $attachmnet->update();
                    }
                }
            }
            $responseBody = $this->responseBody(true, "PallatizingController", "save", $pallet_data_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PallatizingController", "save", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function uploadAttachment(Request $request)
    {
        $token = $request->get('attachmnet_token');
        $file = $request->file('file');
        $file_name = $file->getClientOriginalName();
        $filename = uniqid() . '_' . time() . '.' . $file_name;
        $filename = str_replace(' ', '', str_replace('\'', '', $filename));
        $file->move(public_path('pallet'), $filename);

        $pallatize_attachment = new PallatizingAttachment();
        $pallatize_attachment->pallatizing_header_id = 0;
        $pallatize_attachment->path = $filename;
        $pallatize_attachment->token = $token;
        return $pallatize_attachment->save();
    }




    public function allAttachment($id, $token)
    {
        try {

            $attachment = DB::select('SELECT *FROM pd_pallatizing_attachments WHERE  pallatizing_header_id = "' . $id . '" OR token = "' . $token . '"');
            $responseBody = $this->responseBody(true, "PallatizingController", "allAttachment", $attachment);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PallatizingController", "allAttachment", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function getPallet($id)
    {
        try {
            $pallet = PallatizingHeader::find($id);
            $pallet_data = PallatizingData::where('pallatizing_header_id', '=', $id)->get();
            $pallet_employee = PallatizingEmployee::where('pallatizing_header_id', '=', $id)->get();
            $pallet_attachment = PallatizingAttachment::where('pallatizing_header_id', '=', $id)->get();

            $supervisor = Employee::find($pallet->supervisor_id);
            if ($supervisor) {
                $pallet->supervisor = $supervisor->name_withinitial;
            }

            foreach ($pallet_employee as $employee) {
                $emp = Employee::find($employee->employee_id);
                if ($emp) {
                    $employee->name = $emp->name_withinitial;
                }
            }
            $pallet->data = $pallet_data;
            $pallet->employee = $pallet_employee;
            $pallet->attachment = $pallet_attachment;
            $responseBody = $this->responseBody(true, "PallatizingController", "getPallet", $pallet);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PallatizingController", "getPallet", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }






    public function update(Request $request, $id)
    {
        try {
            $pallatizingHeader =  PallatizingHeader::find($id);
            $pallatizingHeader->pallet_no = $request->get('pallet_no');
            $pallatizingHeader->pallatize_date = $request->get('pallet_date');
            $pallatizingHeader->pallet_weight = $request->get('pallet_weight');
            $pallatizingHeader->pallet_length = $request->get('pallet_length');
            $pallatizingHeader->pallet_width = $request->get('pallet_width');
            $pallatizingHeader->pallet_height = $request->get('pallet_height');
            $pallatizingHeader->factory_id = $request->get('factory');
            $pallatizingHeader->order_id = $request->get('order_id');
            $pallatizingHeader->supervisor_id = $request->get('supervisor_id');
            $pallatizingHeader->user_id = Auth::user()->id;
            if ($pallatizingHeader->update()) {

                /** DELETE PALLATIZING DATA FOR UPDATE */
                $pallet_data = PallatizingData::where('pallatizing_header_id', '=', $id)->get();
                foreach ($pallet_data as $data) {
                    PallatizingData::find($data->pallatizing_data_id)->delete();
                }
                /**END OF DELETE PALLATIZING DATA FOR UPDATE */


                $pallet_data_arr = $request->get("pallet_data");
                for ($i = 0; $i < count($pallet_data_arr); $i++) {
                    $palletData = json_decode($pallet_data_arr[$i]);
                    $pallatizing_data = new PallatizingData();
                    $pallatizing_data->pallatizing_header_id = $pallatizingHeader->pallatizing_header_id;
                    $pallatizing_data->layer =  $palletData->layer;
                    $pallatizing_data->total =  $palletData->total;
                    $pallatizing_data->product_primary_id =  $palletData->product;
                    $pallatizing_data->comment =  $palletData->comment;
                    $pallatizing_data->save();
                }


                /** DELETE PALLATIZING EMPLOYEE FOR UPDATE */
                $pallet_employee = PallatizingEmployee::where('pallatizing_header_id', '=', $id)->get();
                foreach ($pallet_employee as $employee) {
                    PallatizingEmployee::find($employee->pallatizing_employee_id)->delete();
                }
                /**END OF DELETE PALLATIZING EMPLOYEE FOR UPDATE */

                $employee_data_arr = $request->get("employee_data");
                for ($i = 0; $i < count($employee_data_arr); $i++) {
                    $employeeData = json_decode($employee_data_arr[$i]);
                    $employee_data = new PallatizingEmployee();
                    $employee_data->pallatizing_header_id = $pallatizingHeader->pallatizing_header_id;
                    $employee_data->employee_id =  $employeeData->employee_id;
                    $employee_data->save();
                }



                $attachmnet_token = $request->get("attachment_token");
                $attachments = PallatizingAttachment::where('token', '=', $attachmnet_token)->get();
                foreach ($attachments as $attachmnet) {
                    if ($attachmnet) {
                        $attachmnet->pallatizing_header_id =  $pallatizingHeader->pallatizing_header_id;
                        $attachmnet->update();
                    }
                }
            }
            $responseBody = $this->responseBody(true, "PallatizingController", "save", $pallet_data_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PallatizingController", "save", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function deleteAttachment($id)
    {
        try {
            $pallatizing_header_id = null;
            $attachment = PallatizingAttachment::find($id);
            $pallatizing_header_id = $attachment->pallatizing_header_id;
            $attachment->delete();
            $pallet_attachment = PallatizingAttachment::where('pallatizing_header_id', '=', $pallatizing_header_id)->get();

            $responseBody = $this->responseBody(true, "PallatizingController", "deleteAttachment", $pallet_attachment);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PallatizingController", "deleteAttachment", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function change_status(Request $request, $id)
    {
        try {
            $pallet = PallatizingHeader::find($id);
            $pallet->status = $request->get('status');
            $pallet->update();

            $responseBody = $this->responseBody(true, "PallatizingController", "change_status", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PallatizingController", "change_status", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
