<?php

namespace Modules\Pd\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Pd\Entities\PallatizingAttachment;
use Modules\Pd\Entities\PallatizingData;
use Modules\Pd\Entities\PallatizingEmployee;
use Modules\Pd\Entities\PallatizingHeader;
use Modules\Pp\Entities\CustomerOrder;
use PhpParser\Node\Stmt\Foreach_;

class PallatizingListController extends Controller
{


    public function allPallatizingData()
    {
        try {
            $query = 'SELECT pd_pallatizing_headers.*,pp_customer_orders.factory_po_num FROM pd_pallatizing_headers INNER JOIN pp_customer_orders ON pd_pallatizing_headers.order_id = pp_customer_orders.order_id ORDER BY pallatizing_header_id DESC';
            $pallets = DB::select($query);
            $responseBody = $this->responseBody(true, "PallatizingListController", "allPallatizingData", $pallets);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PallatizingListController", "allPallatizingData", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function deletePallet($id)
    {
        try {
            $pallet = PallatizingHeader::find($id);

            if ($pallet->delete()) {
                /** DELETE PALLATIZING DATA*/
                $pallet_data = PallatizingData::where('pallatizing_header_id', '=', $id)->get();
                foreach ($pallet_data as $data) {
                    PallatizingData::find($data->pallatizing_data_id)->delete();
                }
                /**END OF DELETE PALLATIZING DATA */


                /** DELETE PALLATIZING EMPLOYEE */
                $pallet_employee = PallatizingEmployee::where('pallatizing_header_id', '=', $id)->get();
                foreach ($pallet_employee as $employee) {
                    PallatizingEmployee::find($employee->pallatizing_employee_id)->delete();
                }
                /**END OF DELETE PALLATIZING EMPLOYEE */


                /** DELETE PALLATIZING ATTACHMNET */
                $pallet_attachment = PallatizingAttachment::where('pallatizing_header_id', '=', $id)->get();
                foreach ($pallet_attachment as $attachment) {
                    PallatizingAttachment::find($attachment->pallatizing_attachment_id)->delete();
                }
                /**END OF DELETE PALLATIZING ATTACHMNET */
            }

            $responseBody = $this->responseBody(true, "PallatizingListController", "deletePallet", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PallatizingListController", "deletePallet", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function pallatizingPrint($id)
    {
        try {


            $query = "SELECT hr_employee_sites.site,
            pp_customer_orders.factory_po_num,
            pp_customer_orders.customer_name,
            pd_pallatizing_headers.pallet_no,
            pd_pallatizing_headers.pallatize_date,
            pd_pallatizing_headers.pallet_height,
            pd_pallatizing_headers.pallet_length,
            pd_pallatizing_headers.pallet_weight,
            pd_pallatizing_headers.pallet_width,
            hr_employees.name_withinitial as supervisor,
            GROUP_CONCAT(CONVERT(pd_pallatizing_data.total,CHAR) ORDER BY pd_pallatizing_data.pallatizing_data_id ASC,',') as layers,
            (SELECT GROUP_CONCAT(pd_pallatizing_employees.employee_id,',') FROM pd_pallatizing_employees WHERE pd_pallatizing_employees.pallatizing_header_id = pd_pallatizing_headers.pallatizing_header_id) as employees
            FROM pd_pallatizing_data
            INNER JOIN pd_pallatizing_headers 
            ON pd_pallatizing_data.pallatizing_header_id = pd_pallatizing_headers.pallatizing_header_id 
            INNER JOIN pp_customer_orders ON pd_pallatizing_headers.order_id = pp_customer_orders.order_id
            INNER JOIN hr_employee_sites ON pd_pallatizing_headers.factory_id = hr_employee_sites.site_id
            INNER JOIN hr_employees ON pd_pallatizing_headers.supervisor_id = hr_employees.employee_id
            WHERE pd_pallatizing_headers.order_id = '".$id."' GROUP BY pd_pallatizing_data.pallatizing_header_id";
            $data_result = DB::select($query);
            foreach ($data_result as $data) {
                $data->layers .= ',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0';
            }
            //$pallatizing_header->data = $data_result;

            $responseBody = $this->responseBody(true, "PallatizingListController", "pallatizingPrint", $data_result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PallatizingListController", "pallatizingPrint", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
