<?php

namespace Modules\Pd\Http\Controllers;

use App\Http\Controllers\OrderStatusHistoryController;
use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\AttShift;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Pd\Entities\ProductionRecordsSupervisor;
use Modules\Pd\Entities\ScheduleCustomerOrderPlan;
use Modules\Pd\Entities\ScheduleCustomerOrderPlanData;
use Modules\Pd\Entities\ScheduleMachineryPlan;
use Modules\Pd\Entities\ScheduleOrderResourceBom;
use Modules\Pd\Entities\ScheduleOrderResourceHr;
use Modules\Pd\Entities\ScheduleOutsideFactory;
use Modules\Pp\Entities\CustomerOrder;
use Modules\Pp\Entities\CustomerOrderData;
use Modules\Pp\Entities\CustomerPlan;
use Modules\Pp\Entities\CustomerPlanData;
use Modules\Pp\Entities\Machinary;
use Modules\Pp\Entities\MachinaryProduct;
use Modules\Pp\Entities\MachineryPlan;
use Modules\Pp\Entities\OrderResourceBom;
use Modules\Pp\Entities\OrderResourceHr;
use Modules\St\Entities\Factory;
use Modules\St\Entities\OutsideFactory;
use Modules\St\Entities\Product;
use PhpParser\Node\Stmt\Foreach_;

class ProductionScheduleCreateController extends Controller
{
    public function productionPlan()
    {
        try {
            /*$query = 'SELECT pp_customer_order_plans.customer_order_plan_id,
            pp_customer_order_plans.trans_date,
            pp_customer_orders.purchase_order,
            pp_customer_orders.factory_po_num,
            pp_customer_orders.order_id,
            pp_customer_order_plans_data.customer_order_plan_data_id,
            st_products.product_id,
            st_products.product_primary_id,
            st_products.product_name,
            MIN(pp_machinery_plans.date) AS from_date,
            MAX(pp_machinery_plans.date) AS to_date,
            hr_employee_sites.site AS factory,
            pp_machinery_plans.machinery_id,
            pp_machinery_plans.customer_order_plan_data_id
            FROM pp_customer_order_plans
            INNER JOIN pp_customer_orders ON pp_customer_order_plans.order_id = pp_customer_orders.order_id
            INNER JOIN pp_customer_order_plans_data ON pp_customer_order_plans.customer_order_plan_id = pp_customer_order_plans_data.customer_order_plan_id
            INNER JOIN st_products ON pp_customer_order_plans_data.product_id = st_products.product_primary_id
            INNER JOIN pp_machinery_plans ON pp_customer_order_plans_data.customer_order_plan_data_id = pp_machinery_plans.customer_order_plan_data_id
            INNER JOIN pp_machinery ON pp_machinery_plans.machinery_id = pp_machinery.machinery_id
            INNER JOIN hr_employee_sites ON pp_machinery.site_id = hr_employee_sites.site_id WHERE pp_customer_orders.production_status = "1" AND pp_customer_order_plans_data.production_schedule = "0" GROUP BY pp_machinery_plans.customer_order_plan_data_id ORDER BY pp_customer_order_plans.customer_order_plan_id DESC';*/

            $query = 'SELECT pp_customer_order_plans_data.customer_order_plan_data_id,
            pp_customer_order_plans.trans_date,
            pp_customer_order_plans.customer_order_plan_id,
            pp_customer_orders.purchase_order,
            pp_customer_orders.factory_po_num,
            pp_customer_orders.order_id,
            st_products.product_primary_id,
            st_products.product_id,
            st_products.product_name ,
            ( SELECT   MIN(date)   
               FROM pd_schedule_machinery_plans  
              WHERE  customer_order_plan_data_id = pp_customer_order_plans_data.customer_order_plan_id  ) As from_date ,
            ( SELECT  MAX(date) 
               FROM pd_schedule_machinery_plans  
              WHERE  customer_order_plan_data_id = pp_customer_order_plans_data.customer_order_plan_id  )  As to_date  
            FROM pp_customer_order_plans
            LEFT JOIN pp_customer_order_plans_data ON pp_customer_order_plans.customer_order_plan_id = pp_customer_order_plans_data.customer_order_plan_id
            LEFT JOIN pp_customer_orders ON pp_customer_order_plans.order_id = pp_customer_orders.order_id
            LEFT JOIN st_products ON pp_customer_order_plans_data.product_id = st_products.product_primary_id
            WHERE pp_customer_orders.production_status = "1" AND pp_customer_order_plans_data.production_schedule = "0" 
            ORDER BY pp_customer_order_plans_data.customer_order_plan_data_id DESC';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "ProductionScheduleCreateController", "productionPlan", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionScheduleCreateController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }



    public function getSelectedProductData($customer_order_plan_data_id, $product_primary_id)
    {
        try {

            $allocated_qty = $this->getAllocatedQuantity($customer_order_plan_data_id, $product_primary_id);
            $bom_header_qty = $this->getBomHeaderQuantityProduct($product_primary_id);
            $customerPlanData =  CustomerPlanData::find($customer_order_plan_data_id);

            if ($customerPlanData) {
                $customerPlanData->ordered_machine = $this->getMachineryPlan($customer_order_plan_data_id, $product_primary_id);
                $customerPlanData->machine =  Machinary::all();
                $customerPlanData->factory_po = "";
                $customerPlanData->customer_po = "";
                $customerPlanData->product_code = "";
                $customerPlanData->ordered_factory =  $this->getSite($customer_order_plan_data_id, $product_primary_id);
                $customerPlanData->factory =  Factory::all();
                $customerPlanData->factory_count = 4;
                $customerPlanData->allocated_quantity = $allocated_qty;
                $customerPlanData->bom_header_quantity = $bom_header_qty;
                $orderData = CustomerOrderData::find($customerPlanData->order_data_id);
                if ($orderData) {
                    $customerOrder = CustomerOrder::find($orderData->order_id);
                    if ($customerOrder) {
                        $customerPlanData->factory_po = $customerOrder->factory_po_num;
                        $customerPlanData->customer_po = $customerOrder->purchase_order;
                    }
                }
                $product = Product::find($customerPlanData->product_id);
                if ($product) {
                    $customerPlanData->product_code = $product->product_id;
                }

                /* $machine = Machinary::find($machine_id);
                if ($machine) {
                    $customerPlanData->machine = $machine->machinery_no . "-" . $machine->machinery_name;
                    $site = EmployeeSite::find($machine->site_id);
                    if ($site) {
                        $customerPlanData->factory = $site->site;
                    }
                }*/
            }
            $responseBody = $this->responseBody(true, "ProductionScheduleCreateController", "getSelectedProductData", $customerPlanData);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionScheduleCreateController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    function getMachineryPlan($customer_order_plan_data_id, $product_primary_id)
    {

        $query = "SELECT DISTINCT pp_machinery.* FROM pp_machinery_plans 
                  INNER JOIN pp_machinery ON pp_machinery_plans.machinery_id = pp_machinery.machinery_id
                  WHERE pp_machinery_plans.customer_order_plan_data_id = {$customer_order_plan_data_id} 
                  AND pp_machinery_plans.product_primary_id = {$product_primary_id}";

        $result =  DB::select($query);
        return $result;
    }



    function getMachinerySites($customer_order_plan_data_id, $product_primary_id)
    {

        $query = "SELECT DISTINCT hr_employee_sites.* FROM pp_machinery_plans 
                  INNER JOIN pp_machinery ON pp_machinery_plans.machinery_id = pp_machinery.machinery_id
                  INNER JOIN hr_employee_sites ON pp_machinery.site_id = hr_employee_sites.site_id
                  WHERE pp_machinery_plans.customer_order_plan_data_id = {$customer_order_plan_data_id} 
                  AND pp_machinery_plans.product_primary_id = {$product_primary_id}";

        $result =  DB::select($query);
        return $result;
    }



    function getSite($customer_order_plan_data_id, $product_primary_id)
    {

        $query = "SELECT DISTINCT st_factories.* FROM pp_machinery_plans 
        INNER JOIN pp_machinery ON pp_machinery_plans.machinery_id = pp_machinery.machinery_id
        INNER JOIN st_factories ON pp_machinery.factory_id = st_factories.factory_id
        WHERE pp_machinery_plans.customer_order_plan_data_id = {$customer_order_plan_data_id} 
        AND pp_machinery_plans.product_primary_id = {$product_primary_id}";
        $result =  DB::select($query);
        if (count($result) > 0) {
            return $result;
        }
        return [];
    }


    function getAllocatedQuantity($order_id, $product_id)
    {

        $quantity = 0;
        $query = 'SELECT SUM(pp_machinery_plans.quantity) AS quantity FROM pp_machinery_plans 
            WHERE pp_machinery_plans.customer_order_plan_data_id = "' . $order_id . '" AND pp_machinery_plans.product_primary_id = "' . $product_id . '"';
        $result = DB::select($query);
        foreach ($result as $res) {
            $quantity = $res->quantity;
        }
        if (!$quantity) {
            $quantity = 0;
        }
        return $quantity;
    }



    function getBomHeaderQuantityProduct($product_id)
    {

        $quantity = 0;
        $query = 'SELECT pp_bom_header.quantity FROM pp_bom_header WHERE pp_bom_header.product_id = "' . $product_id . '"';
        $result = DB::select($query);
        foreach ($result as $res) {
            $quantity = $res->quantity;
        }
        if (!$quantity) {
            $quantity = 0;
        }
        return $quantity;
    }



    function getAllocatedQuantityFromDate($order_id, $product_id, $machine_id, $date, $from, $to)
    {
        try {
            $quantity = 0;
            //$machineProduct =  MachineryPlan::where([['customer_order_plan_data_id', '=', $order_id], ['product_primary_id', '=', $product_id], ['machinery_id', '!=', $machine_id], ['date', '=', $date], ['from', '=', $from]])->first();
            $query = 'SELECT SUM(pp_machinery_plans.quantity) AS quantity FROM pp_machinery_plans 
            WHERE pp_machinery_plans.customer_order_plan_data_id = "' . $order_id . '" AND pp_machinery_plans.product_primary_id = "' . $product_id . '"
            AND pp_machinery_plans.machinery_id != "' . $machine_id . '" AND pp_machinery_plans.date = "' . $date . '" AND (pp_machinery_plans.`from` >= "' . $from . '" AND pp_machinery_plans.`to` <= "' . $to . '")';
            $result = DB::select($query);
            foreach ($result as $res) {
                $quantity = $res->quantity;
            }
            $responseBody = $this->responseBody(true, "getAllocatedQuantityFromDate", "Found", $quantity);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getAllocatedQuantityFromDate", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    function getAllocatedData($order_id, $product_id, $machinery_id)
    {
        try {
            $machineProducts =  MachineryPlan::where([['customer_order_plan_data_id', '=', $order_id], ['product_primary_id', '=', $product_id], ['machinery_id', '=', $machinery_id]])->get();
            foreach ($machineProducts as $mp) {
                $mp->shift_name = "";
                $shift = AttShift::find($mp->shift_id);
                if ($shift) {
                    $mp->shift_name = $shift->shift_name;
                }
            }
            $responseBody = $this->responseBody(true, "getAllocatedData", "Found", $machineProducts);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getAllocatedData", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    function getAllocatedMachineData($order_id, $product_id, $machinery_id, $site_id)
    {
        try {
            /*$machineProducts =  MachineryPlan::where([['customer_order_plan_data_id', '=', $order_id], ['product_primary_id', '=', $product_id], ['machinery_id', '=', $machinery_id], ['site_id', '=', $site_id]])->get();
            foreach ($machineProducts as $mp) {
                $mp->shift_name = "";
                $shift = AttShift::find($mp->shift_id);
                if ($shift) {
                    $mp->shift_name = $shift->shift_name;
                }
            }*/
            $query = "SELECT pp_machinery_plans.*,hr_att_shifts.* FROM pp_machinery_plans 
            INNER JOIN pp_machinery ON pp_machinery_plans.machinery_id = pp_machinery.machinery_id
            INNER JOIN hr_employee_sites ON pp_machinery.site_id = hr_employee_sites.site_id
            INNER JOIN hr_att_shifts ON pp_machinery_plans.shift_id = hr_att_shifts.shift_id
            WHERE pp_machinery_plans.customer_order_plan_data_id = {$order_id} AND pp_machinery_plans.product_primary_id = {$product_id}
            AND pp_machinery_plans.machinery_id = {$machinery_id} AND pp_machinery.site_id = {$site_id}";

            $machineProducts = DB::select($query);
            $responseBody = $this->responseBody(true, "getAllocatedData", "Found", $machineProducts);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getAllocatedData", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }


    function quantityPerHour($id)
    {
        try {
            $quantity = 0;
            $machineProduct =  MachinaryProduct::where('machinery_id', '=', $id)->first();
            if ($machineProduct) {
                $quantity = $machineProduct->quantity;
            }
            $responseBody = $this->responseBody(true, "quantityPerHour", "Found", $quantity);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "quantityPerHour", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    function getSavedAllocatedBOMData($customer_order_plan_data_id, $fg_product_id)
    {
        try {
            $query = 'SELECT st_product_units.name AS uom_name,
            st_products.product_primary_id,
            st_products.product_id,
            st_products.product_name,
            SUM(sc_product_histories.quantity) AS stock_in_h,
            pp_order_resource_boms.* 
            FROM pp_order_resource_boms
            INNER JOIN st_products ON pp_order_resource_boms.rm_product_id = st_products.product_primary_id
            INNER JOIN st_product_units ON pp_order_resource_boms.uom = st_product_units.id
            LEFT JOIN sc_product_histories ON pp_order_resource_boms.rm_product_id = sc_product_histories.product_id
            WHERE  pp_order_resource_boms.customer_order_plan_data_id = "' . $customer_order_plan_data_id . '" 
            AND pp_order_resource_boms.fg_product_id = "' . $fg_product_id . '" 
            GROUP BY pp_order_resource_boms.order_resource_bom_id';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "getSavedAllocatedBOMData", "Found", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getSavedAllocatedBOMData", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    function getSaveProductionTeam($customer_order_plan_data_id, $fg_product_id)
    {
        try {
            $query = 'SELECT hr_employee_designations.designation_id,hr_employee_designations.designation,SUM(pp_order_resource_hrs.no_of_heads)AS count FROM hr_employee_designations INNER JOIN pp_production_teams ON hr_employee_designations.designation_id = pp_production_teams.designation_id
            INNER JOIN pp_order_resource_hrs ON pp_production_teams.designation_id = pp_order_resource_hrs.designation_id WHERE pp_order_resource_hrs.customer_order_plan_data_id = "' . $customer_order_plan_data_id . '" AND pp_order_resource_hrs.fg_product_id = "' . $fg_product_id . '" GROUP BY pp_order_resource_hrs.designation_id';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "getSavedProductionTeam", "Found", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getSavedProductionTeam", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }


    function getMachineryShifts($id)
    {
        try {
            /*$query = 'SELECT DISTINCT hr_att_shifts.shift_id,hr_att_shifts.shift_name FROM hr_att_shifts 
            INNER JOIN pp_machinery_plans ON hr_att_shifts.shift_id = pp_machinery_plans.shift_id
            WHERE pp_machinery_plans.customer_order_plan_data_id = "' . $id . '"';
            $result = DB::select($query);*/
            $responseBody = $this->responseBody(true, "getMachineryShifts", "Found", AttShift::all());
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getMachineryShifts", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    function getSavedAllocatedDataToDetailsHR($customer_order_plan_data_id, $fg_product_id, $shift_id)
    {
        try {
            $query = 'SELECT hr_employee_designations.designation_id,hr_employee_designations.designation,pp_order_resource_hrs.no_of_heads AS count FROM hr_employee_designations INNER JOIN pp_production_teams ON hr_employee_designations.designation_id = pp_production_teams.designation_id
            INNER JOIN pp_order_resource_hrs ON pp_production_teams.designation_id = pp_order_resource_hrs.designation_id WHERE pp_order_resource_hrs.customer_order_plan_data_id = "' . $customer_order_plan_data_id . '" AND pp_order_resource_hrs.fg_product_id = "' . $fg_product_id . '" AND pp_order_resource_hrs.shift_id = "' . $shift_id . '"';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "getSavedAllocatedDataToDetailsHR", "Found", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getSavedAllocatedDataToDetailsHR", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    function add(Request $request)
    {
        try {
            $order_id = $request->get('order_id');
            $product_primary_id = $request->get('product_primary_id');

            $customer_order_plan_id = $request->get('customer_order_plan_id');
            $customer_order_plan_data_id = $request->get('customer_order_plan_data_id');
            $factory_type = $request->get('factory_type');
            $status1 = $this->saveScheduleCustomerOrderPlan($customer_order_plan_id, $customer_order_plan_data_id, $factory_type);

            $responseBody = $this->responseBody(true, "add", "save", $status1);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "add", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    function addOutsideFactory(Request $request)
    {
        try {
            $order_id = $request->get('order_id');
            $customer_order_plan_data_id = $request->get('customer_order_plan_data_id');
            $outside_factories = $request->get('outside_factories');

            $customer_order_plan_id = $request->get('customer_order_plan_id');
            $customer_order_plan_data_id = $request->get('customer_order_plan_data_id');
            $factory_type = $request->get('factory_type');
            $status1 = $this->saveScheduleCustomerOrderPlan($customer_order_plan_id, $customer_order_plan_data_id, $factory_type);
            for ($i = 0; $i < count($outside_factories); $i++) {
                $data = json_decode($outside_factories[$i]);
                $scheduleOutsideFactory = new ScheduleOutsideFactory();
                $scheduleOutsideFactory->outside_factory_id = $data->factory;
                $scheduleOutsideFactory->customer_order_plan_data_id =  $customer_order_plan_data_id;
                $scheduleOutsideFactory->starting_date = $data->start;
                $scheduleOutsideFactory->expected_date = $data->expected;
                $scheduleOutsideFactory->quantity =  $data->quantity;
                $scheduleOutsideFactory->save();
            }

            $responseBody = $this->responseBody(true, "add", "addOutsideFactory", $status1);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "add", "addOutsideFactory", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }




    private function saveScheduleCustomerOrderPlan($order_id, $order_plan_data_id, $factory_type)
    {
        try {
            $customerPlan = CustomerPlan::find($order_id);
            if ($customerPlan) {
                ScheduleCustomerOrderPlan::where('customer_order_plan_id', '=', $order_id)->delete();
                $schedulePlan = new ScheduleCustomerOrderPlan();
                $schedulePlan->customer_order_plan_id = $customerPlan->customer_order_plan_id;
                $schedulePlan->order_id = $customerPlan->order_id;
                $schedulePlan->manufacturing_order_number = $customerPlan->manufacturing_order_number;
                $schedulePlan->trans_date = $customerPlan->trans_date;
                $schedulePlan->from_date = $customerPlan->from_date;
                $schedulePlan->to_date = $customerPlan->to_date;
                $schedulePlan->description = $customerPlan->description;
                //$schedulePlan->factory_type = $factory_type;
                $status = $schedulePlan->save();
                if ($status) {
                    $planData = CustomerPlanData::find($order_plan_data_id);
                    if ($planData) {
                        //ScheduleCustomerOrderPlanData::where('customer_order_plan_id', '=', $order_id)->delete();
                        $schedulePlanData = new ScheduleCustomerOrderPlanData();
                        $schedulePlanData->customer_order_plan_data_id = $planData->customer_order_plan_data_id;
                        $schedulePlanData->customer_order_plan_id = $planData->customer_order_plan_id;
                        $schedulePlanData->order_data_id = $planData->order_data_id;
                        $schedulePlanData->manufacturing_order_no = $planData->manufacturing_order_no;
                        $schedulePlanData->product_id = $planData->product_id;
                        $schedulePlanData->product_name = $planData->product_name;
                        $schedulePlanData->quantity = $planData->quantity;
                        $schedulePlanData->status = $planData->status;
                        $schedulePlanData->factory_type = $factory_type;
                        if ($schedulePlanData->save()) {

                            $query = 'SELECT pp_customer_orders.order_id
                            FROM pp_customer_order_plans
                            INNER JOIN pp_customer_orders ON pp_customer_order_plans.order_id = pp_customer_orders.order_id
                            INNER JOIN pp_customer_order_plans_data ON pp_customer_order_plans.customer_order_plan_id = pp_customer_order_plans_data.customer_order_plan_id
                            WHERE pp_customer_orders.production_status = "1" AND pp_customer_order_plans_data.production_schedule = "0" AND pp_customer_order_plans_data.customer_order_plan_id = "' . $order_id . '" 
                            GROUP BY pp_customer_order_plans_data.customer_order_plan_data_id ORDER BY pp_customer_order_plans.customer_order_plan_id DESC';

                            $result = DB::select($query);

                            if (count($result) <= 1) {
                                foreach ($result as $order) {
                                    $customer_order = CustomerOrder::find($order->order_id);
                                    if ($customer_order) {
                                        $customer_order->production_status = '2';
                                        $customer_order->update();
                                    }
                                }
                            }
                            $planData->production_schedule = true;
                            $planData->production_status = 2;
                            if ($planData->update()) {
                                OrderStatusHistoryController::changeProductionStatus($planData);
                            }
                            $this->saveScheduleMachineryPlan($planData->customer_order_plan_data_id);
                            $this->saveScheduleOrderResourceBom($planData->customer_order_plan_data_id);
                            $this->saveScheduleOrderResourceHr($planData->customer_order_plan_data_id);
                        }
                    }
                }
            }
            return true;
        } catch (\Exception $ex) {
            ScheduleCustomerOrderPlan::where('order_id', '=', $schedulePlan->order_id)->delete();
            ScheduleCustomerOrderPlanData::where('customer_order_plan_id', '=', $schedulePlanData->customer_order_plan_id)->delete();
            $planData->production_schedule = false;
            $planData->update();
            return false;
        }
    }




    private function saveScheduleMachineryPlan($order_plan_data_id)
    {

        $machineryPlans = MachineryPlan::where('customer_order_plan_data_id', '=', $order_plan_data_id)->get();
        ScheduleMachineryPlan::where('customer_order_plan_data_id', '=', $order_plan_data_id)->delete();
        foreach ($machineryPlans as $machine) {
            $scheduleMachineryPlan = new ScheduleMachineryPlan();
            $scheduleMachineryPlan->machinery_plan_id = $machine->machinery_plans_id;
            $scheduleMachineryPlan->customer_order_plan_data_id = $machine->customer_order_plan_data_id;
            $scheduleMachineryPlan->machinery_id = $machine->machinery_id;
            $scheduleMachineryPlan->product_primary_id = $machine->product_primary_id;
            $scheduleMachineryPlan->date = $machine->date;
            $scheduleMachineryPlan->from = $machine->from;
            $scheduleMachineryPlan->to = $machine->to;
            $scheduleMachineryPlan->quantity = $machine->quantity;
            $scheduleMachineryPlan->shift_id = $machine->shift_id;
            $scheduleMachineryPlan->save();
        }
    }



    private function saveScheduleOrderResourceBom($order_plan_data_id)
    {

        $orderBoms = OrderResourceBom::where('customer_order_plan_data_id', '=', $order_plan_data_id)->get();
        ScheduleOrderResourceBom::where('customer_order_plan_data_id', '=', $order_plan_data_id)->delete();
        foreach ($orderBoms as $bom) {
            $cheduleOrderResourceBom = new ScheduleOrderResourceBom();
            $cheduleOrderResourceBom->order_resource_bom_id = $bom->order_resource_bom_id;
            $cheduleOrderResourceBom->customer_order_plan_data_id = $bom->customer_order_plan_data_id;
            $cheduleOrderResourceBom->fg_product_id = $bom->fg_product_id;
            $cheduleOrderResourceBom->rm_product_id = $bom->rm_product_id;
            $cheduleOrderResourceBom->quantity = $bom->quantity;
            $cheduleOrderResourceBom->uom = $bom->uom;
            $cheduleOrderResourceBom->tolerance = $bom->tolerance;
            $cheduleOrderResourceBom->save();
        }
    }



    private function saveScheduleOrderResourceHr($order_plan_data_id)
    {

        $orderHrs = OrderResourceHr::where('customer_order_plan_data_id', '=', $order_plan_data_id)->get();
        ScheduleOrderResourceHr::where('customer_order_plan_data_id', '=', $order_plan_data_id)->delete();
        foreach ($orderHrs as $hr) {
            $scheduleOrderResourceHr = new ScheduleOrderResourceHr();
            $scheduleOrderResourceHr->order_resource_hr_id = $hr->order_resource_hr_id;
            $scheduleOrderResourceHr->customer_order_plan_data_id = $hr->customer_order_plan_data_id;
            $scheduleOrderResourceHr->fg_product_id = $hr->fg_product_id;
            $scheduleOrderResourceHr->shift_id = $hr->shift_id;
            $scheduleOrderResourceHr->designation_id = $hr->designation_id;
            $scheduleOrderResourceHr->no_of_heads = $hr->no_of_heads;
            $scheduleOrderResourceHr->save();
        }
    }







    public function getSelectedDailyProduction($order_id)
    {
        try {
            $query = 'SELECT pd_schedule_customer_order_plans.trans_date,
            pp_customer_orders.purchase_order,
            pp_customer_orders.factory_po_num,
            st_products.product_id,
            st_products.product_name,
            MIN(pd_schedule_machinery_plans.date) AS from_date,
            MAX(pd_schedule_machinery_plans.date) AS to_date,
            hr_employee_sites.site AS factory,
            pd_schedule_machinery_plans.machinery_id,
            pd_schedule_machinery_plans.product_primary_id,
            pd_schedule_machinery_plans.customer_order_plan_data_id
            FROM pd_schedule_customer_order_plans
            INNER JOIN pp_customer_orders ON pd_schedule_customer_order_plans.order_id = pp_customer_orders.order_id
            INNER JOIN pd_schedule_customer_order_plan_data ON pd_schedule_customer_order_plans.customer_order_plan_id = pd_schedule_customer_order_plan_data.customer_order_plan_id
            INNER JOIN st_products ON pd_schedule_customer_order_plan_data.product_id = st_products.product_primary_id
            INNER JOIN pd_schedule_machinery_plans ON pd_schedule_customer_order_plan_data.customer_order_plan_data_id = pd_schedule_machinery_plans.customer_order_plan_data_id
            INNER JOIN pp_machinery ON pd_schedule_machinery_plans.machinery_id = pp_machinery.machinery_id
            INNER JOIN hr_employee_sites ON pp_machinery.site_id = hr_employee_sites.site_id WHERE pd_schedule_customer_order_plans.customer_order_plan_id  = "' . $order_id . '" GROUP BY pd_schedule_machinery_plans.customer_order_plan_data_id';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "ProductionScheduleCreateController", "productionPlan", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionScheduleCreateController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }



    function factories()
    {
        try {
            $factory = Factory::all();

            $responseBody = $this->responseBody(true, "factories", "Found", $factory);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "factories", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function loadMachinesToFactory($id)
    {
        try {
            $machines = Machinary::where('factory_id', $id)->get();
            return $this->responseBody(true, "loadMachinesToFactory", "found", $machines);
        } catch (\Exception $exception) {
            return $this->responseBody(false, "loadMachinesToFactory", "error", $exception->getMessage());
        }
    }


    function allShift()
    {
        try {
            $shift = AttShift::all();

            $responseBody = $this->responseBody(true, "allShift", "Found", $shift);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "allShift", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }







    public function getSelectedProductDataToMaterial($customer_order_plan_data_id, $product_primary_id)
    {
        try {

            $allocated_qty = $this->getAllocatedQuantity($customer_order_plan_data_id, $product_primary_id, '');
            $bom_header_qty = $this->getBomHeaderQuantityProduct($product_primary_id);
            $customerPlanData =  CustomerPlanData::find($customer_order_plan_data_id);
            if ($customerPlanData) {
                $customerPlanData->factory_po = "";
                $customerPlanData->customer_po = "";
                $customerPlanData->product_code = "";
                $customerPlanData->allocated_quantity = $allocated_qty;
                $customerPlanData->bom_header_quantity = $bom_header_qty;
                $orderData = CustomerOrderData::find($customerPlanData->order_data_id);
                if ($orderData) {
                    $customerOrder = CustomerOrder::find($orderData->order_id);
                    if ($customerOrder) {
                        $customerPlanData->factory_po = $customerOrder->factory_po_num;
                        $customerPlanData->customer_po = $customerOrder->purchase_order;
                    }
                }
                $product = Product::find($customerPlanData->product_id);
                if ($product) {
                    $customerPlanData->product_code = $product->product_id;
                }
            }
            $responseBody = $this->responseBody(true, "CustomerPlanData", "getSelectedProductData", $customerPlanData);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AllocateMachineController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    function getAllocatedBOMData($product_code, $bom_name)
    {
        try {
            $query = 'SELECT pp_bom_data.* FROM pp_bom_data INNER JOIN pp_bom_header ON pp_bom_data.pp_bom_header_id = pp_bom_header.pp_bom_header_id
            WHERE pp_bom_header.product_id = "' . $product_code . '" AND pp_bom_header.bom_name = "' . $bom_name . '"';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "getAllocatedBOMData", "Found", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getAllocatedBOMData", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function allRawMaterialProducts()
    {
        try {
            $products =  Product::select('product_primary_id As id', 'product_name As value0')->get();
            return $this->responseBody(true, "AllocateMachineController", "allRawMaterialProducts", $products);
        } catch (\Exception $exception) {
            return $this->responseBody(false, "AllocateMachineController", "error", $exception);
        }
    }


    public function isAllocatedMaterials($product_primary_id, $order_plan_data_id)
    {
        $bool = false;
        try {
            $mi_header = OrderResourceBom::where([['customer_order_plan_data_id', '=', $order_plan_data_id], ['fg_product_id', '=', $product_primary_id]])->get();
            if (count($mi_header) > 0) {
                $bool = true;
            }
            $responseBody = $this->responseBody(true, "ProductionScheduleCreateController", "isAllocatedMaterials", $bool);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionScheduleCreateController", "isAllocatedMaterials", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function isAllocatedMachineries($product_primary_id, $order_plan_data_id)
    {
        $bool = false;
        try {
            $machinery_plan = MachineryPlan::where([['customer_order_plan_data_id', '=', $order_plan_data_id], ['product_primary_id', '=', $product_primary_id]])->get();
            if (count($machinery_plan) > 0) {
                $bool = true;
            }
            $responseBody = $this->responseBody(true, "ProductionScheduleCreateController", "isAllocatedMachineries", $bool);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionScheduleCreateController", "isAllocatedMachineries", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function isProductionStart($order_plan_data_id)
    {
        $bool = false;
        try {
            $start = ProductionRecordsSupervisor::where('customer_order_plan_data_id', '=', $order_plan_data_id)->get();
            if (count($start) > 0) {
                $bool = true;
            }
            $responseBody = $this->responseBody(true, "ProductionScheduleCreateController", "isProductionStart", $bool);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionScheduleCreateController", "isProductionStart", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function allOutsideFactories()
    {
        try {
            $outsideFactories  = OutsideFactory::where('status', '=', 1)->get();
            $responseBody = $this->responseBody(true, "ProductionScheduleCreateController", "allOutsideFactories", $outsideFactories);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionScheduleCreateController", "allOutsideFactories", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function breakdown(Request $request, $schedule_machinery_plan_id)
    {
        try {
            $bool = false;
            $machinery_plan = ScheduleMachineryPlan::find($schedule_machinery_plan_id);
            if ($machinery_plan) {
                $machinery_plan->completed = $request->get('completed');
                $machinery_plan->status = $request->get('status');
                $machinery_plan->breakdown_id = $request->get('breakdown_id');
                $bool = $machinery_plan->update();
            }
            $responseBody = $this->responseBody(true, "ProductionScheduleListController", "breakdown", $bool);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "ProductionScheduleListController", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function undoBreakdown(Request $request, $schedule_machinery_plan_id)
    {
        try {
            $bool = false;
            $machinery_plan = ScheduleMachineryPlan::find($schedule_machinery_plan_id);
            if ($machinery_plan) {
                $machinery_plan->completed = $request->get('completed');
                $machinery_plan->status = $request->get('status');
                $machinery_plan->breakdown_id = $request->get('breakdown_id');
                $bool = $machinery_plan->update();
            }
            $responseBody = $this->responseBody(true, "ProductionScheduleListController", "breakdown", $bool);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "ProductionScheduleListController", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }





    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
