<?php

namespace Modules\Pd\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Pp\Entities\CustomerPlanData;
use Modules\Pp\Entities\Machinary;
use Modules\St\Entities\Product;

class ProductionScheduleGanttChartController extends Controller
{
    public function createGantChart($startDate, $endDate)
    {
        try {
            $machineryPlanArray = $this->createMachineryPlanArray($startDate, $endDate);
            $responseBody = $this->responseBody(true, "GanttChartController", "createGantChart", $machineryPlanArray);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "GanttChartController", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function createDayPlanArray($machinery_id, $shift_id, $startDate, $endDate)
    {

        $query = 'SELECT hr_att_shifts.shift_name AS `name`,
        pp_machinery.machinery_id AS machine_id,
        pd_schedule_machinery_plans.customer_order_plan_data_id,
        pd_schedule_machinery_plans.customer_order_plan_data_id AS order_id,
        pd_schedule_machinery_plans.date AS `start`,
        pd_schedule_machinery_plans.date AS `end`,
        ("#0275d8") AS color,
        ("#5cb85c") AS color2,
        ("true") AS `status` 
        FROM pd_schedule_machinery_plans
        INNER JOIN hr_att_shifts ON pd_schedule_machinery_plans.shift_id = hr_att_shifts.shift_id
        INNER JOIN pp_machinery ON pd_schedule_machinery_plans.machinery_id = pp_machinery.machinery_id
        WHERE pd_schedule_machinery_plans.date BETWEEN "' . $startDate . '" AND "' . $endDate . '" AND pd_schedule_machinery_plans.machinery_id = "' . $machinery_id . '" AND pd_schedule_machinery_plans.shift_id = "' . $shift_id . '" ORDER BY pd_schedule_machinery_plans.date';
        $dayPlanArray = DB::select($query);

        return  $dayPlanArray;
    }



    public function createMachineryPlanArray($startDate, $endDate)
    {
        $query = 'SELECT hr_att_shifts.shift_id,
        pp_machinery.machinery_id,
        pp_machinery.machinery_no AS id,
        CONCAT(pp_machinery.machinery_no," - ",pp_machinery.machinery_name) AS `name`,
        "" AS series
        FROM pd_schedule_machinery_plans
        INNER JOIN hr_att_shifts ON pd_schedule_machinery_plans.shift_id = hr_att_shifts.shift_id
        INNER JOIN pp_machinery ON pd_schedule_machinery_plans.machinery_id = pp_machinery.machinery_id
        WHERE pd_schedule_machinery_plans.date BETWEEN "' . $startDate . '" AND "' . $endDate . '" GROUP BY pd_schedule_machinery_plans.machinery_id,pd_schedule_machinery_plans.shift_id';
        $machineryPlanArray = DB::select($query);
        foreach ($machineryPlanArray as $plan) {
            $series = [];
            $createDayPlanArray = $this->createDayPlanArray($plan->machinery_id, $plan->shift_id, $startDate, $endDate);
            array_push($series, $createDayPlanArray);
            $plan->series = $series;
        }
        return $machineryPlanArray;
    }


    public function searchMachineryPlanArray($machinery_id, $product_primary_id, $customer_order_plan_data_id, $startDate, $endDate)
    {
        $query = 'SELECT hr_att_shifts.shift_id,
        pp_machinery.machinery_id,
        pp_machinery.machinery_no AS id,
        CONCAT(pp_machinery.machinery_no," - ",pp_machinery.machinery_name) AS `name`,
        "" AS series
        FROM pd_schedule_machinery_plans
        INNER JOIN hr_att_shifts ON pd_schedule_machinery_plans.shift_id = hr_att_shifts.shift_id
        INNER JOIN pp_machinery ON pd_schedule_machinery_plans.machinery_id = pp_machinery.machinery_id
        WHERE pd_schedule_machinery_plans.machinery_id = "' . $machinery_id . '"';

        if ($product_primary_id != null) {
            $query .= ' AND pd_schedule_machinery_plans.product_primary_id = "' . $product_primary_id . '"';
        }

        if ($customer_order_plan_data_id != null) {
            $query .= ' AND pd_schedule_machinery_plans.customer_order_plan_data_id = "' . $customer_order_plan_data_id . '"';
        }

        $query .= ' AND pd_schedule_machinery_plans.date BETWEEN "' . $startDate . '" AND "' . $endDate . '" GROUP BY pd_schedule_machinery_plans.machinery_id,pd_schedule_machinery_plans.shift_id';

        $machineryPlanArray = DB::select($query);
        foreach ($machineryPlanArray as $plan) {
            $series = [];
            $createDayPlanArray = $this->createDayPlanArray($plan->machinery_id, $plan->shift_id, $startDate, $endDate);
            array_push($series, $createDayPlanArray);
            $plan->series = $series;
        }
        return $machineryPlanArray;
    }



    public function searchGantChart($setting, $startDate, $endDate)
    {
        try {
            $machinery_id = json_decode($setting)->machine;
            $product_primary_id = json_decode($setting)->product;
            $customer_order_plan_data_id = json_decode($setting)->order;
            $machineryPlanArray = $this->searchMachineryPlanArray($machinery_id, $product_primary_id, $customer_order_plan_data_id, $startDate, $endDate);
            $responseBody = $this->responseBody(true, "GanttChartController", "createGantChart", $machineryPlanArray);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "GanttChartController", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    function loadProducts()
    {
        try {
            $Product = Product::where('product_type_id', 4)->select('product_name', 'product_primary_id')->get();

            $responseBody = $this->responseBody(true, "GanttChart", "Found", $Product);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "GanttChart", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }


    function loadMachine()
    {
        try {
            $machine = Machinary::where('status', 1)->select('machinery_no', 'machinery_id')->get();

            $responseBody = $this->responseBody(true, "GanttChart", "Found", $machine);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "GanttChart", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    function loadOrder()
    {
        try {
            $orders = CustomerPlanData::select('customer_order_plan_data_id', 'manufacturing_order_no')->get();

            $responseBody = $this->responseBody(true, "GanttChart", "Found", $orders);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "GanttChart", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function ganttChartModalData($customer_order_id, $machine_id, $startDate, $endDate)
    {
        try {
            $query = 'SELECT pd_schedule_machinery_plans.date,
            pp_machinery.machinery_name,
            pp_machinery.machinery_no,
            (SELECT pd_schedule_customer_order_plans.manufacturing_order_number FROM pd_schedule_customer_order_plans WHERE pd_schedule_customer_order_plans.customer_order_plan_id = pd_schedule_machinery_plans.customer_order_plan_data_id)AS manufacturing_order_no,
            (SELECT pd_schedule_customer_order_plans.order_id FROM pd_schedule_customer_order_plans WHERE pd_schedule_customer_order_plans.customer_order_plan_id = pd_schedule_machinery_plans.customer_order_plan_data_id)AS purchase_order,
            st_products.product_name,
            hr_att_shifts.shift_name,
            pd_schedule_machinery_plans.quantity
            FROM pd_schedule_machinery_plans 
            INNER JOIN st_products ON pd_schedule_machinery_plans.product_primary_id = st_products.product_primary_id
            INNER JOIN hr_att_shifts ON pd_schedule_machinery_plans.shift_id = hr_att_shifts.shift_id
            INNER JOIN pp_machinery ON pd_schedule_machinery_plans.machinery_id = pp_machinery.machinery_id
            WHERE pd_schedule_machinery_plans.customer_order_plan_data_id = "' . $customer_order_id . '" 
            AND pd_schedule_machinery_plans.machinery_id = "' . $machine_id . '" AND pd_schedule_machinery_plans.date BETWEEN "' . $startDate . '" AND "' . $endDate . '"';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "ganttChartModalData", "createGantChart", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "ganttChartModalData", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }




    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
