<?php

namespace Modules\Pd\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Pd\Entities\ProductionMachineBreakdown;
use Modules\Pd\Entities\ScheduleCustomerOrderPlan;
use Modules\Pd\Entities\ScheduleCustomerOrderPlanData;
use Modules\Pd\Entities\ScheduleMachineryPlan;
use Modules\Pd\Entities\ScheduleOrderResourceBom;
use Modules\Pd\Entities\ScheduleOrderResourceHr;
use Modules\Pp\Entities\CustomerOrder;
use Modules\Pp\Entities\CustomerPlan;
use Modules\Pp\Entities\CustomerPlanData;

class ProductionScheduleListController extends Controller
{
    public function productionPlanInHouse()
    {
        try {
            /*$query = 'SELECT pd_schedule_customer_order_plan_data.customer_order_plan_data_id,
            pd_schedule_customer_order_plans.trans_date,
            pd_schedule_customer_order_plans.customer_order_plan_id,
            pp_customer_orders.purchase_order,
            pp_customer_orders.factory_po_num,
            pp_customer_orders.order_id,
            st_products.product_id,
            st_products.product_name,
            MIN(pd_schedule_machinery_plans.date) AS from_date,
            MAX(pd_schedule_machinery_plans.date) AS to_date,
            hr_employee_sites.site AS factory,
            pd_schedule_machinery_plans.machinery_plan_id,
            pd_schedule_machinery_plans.machinery_id,
            pd_schedule_machinery_plans.product_primary_id,
            pd_schedule_machinery_plans.customer_order_plan_data_id
            FROM pd_schedule_customer_order_plan_data
            LEFT JOIN pd_schedule_customer_order_plans ON pd_schedule_customer_order_plan_data.customer_order_plan_id = pd_schedule_customer_order_plans.customer_order_plan_id
            LEFT JOIN pp_customer_orders ON pd_schedule_customer_order_plans.order_id = pp_customer_orders.order_id
            LEFT JOIN st_products ON pd_schedule_customer_order_plan_data.product_id = st_products.product_primary_id
            LEFT JOIN pd_schedule_machinery_plans ON pd_schedule_customer_order_plan_data.customer_order_plan_data_id = pd_schedule_machinery_plans.customer_order_plan_data_id
            LEFT JOIN pp_machinery ON pd_schedule_machinery_plans.machinery_id = pp_machinery.machinery_id
            LEFT JOIN hr_employee_sites ON pp_machinery.site_id = hr_employee_sites.site_id WHERE pp_customer_orders.production_status = "2"
            GROUP BY pd_schedule_customer_order_plan_data.customer_order_plan_data_id ORDER BY pd_schedule_customer_order_plan_data.customer_order_plan_data_id DESC';*/



            $query = 'SELECT pd_schedule_customer_order_plan_data.customer_order_plan_data_id,
            pd_schedule_customer_order_plans.trans_date,
            pd_schedule_customer_order_plans.customer_order_plan_id,
            pp_customer_orders.purchase_order,
            pp_customer_orders.factory_po_num,
            pp_customer_orders.order_id,
            st_products.product_primary_id,
            st_products.product_id,
            st_products.product_name ,
            ( SELECT   MIN(date)   
               FROM pd_schedule_machinery_plans  
              WHERE  customer_order_plan_data_id = pd_schedule_customer_order_plan_data.customer_order_plan_data_id  ) As from_date ,
            ( SELECT  MAX(date) 
               FROM pd_schedule_machinery_plans  
              WHERE  customer_order_plan_data_id = pd_schedule_customer_order_plan_data.customer_order_plan_data_id  )  As to_date  
            FROM pd_schedule_customer_order_plans
            LEFT JOIN pd_schedule_customer_order_plan_data ON pd_schedule_customer_order_plans.customer_order_plan_id = pd_schedule_customer_order_plan_data.customer_order_plan_id
            LEFT JOIN pp_customer_orders ON pd_schedule_customer_order_plans.order_id = pp_customer_orders.order_id
            LEFT JOIN st_products ON pd_schedule_customer_order_plan_data.product_id = st_products.product_primary_id WHERE pd_schedule_customer_order_plan_data.factory_type = "0"
            ORDER BY pd_schedule_customer_order_plan_data.customer_order_plan_data_id DESC';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "ProductionScheduleCreateController", "productionPlan", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionScheduleCreateController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }




    public function productionPlanOutside()
    {
        try {
        
            $query = 'SELECT pd_schedule_customer_order_plan_data.customer_order_plan_data_id,
            pd_schedule_customer_order_plans.trans_date,
            pd_schedule_customer_order_plans.customer_order_plan_id,
            pp_customer_orders.purchase_order,
            pp_customer_orders.factory_po_num,
            pp_customer_orders.order_id,
            st_products.product_primary_id,
            st_products.product_id,
            st_products.product_name ,
            ( SELECT   MIN(date)   
               FROM pd_schedule_machinery_plans  
              WHERE  customer_order_plan_data_id = pd_schedule_customer_order_plan_data.customer_order_plan_data_id  ) As from_date ,
            ( SELECT  MAX(date) 
               FROM pd_schedule_machinery_plans  
              WHERE  customer_order_plan_data_id = pd_schedule_customer_order_plan_data.customer_order_plan_data_id  )  As to_date  
            FROM pd_schedule_customer_order_plans
            LEFT JOIN pd_schedule_customer_order_plan_data ON pd_schedule_customer_order_plans.customer_order_plan_id = pd_schedule_customer_order_plan_data.customer_order_plan_id
            LEFT JOIN pp_customer_orders ON pd_schedule_customer_order_plans.order_id = pp_customer_orders.order_id
            LEFT JOIN st_products ON pd_schedule_customer_order_plan_data.product_id = st_products.product_primary_id WHERE pd_schedule_customer_order_plan_data.factory_type = "1"
            ORDER BY pd_schedule_customer_order_plan_data.customer_order_plan_data_id DESC';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "ProductionScheduleCreateController", "productionPlan", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionScheduleCreateController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }





    function saveAllocateToMachine(Request $request)
    {
        try {



            $customer_order_plan_data_id = $request->get("customer_order_plan_data_id");
            $machinery_plan_id = $request->get("machinery_plan_id");
            $machinery_id = $request->get("machinery_id");
            $product_primary_id = $request->get("product_primary_id");
            $data = $request->get("data");
            ScheduleMachineryPlan::where([['customer_order_plan_data_id', '=', $customer_order_plan_data_id], ['machinery_id', '=', $machinery_id], ['product_primary_id', '=', $product_primary_id]])->delete();
            for ($i = 0; $i < count($data); $i++) {
                $dd = json_decode($data[$i]);

                if ($dd->date && $dd->from && $dd->to) {
                    $machineryPlan = new ScheduleMachineryPlan();
                    $machineryPlan->machinery_plan_id = $machinery_plan_id;
                    $machineryPlan->customer_order_plan_data_id = $customer_order_plan_data_id;
                    $machineryPlan->machinery_id = $machinery_id;
                    $machineryPlan->product_primary_id = $product_primary_id;
                    $machineryPlan->date = $dd->date;
                    $machineryPlan->from = $dd->from;
                    $machineryPlan->to = $dd->to;
                    $machineryPlan->quantity = $dd->quantity;
                    $machineryPlan->shift_id = $dd->shift;
                    $machineryPlan->save();
                }
            }

            $responseBody = $this->responseBody(true, "saveAllocateToMachine", "Found", true);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "saveAllocateToMachine", "error", $data);
        }
        return response()->json(["data" => $responseBody]);
    }


    function getAllocatedData($order_id, $product_id, $machinery_id)
    {
        try {
            //$machineProducts =  ScheduleMachineryPlan::where([['customer_order_plan_data_id', '=', $order_id], ['product_primary_id', '=', $product_id], ['machinery_id', '=', $machinery_id]])->get();
            $query = "SELECT pd_schedule_machinery_plans.*,
            (SELECT SUM(pp_machinery_plans.quantity) AS quantityx FROM pp_machinery_plans 
            WHERE pp_machinery_plans.customer_order_plan_data_id = pd_schedule_machinery_plans.customer_order_plan_data_id  AND pp_machinery_plans.product_primary_id = {$product_id}
            AND pp_machinery_plans.machinery_id != pd_schedule_machinery_plans.machinery_id AND pp_machinery_plans.date = pd_schedule_machinery_plans.date AND (pp_machinery_plans.`from` >= pd_schedule_machinery_plans.`from` AND pp_machinery_plans.`to` <= pd_schedule_machinery_plans.`to`)) AS allocated_quantity FROM pd_schedule_machinery_plans
            WHERE pd_schedule_machinery_plans.customer_order_plan_data_id ={$order_id} AND pd_schedule_machinery_plans.product_primary_id = {$product_id}
            AND pd_schedule_machinery_plans.machinery_id = {$machinery_id}";
            $machineProducts =  DB::select($query);
            $responseBody = $this->responseBody(true, "getAllocatedData", "Found", $machineProducts);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getAllocatedData", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    function getSavedAllocatedBOMData($customer_order_plan_data_id, $fg_product_id)
    {
        try {
            $query = 'SELECT st_product_units.name AS uom_name,st_products.product_primary_id,st_products.product_id,st_products.product_name,pd_schedule_order_resource_boms.* FROM st_products
            INNER JOIN pd_schedule_order_resource_boms ON st_products.product_primary_id = pd_schedule_order_resource_boms.rm_product_id
            INNER JOIN st_product_units ON pd_schedule_order_resource_boms.uom = st_product_units.id
            WHERE  pd_schedule_order_resource_boms.customer_order_plan_data_id = "' . $customer_order_plan_data_id . '" AND pd_schedule_order_resource_boms.fg_product_id = "' . $fg_product_id . '"';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "getSavedAllocatedBOMData", "Found", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getSavedAllocatedBOMData", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }




    function saveScheduleToBOM(Request $request)
    {
        try {
            $customer_order_plan_data_id = $request->get("customer_order_plan_data_id");
            $fg_product_id = $request->get("fg_product_primary_id");
            $resorce_bom = ScheduleOrderResourceBom::where([['fg_product_id', '=', $fg_product_id], ['customer_order_plan_data_id', '=', $customer_order_plan_data_id]])->first();
            ScheduleOrderResourceBom::where([['fg_product_id', '=', $fg_product_id], ['customer_order_plan_data_id', '=', $customer_order_plan_data_id]])->delete();

            $data = $request->get("data");
            foreach($data as $d){
                $dd = json_decode($d);

               if ($dd->rm_product_id != "null") {
                    $bom = new ScheduleOrderResourceBom();
                    $bom->order_resource_bom_id = $resorce_bom->order_resource_bom_id;
                    $bom->customer_order_plan_data_id = $customer_order_plan_data_id;
                    $bom->fg_product_id = $fg_product_id;
                    $bom->rm_product_id = $dd->rm_product_id;
                    $bom->quantity = $dd->quantity;
                    $bom->uom = $dd->uom;
                    $bom->tolerance = $dd->tolerance;
                    $bom->save();
                }
            }

            $responseBody = $this->responseBody(true, "saveAllocateToBOM", "Found", $data);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "saveAllocateToBOM", "error", ["fg_id" => $fg_product_id, "customer_order_plan_data_id" => $customer_order_plan_data_id]);
        }
        return response()->json(["data" => $responseBody]);
    }




    function getSaveProductionTeam($customer_order_plan_data_id, $fg_product_id, $shift_id)
    {
        try {
            $query = 'SELECT hr_employee_designations.designation_id,hr_employee_designations.designation,pd_schedule_order_resource_hrs.no_of_heads,pd_schedule_order_resource_hrs.shift_id FROM hr_employee_designations INNER JOIN pp_production_teams ON hr_employee_designations.designation_id = pp_production_teams.designation_id
            INNER JOIN pd_schedule_order_resource_hrs ON pp_production_teams.designation_id = pd_schedule_order_resource_hrs.designation_id WHERE pd_schedule_order_resource_hrs.customer_order_plan_data_id = "' . $customer_order_plan_data_id . '" AND pd_schedule_order_resource_hrs.fg_product_id = "' . $fg_product_id . '" AND pd_schedule_order_resource_hrs.shift_id="' . $shift_id . '"';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "getSavedProductionTeam", "Found", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getSavedProductionTeam", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }




    function saveAllocateToHR(Request $request)
    {
        try {



            $customer_order_plan_data_id = $request->get("customer_order_plan_data_id");
            $fg_product_id = $request->get("fg_product_id");
            $shift_id = $request->get("shift_id");
            $schedule_hr = ScheduleOrderResourceHr::where([['fg_product_id', '=', $fg_product_id], ['customer_order_plan_data_id', '=', $customer_order_plan_data_id]])->first();
            ScheduleOrderResourceHr::where([['fg_product_id', '=', $fg_product_id], ['customer_order_plan_data_id', '=', $customer_order_plan_data_id], ['shift_id', '=', $shift_id]])->delete();

            $data = $request->get("data");
            for ($i = 0; $i < count($data); $i++) {
                $dd = json_decode($data[$i]);

                if ($dd->no_of_heads && $schedule_hr) {
                    $hr = new ScheduleOrderResourceHr();
                    $hr->order_resource_hr_id = $schedule_hr->order_resource_hr_id;
                    $hr->customer_order_plan_data_id = $customer_order_plan_data_id;
                    $hr->fg_product_id = $fg_product_id;
                    $hr->shift_id = $shift_id;
                    $hr->designation_id = $dd->designation_id;
                    $hr->no_of_heads = $dd->no_of_heads;
                    $hr->save();
                }
            }

            $responseBody = $this->responseBody(true, "saveAllocateToHR", "Found", $dd);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "saveAllocateToHR", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function delete($order_id, $customer_order_plan_id, $customer_order_id)
    {
        try {

            ScheduleOrderResourceHr::where('customer_order_plan_data_id', '=', $order_id)->delete();
            ScheduleOrderResourceBom::where('customer_order_plan_data_id', '=', $order_id)->delete();
            ScheduleMachineryPlan::where('customer_order_plan_data_id', '=', $order_id)->delete();
            ScheduleCustomerOrderPlanData::where('customer_order_plan_id', '=', $customer_order_plan_id)->delete();
            ScheduleCustomerOrderPlan::where('customer_order_plan_id', '=', $customer_order_plan_id)->delete();

            $plans_data = CustomerPlanData::where('customer_order_plan_id', '=', $customer_order_plan_id)->get();
            foreach ($plans_data as $plan_data) {
                $plan_data->production_schedule = '0';
                $plan_data->update();
            }
            $customer_order = CustomerOrder::find($customer_order_id);
            if ($customer_order) {
                $customer_order->production_status = '1';
                $customer_order->update();
            }
            $responseBody = $this->responseBody(true, "saveAllocateToHR", "Found", true);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "saveAllocateToHR", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function getPendingMachineBreakdownData($machine_id)
    {
        try {
            $breakdown_id = 0;
            $breakdown = ProductionMachineBreakdown::where([['machinery_id', '=', $machine_id],['status', '=', 0]])->first();
            if ($breakdown) {
                $breakdown_id = $breakdown->id;
            }
            $responseBody = $this->responseBody(true, "getPendingMachineBreakdownData", "Found", $breakdown_id);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getPendingMachineBreakdownData", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }








    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
