<?php

namespace Modules\Pd\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Pd\Entities\BreakdownReason;

class SettingsController extends Controller
{

    public function saveReasonOfBreakdown(Request $request)
    {

        try {
            $reasonOfBreakdown = new BreakdownReason();
            $reasonOfBreakdown->reason = $request->get('reason');
            $reasonOfBreakdown->status = 1;
            $reasonOfBreakdown->save();
            $responseBody = $this->responseBody(true, "SettingsController", "saveReasonOfBreakdown", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }



    public function updateReasonOfBreakdown(Request $request, $id)
    {

        try {
            $reasonOfBreakdown =  BreakdownReason::find($id);
            $reasonOfBreakdown->reason = $request->get('reason');
            $reasonOfBreakdown->update();
            $responseBody = $this->responseBody(true, "SettingsController", "updateReasonOfBreakdown", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }


    public function disableReason($id)
    {

        try {
            $reasonOfBreakdown =  BreakdownReason::find($id);
            if ($reasonOfBreakdown->status == 0) {
                $reasonOfBreakdown->status = 1;
            } else {
                $reasonOfBreakdown->status = 0;
            }

            $reasonOfBreakdown->update();
            $responseBody = $this->responseBody(true, "SettingsController", "disableReason", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }

    public function allReason()
    {

        try {
            $reasonOfBreakdowns = BreakdownReason::all();
            $responseBody = $this->responseBody(true, "SettingsController", "allReason", $reasonOfBreakdowns);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }



    public function getReason($id)
    {

        try {
            $reasonOfBreakdown = BreakdownReason::find($id);
            $responseBody = $this->responseBody(true, "SettingsController", "getReason", $reasonOfBreakdown);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }

    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
