class HrModal {

    static CUSTOMER_ORDER_PLAN_DATA_ID = undefined;
    static FG_PRODUCT_ID = undefined;
    constructor(parent) {

        $.ajax({
            url: 'HrModal',
            type: 'GET',
            async: false,
            success: function (data) {
                parent.html($(data).find('#modal').html());
            }
        });




    }


    show() {

        $('#hrModal').modal('show');
    }

    hide() {
        $('#hrModal').modal('hide');
    }



    getSelectedModalData(order_plan_data_id, product_primary_id) {
        HrModal.CUSTOMER_ORDER_PLAN_DATA_ID = order_plan_data_id;
        HrModal.FG_PRODUCT_ID = product_primary_id;
        $.ajax({
            type: 'GET',
            url: '/pd/ProductionScheduleCreateController/getSelectedProductData/' + order_plan_data_id + "/" + product_primary_id,
            async: false,
            success: function (response) {
                console.log(response.data.result);
                if (response.data.success) {
                    $('#lblHRProductCode').text(": " + response.data.result.product_code);
                    $('#lblHRProductName').text(": " + response.data.result.product_name);
                    $('#lblHRFactoryPO').text(": " + response.data.result.factory_po);
                    $('#lblHRCustomerPO').text(": " + response.data.result.customer_po);
                    $('#lblHRProductionQty').text(": " + response.data.result.quantity);
                    $('#lblHRAllocateQty').text(": " + response.data.result.allocated_quantity);
                    HrModal.getSavedAllocatedDataToSummaryHR(order_plan_data_id, product_primary_id);

                }

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();
            },
            complete: function () {

            }
        });

        this.getMachineryShifts(order_plan_data_id);
    }





    getMachineryShifts(customer_order_plan_data_id) {
        $.ajax({
            type: 'GET',
            url: '/pd/ProductionScheduleCreateController/getMachineryShifts/' + customer_order_plan_data_id,
            async: false,
            success: function (response) {
                console.log(response.data.result);
                if (response.data.success) {
                    var array = response.data.result;
                    $('#cmbShiftHR').empty();
                    for (var i = 0; i < array.length; i++) {
                        $('#cmbShiftHR').append('<option value="' + array[i].shift_id + '">' + array[i].shift_name + '</option>');
                    }
                }

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();
            },
            complete: function () {

            }
        });
    }






    static getSavedAllocatedDataToSummaryHR(order_id, product_primary_id) {


        $.ajax({
            type: 'GET',
            url: "/pd/ProductionScheduleCreateController/getSaveProductionTeam/" + order_id + "/" + product_primary_id,
            async: false,
            beforeSend: function () {
                //progress(true);
            },
            success: function (response) {
                console.log(response.data.result);
                if (response.data.success) {
                    var data = response.data.result;
                    $('#tblSummaryHR').empty();
                    for (var i = 0; i < data.length; i++) {
                        $('#tblSummaryHR').append('<tr><td>' + data[i].designation + '</td><td style="text-align:right;">' + data[i].count + '</td><td style="text-align:right;">0</td><td style="text-align:right;">0</td></tr>');
                    }

                }


            },
            error: function (data) {

            },
            complete: function () {
                //progress(false);
            }
        });

    }



    static getSavedAllocatedDataToDetailsHR() {

        $.ajax({
            type: 'GET',
            url: "/pd/ProductionScheduleCreateController/getSavedAllocatedDataToDetailsHR/" + HrModal.CUSTOMER_ORDER_PLAN_DATA_ID + "/" + HrModal.FG_PRODUCT_ID + "/" + $('#cmbShiftHR').val(),
            async: false,
            beforeSend: function () {
                //progress(true);
            },
            success: function (response) {
                console.log(response.data.result);
                if (response.data.success) {
                    var data = response.data.result;
                    $('#tblDetailsHR').empty();
                    for (var i = 0; i < data.length; i++) {
                        $('#tblDetailsHR').append('<tr><td>' + data[i].designation + '</td><td style="text-align:right;">' + data[i].count + '</td><td style="text-align:right;">0</td><td style="text-align:right;">0</td></tr>');
                    }

                }


            },
            error: function (data) {

            },
            complete: function () {
                //progress(false);
            }
        });
    }








}