class OutsideFactoryModal {

    static QUANTITY_PER_HOUR = 0;
    static CUSTOMER_ORDER_PLAN_DATA_ID = undefined;
    static CUSTOMER_ORDER_PLAN_ID = undefined;
    static PRODUCT_PRIMARY_ID = undefined;
    static PRODUCT_ID = undefined;
    static PRODUCT_NAME = undefined;
    static FACTORY_PO = undefined;
    static ORDER_ID = undefined;

    constructor(parent) {

        $.ajax({
            url: 'OutsideFactoryModal',
            type: 'GET',
            async: false,
            success: function (data) {
                parent.html($(data).find('#modal').html());
            }
        });

        $('#btnSaveOutsideAction').on('click', function () {
            saveOutsideFactory(OutsideFactoryModal.CUSTOMER_ORDER_PLAN_DATA_ID, OutsideFactoryModal.CUSTOMER_ORDER_PLAN_ID, OutsideFactoryModal.PRODUCT_PRIMARY_ID, OutsideFactoryModal.PRODUCT_ID, OutsideFactoryModal.PRODUCT_NAME, OutsideFactoryModal.FACTORY_PO, OutsideFactoryModal.ORDER_ID);
        });

    }


    show() {
        $('#outsideFactoryModal').modal('show');
        addRow(0);

    }

    hide() {
        $('#outsideFactoryModal').modal('hide');
    }



    getOutsideFactoryHeaderModalData(order_plan_data_id, product_primary_id) {
        $.ajax({
            type: 'GET',
            url: '/pd/ProductionScheduleCreateController/getSelectedProductData/' + order_plan_data_id + "/" + product_primary_id,
            async: false,
            success: function (response) {
                console.log(response.data.result);
                if (response.data.success) {
                    $('#lblProductCode').text(": " + response.data.result.product_code);
                    $('#lblProductName').text(": " + response.data.result.product_name);
                    $('#lblFactoryPO').text(": " + response.data.result.factory_po);
                    $('#lblCustomerPO').text(": " + response.data.result.customer_po);
                    $('#lblProductionQty').text(": " + response.data.result.quantity);
                    $('#lblAllocateQty').text(": " + response.data.result.allocated_quantity);

                }

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();
            },
            complete: function () {

            }
        });


    }



    dataSource() {

        var collection = {};
        var table = document.getElementById('tblOutsideFactory'),
            rows = table.getElementsByTagName('tr'),
            i, j, cells, customerId;

        for (i = 0, j = rows.length; i < j; ++i) {
            cells = rows[i].getElementsByTagName('td');
            if (!cells.length) {
                continue;
            }
            var data = {
                "factory": cells[0].childNodes[0].value,
                "start": cells[1].childNodes[0].value,
                "expected": cells[2].childNodes[0].value,
                "quantity": cells[3].childNodes[0].value,
            };
            collection[i] = JSON.stringify(data);



        }

        return collection;

    };


}



function addRow(id) {
    $('#' + id).text("Remove");
    $('#' + id).attr('class', 'btn btn-danger remove');
    $('#' + id).attr('onclick', '');

    var btn_id = "BOM" + guidGenerator();
    var cmbFactory_id = "cmbFactory" + guidGenerator();
    var txtStartingDate_id = "txtStartingDate" + guidGenerator();
    var txtExpectingDate_id = "txtExpectingDate" + guidGenerator();
    var txtQty_id = "txtQty" + guidGenerator();


    var string_id = "'" + btn_id + "'";
    //var string_txtBOMMat_id = "'" + txtBOMMat_id + "'";


    var row = '<tr id="' + id + '">';
    row += '<td><select id="' + cmbFactory_id + '" class="form-control-sm" style="width:350px; border:1px solid gray;padding:0px;" ></select></td>';
    row += '<td><input id="' + txtStartingDate_id + '" name="date" type="text" class="form-control-sm" style="width:100px;text-align:right; border:1px solid gray;background:white;"  autocomplete="off"></td>';
    row += '<td><input id="' + txtExpectingDate_id + '" name="date" type="text" class="form-control-sm" style="width:100px;text-align:right; border:1px solid gray;background:white;"  autocomplete="off"></td>';
    row += '<td><input id="' + txtQty_id + '" type="text" class="form-control-sm" style="width:100px;text-align:right; border:1px solid gray;background:white;"  autocomplete="off"></td>';
    row += '<td><button type="button" id="' + btn_id + '" class="btn btn-primary" onclick="addRow(' + string_id + ')">Add</button></td></tr>';
    $('#tblOutsideFactory').append(row);

    $(".remove").click(function () {
        $(this).closest("tr").remove();
    });


    $('input[name="date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });


    for (var i = 0; i < FACTORIES.length; i++) {
        $('#' + cmbFactory_id).empty();
        for (var i = 0; i < FACTORIES.length; i++) {
            $('#' + cmbFactory_id).append('<option value="' + FACTORIES[i].outside_factory_id + '">' + FACTORIES[i].name + '</option>');
        }
    }



    var comp = {
        "btn_id": btn_id,
        "factory": $('#' + cmbFactory_id),
        "start": $('#' + txtStartingDate_id),
        "expected": $('#' + txtExpectingDate_id),
        "qty": $('#' + txtQty_id),

    };
    //appendProductUnits(cmbBOMUOM_id);
    return comp;

}


function guidGenerator() {
    var S4 = function () {
        return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
    };
    return (S4() + S4());
}