console.log('producttion_plan_calender.js')

var events = [];

$(document).ready(function () {
    $('#calendar-demo').fullCalendar({
        header: {
            left: 'prev,next today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay,listMonth'
        },
        editable: true,
        droppable: true,
        drop: function () {
            $(this).remove();

        },
        weekNumbers: true,
        eventLimit: false, // allow "more" link when too many events
        dayClick: function () {
            $('#createEventModal').modal();

        },
        eventClick: function (event, jsEvent, view) {
            var factory_po = event.description.factory_po;
            var customer_po = event.description.customer_po;
            var product_id = event.description.product_id;
            var quantity = event.description.quantity;
            var product_name = event.description.product_name;
            var machine_id = event.description.machine_id;
            var machine_name = event.description.machine_name;

            var html = '';
            html += '<table class="table table-striped">';
            html += '<thead>';
            html += '<tr>';
            html += '<th>Factory PO</th><th>Customer PO</th><th>Machine ID</th><th>Machine Name</th><th>Product ID</th> <th>Product name</th><th>Qty</th>';
            html += '</tr>';
            html += '</thead>';
            html += '<tbody>';
            html += '<tr>';
            html += '<td>' + factory_po + '</td>';
            html += '<td>' + customer_po + '</td>';
            html += '<td>' + machine_id + '</td>';
            html += '<td>' + machine_name + '</td>';
            html += '<td>' + product_id + '</td>';
            html += '<td>' + product_name + '</td>';
            html += '<td>' + quantity + '</td>';
            html += '</tr>';
            html += '</tbody>';
            html += '</table>';

            var modal = $('#viewEventModal');
            modal.find('.event-body').html(html);
            modal.find('.event-icon').html("<i class='fa fa-" + event.icon + "'></i>");
            modal.find('.event-title').html(event.title);
            modal.modal();
        },
    });

    loadProductionPlan();

});

function loadProductionPlan() {
    $.ajax({
        type: 'GET',
        url: '/pd/ProductionScheduleCalendarController/loadProductionPlanToCalander',
        success: function (response) {
            if (response.data.success) {
                console.log(response);

                for (i = 0; i < response.data.result.length; i++) {
                    var end_date = response.data.result[i]['end_date'];
                    var start_date = response.data.result[i]['start_date'];
                    var product_id = response.data.result[i]['product_id'];
                    var product_name = response.data.result[i]['product_name'];
                    var breakdown = response.data.result[i]['breakdown'];
                    var quantity = response.data.result[i]['quantity'];
                    var machine_id = response.data.result[i]['machinery_no'];
                    var machine_name = response.data.result[i]['machinery_name'];
                    var factory_po = response.data.result[i]['factory_po'];
                    var customer_po = response.data.result[i]['customer_po'];
                    var newend_date = end_date.substring(0, 10);
                    var newstart_date = start_date.substring(0, 10);

                    // console.log(newDate);
                    addShedule(factory_po, customer_po, product_id, product_name, newstart_date, newend_date, quantity, machine_id, machine_name, breakdown);
                }
                createCalendar();
            }

        }, error: function (data) {
            console.log('Something went wrong!');
        }
    })
}



function addShedule(factory_po, customer_po, product_id, product_name, newstart_date, newend_date, quantity, machine_id, machine_name, breakdown) {



    //by nipuna start
    var R = (parseInt(product_id) * 215);
    while (R > 255) { R = R - 100 }
    var G = (parseInt(product_id) * 100);
    while (G > 255) { G = G - 50 }
    var B = (parseInt(product_id) * 50);
    while (B > 255) { B = B - 50 }

    var name = "(" + factory_po + ") ";
    if (breakdown == "(B.D)") {
        R = 255;
        G = 0;
        B = 0;
        name += "(Breakdown)";
    } else {
        name += product_name;
    }


    //by nipuna end
    events.push({
        title: name,
        start: newstart_date,
        end: newend_date,
        backgroundColor: 'rgb(' + R + ',' + G + ',' + B + ')',
        icon: "building-o",
        description: { "factory_po": factory_po, "customer_po": customer_po, "product_id": product_id, "date": newstart_date, "quantity": quantity, 'product_name': product_name, 'machine_id': machine_id, 'machine_name': machine_name },
    });

}


function clearCalander() {
    // alert();
    $('#calendar-demo').fullCalendar('removeEvents');
    events = [];
}


function createCalendar() {
    $('#calendar-demo').fullCalendar('removeEvents');
    $('#calendar-demo').fullCalendar('addEventSource', events);

}
