var daily_production_id = undefined;
$(document).ready(function () {
    $('input[name="date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    $('input[name="date"]').on('apply.daterangepicker', function (ev, picker) {

        manufacturingOrderNumber()
        product($('#cmbProduct').val());
        machine($('#cmbManuFacturingOrderNo').val());
        getShift($('#cmbMachine').val(), $('#txtDate').val());

    });


    productionSupervisor();
    manufacturingOrderNumber();


    $('#cmbManuFacturingOrderNo').on('change', function () {
        product($(this).val());
        machine($(this).val());
        getShift($('#cmbMachine').val(), $('#txtDate').val());
    });





    $('#btnAction').on('click', function () {
        if ($('#txtDate').val() == '') {
            showWarningMessage('Please select date...!')
            return;
        }
        if ($('#txtSupervisor').attr("data-id") == '' || $('#txtSupervisor').val() == '') {
            showWarningMessage('Please select supervisor')
            return;
        }
        if ($('#txtProduct').attr("data-id") == '' || $('#txtProduct').val() == '') {
            showWarningMessage('Please select product')
            return;
        }
        if ($('#cmbManuFacturingOrderNo').val() == null) {
            showWarningMessage('Please select manufacturing order number')
            return;
        }
        if ($('#cmbProduct').val() == null) {
            showWarningMessage('Please select product')
            return;
        }
        if ($('#cmbMachine').val() == null) {
            showWarningMessage('Please select machine')
            return;
        }
        if ($('#cmbShift').val() == null) {
            showWarningMessage('Please select shift')
            return;
        }
        if ($('#txtRefferanceNo').val() == '') {
            showWarningMessage('Please enter refferance number..!')
            return;
        }
        if ($('#txtDayQuantity').val() == '') {
            showWarningMessage('Please enter day quantity..!')
            return;
        }
        if ($('#txtNightQuantity').val() == '') {
            showWarningMessage('Please enter night quantity..!')
            return;
        }
        if ($(this).text() == 'Save') {
            save();
        } else if ($(this).text() == 'Update') {
            update();
        }
    });







   /* if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        daily_production_id = param[0].split('=')[1].split('&')[0];
        action = param[0].split('=')[2].split('&')[0];

        getDailyProduction(daily_production_id);
        if (action == 'edit') {
            $('#btnAction').text('Update');
        } else if (action == 'view') {
            $('#btnAction').hide();
        }

    } else {
        $('#btnAction').text('Save');
    }*/


    $('#cmbMachine').on('change', function () {
        getShift($(this).val(), $('#txtDate').val());
    });


});




function productionSupervisor() {
    $.ajax({
        type: "GET",
        url: "/pd/DailyProductionController/productionSupervisor",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(response);
            $('#txtSupervisor').setData(res);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function manufacturingOrderNumber() {
    $.ajax({
        type: "GET",
        url: "/pd/DailyProductionController/manufacturingOrderNumber/" + $('#txtDate').val(),
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            if (response.data.success) {

                var html = '<option selected="true" disabled>-- Select Here --</option>';
                $.each(response.data.result, function (index, value) {
                    var manufacturing_order = value.manufacturing_order_number+"-"+value.product_name;
                    html += '<option value="' + value.customer_order_plan_data_id + '">' + manufacturing_order + '</option>';
                });
                $('#cmbManuFacturingOrderNo').html(html);
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function product(id) {
    $.ajax({
        type: "GET",
        url: "/pd/DailyProductionController/product/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(response);
            var html = '';
            $.each(response.data.result, function (index, value) {
                html += '<option value="' + value.id + '">' + value.value + '</option>';
            });
            $('#cmbProduct').html(html);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function machine(id) {
    $.ajax({
        type: 'GET',
        url: '/pd/DailyProductionController/machine/' + id + "/" + $('#txtDate').val(),
        async: false,
        success: function (response) {
            console.log(response.data.result)
            if (response.data.success) {

                var html = '';
                $.each(response.data.result, function (index, value) {
                    var machine = value.machinery_no + "-" + value.machinery_name;
                    html += '<option value="' + value.machinery_id + '">' + machine + '</option>';
                });
                $('#cmbMachine').html(html);


            }
        }, error: function (data) {
            console.log('something went wrong');
        }
    });
}



function save() {

    var date = $('#txtDate').val();
    var supervisor = $('#txtSupervisor').optionID();
    var product_id = $('#cmbProduct').val();
    var manufacturing_order_no = $('#cmbManuFacturingOrderNo').val();
    var machine_id = $('#cmbMachine').val();
    var refferance_no = $('#txtRefferanceNo').val();
    var hour = $('#cmbHour').val();
    var quantity = $('#txtQuantity').val();
    var remark = $('#txtRemark').val();
    var shift = $('#cmbShift').val();


    $.ajax({
        type: "POST",
        url: '/pd/DailyProductionController/save',
        data: {
            "date": date,
            "supervisor": supervisor,
            "manufacturing_order_no": manufacturing_order_no,
            "product_id": product_id,
            "machine_id": machine_id,
            "refferance_no": refferance_no,
            "hour": hour,
            "quantity": quantity,
            "remark": remark,
            "shift": shift,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Daily Production Plan has been save success..!');

                $('#txtDate').val('');
                $('#txtSupervisor').attr("data-id", '');
                $('#txtSupervisor').val('');
                $('#cmbManuFacturingOrderNo').empty('');
                $('#cmbProduct').empty('');
                $('#cmbMachine').empty();
                $('#cmbShift').empty();
                $('#txtRefferanceNo').val('');
                $('#txtHour').val(0);
                $('#txtQuantity').val(0);
                $('#txtRemark').val('');
                allDailyProduction();

            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}





function getDailyProduction(id) {
    $.ajax({
        type: "GET",
        url: "/pd/DailyProductionController/getDailyProduction/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            $('#txtDate').val(res.date);
            manufacturingOrderNumber();
            $('#txtSupervisor').attr("data-id", res.employee_id);
            $('#txtSupervisor').val(res.supervisor);
            setSelectedOption("cmbManuFacturingOrderNo", res.customer_order_plan_data_id);
            $('#cmbManuFacturingOrderNo').trigger('change');
            setSelectedOption("cmbMachine", res.machinery_id);
            $('#txtRefferanceNo').val(res.refno);
            setSelectedOption("cmbHour", res.hour);
            $('#txtQuantity').val(res.quantity);
            $('#txtRemark').val(res.remark);
            setSelectedOption("cmbProduct", res.product_primary_id);
            setSelectedOption("cmbShift", res.shift_id);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function update() {

    var date = $('#txtDate').val();
    var supervisor = $('#txtSupervisor').optionID();
    var product_id = $('#cmbProduct').val();
    var manufacturing_order_no = $('#cmbManuFacturingOrderNo').val();
    var machine_id = $('#cmbMachine').val();
    var refferance_no = $('#txtRefferanceNo').val();
    var hour = $('#cmbHour').val();
    var quantity = $('#txtQuantity').val();
    var remark = $('#txtRemark').val();
    var shift = $('#cmbShift').val();


    $.ajax({
        type: "POST",
        url: '/pd/DailyProductionController/update/' + daily_production_id,
        data: {
            "date": date,
            "supervisor": supervisor,
            "manufacturing_order_no": manufacturing_order_no,
            "product_id": product_id,
            "machine_id": machine_id,
            "refferance_no": refferance_no,
            "hour": hour,
            "quantity": quantity,
            "remark": remark,
            "shift": shift,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Daily Production Plan has been updated success..!');
                $('#txtDate').val('');
                $('#txtSupervisor').attr("data-id", '');
                $('#txtSupervisor').val('');
                $('#cmbManuFacturingOrderNo').empty('');
                $('#cmbProduct').empty('');
                $('#cmbMachine').empty();
                $('#cmbShift').empty();
                $('#txtRefferanceNo').val('');
                $('#txtHour').val(0);
                $('#txtQuantity').val(0);
                $('#txtRemark').val('');
                allDailyProduction();

            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}




function getShift(id, date) {
    $.ajax({
        type: "GET",
        url: "/pd/DailyProductionController/getShift/" + id + "/" + date,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            if (response.data.success) {

                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.shift_id + '">' + value.shift_name + '</option>';
                });
                $('#cmbShift').html(html);


            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}