
var setting_array = {
    "site": null,
    "year": null,
    "month": null
};

var REPORT_ID = 1;


$(document).ready(function () {
    sites();
    showDate('YEAR_MONTH');
    $('#selcSite').prop("disabled", true);

    $('#checkSiteSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcSite').prop("disabled", false);
            setting_array.site = $('#selcSite').val();
        } else {
            $('#selcSite').prop("disabled", true);
            setting_array.site = null;
        }
        //switch_settings('checkSiteSearch');
    });
    $('#selcSite').on('change', function () {
        setting_array.site = $(this).val();
    });

    $('#cmbYear').on('change', function () {
        setting_array.year = $(this).val();
    });

    $('#cmbMonth').on('change', function () {
        setting_array.month = $(this).val();
    });



    var max_year = (parseInt(serverDate().split('/')[0]) + 1);
    var min_year = (max_year - 5);
    for (var i = min_year; i <= max_year; i++) {

        $('#cmbYear').append('<option value="' + i + '">' + i + '</option>');
    }

    setSelectedOption('cmbYear',(max_year-1));
    setSelectedOption('cmbMonth',serverDate().split('/')[1]);
    setting_array.year = $('#cmbYear').val();
    setting_array.month = $('#cmbMonth').val();



    /*$('input[name="startDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    $('input[name="startDate"]').on('apply.daterangepicker', function (ev, picker) {
        setDateRangeToDatePicker('endDate', picker.startDate.format('YYYY MM D'));

    });

    $('input[name="endDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    setDateRangeToDatePicker('endDate', $('input[name="startDate"]').val());


   $('#cmbReport').change(function () {
        REPORT_ID = $(this).val();
        if (REPORT_ID == 1) {
            showDate('YEAR_MONTH');
        } else if (REPORT_ID == 2) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 3) {
            showDate('YEAR_MONTH');
        } else if (REPORT_ID == 4) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 5) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 6) {
            showDate('DATE_RANGE');
        } else if (REPORT_ID == 7) {
            showDate('DATE_RANGE');
        } else if (REPORT_ID == 8) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 11) {
            showDate('SINGLE_DATE');
            $('#lblEmployee').text('Supervisor');
        } else {
            showDate('DATE_RANGE');
        }
    });*/
});


function showDate(args) {

    if (args == 'YEAR_MONTH') {
        $('#divDate1').hide();
        $('#divDate2').show();
    } else {
        $('#divDate1').show();
        $('#divDate2').hide();
    }

    if (args == 'SINGLE_DATE') {
        $('#endDate').hide();
    } else {
        $('#endDate').show();
    }


}


function sites() {
    $.ajax({
        type: 'GET',
        url: '/pd/DailyProductionReportController/sites',
        async: false,
        success: function (response) {
            console.log(response.data.result);
            $('#selcSite').empty();
            if (response.data.success) {

                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.site_id + '">' + value.site + '</option>';
                })
                $('#selcSite').html(html);
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}






function settings() {

    return "site=" + setting_array.site + "&"
        + "year=" + setting_array.year + "&"
        + "month=" + setting_array.month;
}


function createReport(flag) {



    if (REPORT_ID == 0) {
        showWarningMessage("Please select Report");
        return;
    }


    if (REPORT_ID == 1) {

        // showDailyProductionReport('','PRINT');
        $.ajax({
            type: "GET",
            url: "/pd/DailyProductionReportController/dailyProductionReport/" + JSON.stringify(setting_array),
            //url: "/pd/DailyProductionReportController/dailyProductionReport",
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                showDailyProductionReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    }

}




function showDailyProductionReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo Lanka Pvt Ltd', fontSize: 12, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 0, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Daily Production Report (' + $('#cmbMonth option:selected').text() + " " + $('#cmbYear').val() + ")", fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var cell_width = 13;
    var Body = [
        {
            table: {
                widths: [30, 20, 20, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width, cell_width],
                headerRows: 1,
                body: dailyProductionReportBody(result),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function dailyProductionReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: '', fontSize: 6, bold: true, alignment: 'center', border: [false, false, false, false] },
    { text: '', fontSize: 6, bold: true, alignment: 'center', border: [false, false, false, false] },
    { text: '', fontSize: 6, bold: true, alignment: 'center', border: [false, false, false, false] },
    { text: '01', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '02', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '03', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '04', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '05', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '06', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '07', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '08', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '09', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '10', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '11', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '12', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '13', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '14', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '15', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '16', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '17', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '18', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '19', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '20', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '21', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '22', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '23', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '24', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '25', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '26', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '27', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '28', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '29', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '30', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '31', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);


    for (var i = 0; i < result.length; i++) {

        var plan = result[i].plan;
        var actual = result[i].actual;
       


        body.push([{ text: result[i].name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true], rowSpan: 2 },
        { text: result[i].order_no, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true], rowSpan: 2 },
        { text: 'Plan', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['01'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['02'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['03'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['04'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['05'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['06'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['07'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['08'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['09'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['10'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['11'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['12'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['13'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['14'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['15'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['16'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['17'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['18'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['19'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['20'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['21'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['22'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['23'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['24'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['25'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['26'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['27'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['28'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['29'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['30'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: plan['31'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] }]);


        body.push([{ text: result[i].name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true], rowSpan: 2 },
        { text: result[i].order_no, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true], rowSpan: 2 },
        { text: 'Actual', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['01'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['02'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['03'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['04'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['05'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['06'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['07'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['08'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['09'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['10'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['11'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['12'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['13'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['14'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['15'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['16'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['17'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['18'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['19'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['20'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['21'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['22'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['23'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['24'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['25'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['26'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['27'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['28'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['29'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['30'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: actual['31'], fontSize: 5, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }
    return body;
}


function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}



function _export() {
    createReport('EXPORT');
}


/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}