var BOM_HEADER_QTY = 0;
var PRODUCTION_QTY = 0;
function showMaterialEditModal(customer_order_plan_data_id, product_primary_id) {
    FG_PRODUCT_ID = product_primary_id;
    clearAllocatedBOMTable();
    CUSTOMER_ORDER_PLAN_DATA_ID = customer_order_plan_data_id;
    showAllocateMaterialModal(customer_order_plan_data_id, product_primary_id);


}


function clearAllocatedBOMTable() {
    $('#tblAllocateBOMEdit').empty();
    addBOMRow(0);
}


function showAllocateMaterialModal(customer_order_plan_data_id, product_primary_id) {

    getSelectedProductMaterialData(customer_order_plan_data_id, product_primary_id);
    $('#allocateBOMModal').modal('show');
}



function addBOMRow(id) {
    $('#' + id).text("Remove");
    $('#' + id).attr('class', 'btn btn-danger remove');
    $('#' + id).attr('onclick', '');

    var btn_id = "BOM" + guidGenerator();
    var txtBOMMat_id = "txtBOMMaterial" + guidGenerator();
    var txtBOMQty_id = "txtBOMQty" + guidGenerator();
    var cmbBOMUOM_id = "txtBOMUom" + guidGenerator();
    var txtBOMTolerance_id = "txtBOMtolerance" + guidGenerator();


    var string_id = "'" + btn_id + "'";
    var string_txtBOMMat_id = "'" + txtBOMMat_id + "'";


    var text = document.createElement("INPUT");
    text.setAttribute("class", "form-control auto-complete");
    text.setAttribute("type", "text");
    text.setAttribute("id", txtBOMMat_id);
    text.setAttribute("data-id", null);
    text.setAttribute("oninput", "showRawMaterialChooser(" + string_txtBOMMat_id + ")");

    var row = '<tr id="' + id + '"><td id="td' + id + '"></td>';
    row += '<td><input id="' + txtBOMQty_id + '" type="text" class="form-control-sm" style="width:80px; border:1px solid gray;background:white;text-align:right;" autocomplete="off"></td>';
    //row += '<td><input id="' + txtBOMUOM_id + '" type="text" class="form-control-sm" style="width:50px; border:1px solid gray;" autocomplete="off"></td>';
    row += '<td><select id="' + cmbBOMUOM_id + '" class="form-control-sm" style="width:100px; border:1px solid gray;" ><option value="1">Unspecified</option><option value="2">Nos</option><option value="3">Each</option><option value="4">Kgs</option><option value="5">Ltrs</option><option value="6">Meters</option></select></td>';
    row += '<td><input id="' + txtBOMTolerance_id + '" type="text" class="form-control-sm" style="width:100px;text-align:right; border:1px solid gray;background:white;"  autocomplete="off"></td>';
    row += '<td><button type="button" id="' + btn_id + '" class="btn btn-primary" onclick="addBOMRow(' + string_id + ')">Add</button></td></tr>';
    $('#tblAllocateBOMEdit').append(row);

    $(".remove").click(function () {
        $(this).closest("tr").remove();
    });

    $("#td" + id).append(text);

    var comp = {
        "btn_id": btn_id,
        "material": $('#' + txtBOMMat_id),
        "quantity": $('#' + txtBOMQty_id),
        "uom": $('#' + cmbBOMUOM_id),
        "tolerance": $('#' + txtBOMTolerance_id),

    };
    return comp;

}



function guidGenerator() {
    var S4 = function () {
        return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
    };
    return (S4() + S4());
}




function getSelectedProductMaterialData(customer_order_plan_data_id, product_primary_id) {

    $.ajax({
        type: 'GET',
        url: '/pd/ProductionScheduleCreateController/getSelectedProductDataToMaterial/' + customer_order_plan_data_id + "/" + product_primary_id,
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {
                $('#lblBOMProductCodeEdit').text(": " + response.data.result.product_code);
                $('#lblBOMProductNameEdit').text(": " + response.data.result.product_name);
                $('#lblBOMFactoryPOEdit').text(": " + response.data.result.factory_po);
                $('#lblBOMCustomerPOEdit').text(": " + response.data.result.customer_po);
                PRODUCTION_QTY = response.data.result.quantity;
                $('#lblBOMProductionQtyEdit').text(": " + response.data.result.quantity);
                $('#lblBOMAllocateQtyEdit').text(": " + response.data.result.allocated_quantity);
                BOM_HEADER_QTY = parseFloat(response.data.result.bom_header_quantity);
                getSavedAllocatedBOMData();
            }

        },
        error: function (data) {
            console.log(data);
            showErrorMessage();
        },
        complete: function () {

        }
    });
}


function showRawMaterialChooser(id) {
    productChooser.showChooser($('#' + id));
}



function getQuantity(qty) {

    var quantity = 0;
    quantity = (parseFloat(qty).toFixed(2) / BOM_HEADER_QTY);
    quantity = quantity * parseFloat(PRODUCTION_QTY).toFixed(2);
    return parseFloat(quantity).toFixed(2);
}



function allRawMaterialProducts() {
    var product_data = [];
    $.ajax({
        type: "GET",
        url: "/pd/ProductionScheduleCreateController/allRawMaterialProducts",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            product_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return product_data;
}




function getSavedAllocatedBOMData() {

    $.ajax({
        type: 'GET',
        url: "/pd/ProductionScheduleListController/getSavedAllocatedBOMData/" + CUSTOMER_ORDER_PLAN_DATA_ID + "/" + FG_PRODUCT_ID,
        async: false,
        beforeSend: function () {
            //progress(true);
        },
        success: function (response) {
            console.log(response.data.result);
            var result = response.data.result;
            if (result.length > 0) {
                var childarray = { "btn_id": 0 };
                $('#tblAllocateBOMEdit').empty();
                for (var i = 0; i < result.length; i++) {

                    childarray = addBOMRow(childarray.btn_id);
                    childarray.material.val(result[i].product_name);
                    childarray.material.attr('data-id', result[i].product_primary_id);
                    childarray.material.attr('readonly', true);
                    childarray.material.css('border', "0px");
                    childarray.material.css('background', "transparent");
                    childarray.quantity.val(parseFloat(result[i].quantity).toFixed(2));
                    childarray.quantity.css('background', "white");
                    childarray.uom.val(result[i].uom);
                    childarray.tolerance.val(result[i].tolerance);
                    childarray.tolerance.css('background', "white");


                }
                addBOMRow(childarray.btn_id);

            }

        },
        error: function (data) {

        },
        complete: function () {
            //progress(false);
        }
    });

}





function saveScheduleToBOM() {

    $.ajax({
        type: "POST",
        url: '/pd/ProductionScheduleListController/saveScheduleToBOM',
        data: {
            "customer_order_plan_data_id": CUSTOMER_ORDER_PLAN_DATA_ID,
            "fg_product_primary_id": FG_PRODUCT_ID,
            'data': dataSourceBOM(),
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Data has been saved successful');
                clearAllocatedBOMTable();
                $('#allocateBOMModal').modal('hide');
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
            $('#allocateBOMModal').modal('hide');
        }

    });
}



function dataSourceBOM() {

   
    var collection = {};
    var table = document.getElementById('tblAllocateBOMEdit'),
        rows = table.getElementsByTagName('tr'),
        i, j, cells, customerId;

    for (i = 0, j = rows.length; i < j; ++i) {
        cells = rows[i].getElementsByTagName('td');
        if (!cells.length) {
            continue;
        }
        var rm_product_id = $('#' + cells[0].childNodes[0].id).attr("data-id");
        var data = {
            "rm_product_id": rm_product_id,
            "quantity": cells[1].childNodes[0].value,
            "uom": cells[2].childNodes[0].value,
            "tolerance": cells[3].childNodes[0].value,
        };
        collection[i] = JSON.stringify(data);

        console.log(data);



    }
    console.log(collection);
    return collection;

};




