

var start = moment().startOf('month');
var end = moment().endOf('month');
var setting_array = {
    "order": null,
    "machine": null,
    "product": null,
};
var showGanttData = false;
$(document).ready(function () {
    loadProduct();
    loadMachine();
    loadOrder();

    $('#cmbOrder').prop("disabled", true);
    $('#cmbProduct').prop("disabled", true);
    //$('#cmbMachine').prop("disabled", true);
    $('#checkMachineSearch').prop("checked", true);

    $('#btnSearch').on('click', function () {
        var modal = document.getElementById("searchModal");
        modal.style.display = "block";

        var span = document.getElementsByClassName("closeModal")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }
    });




    $('#checkOrderSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#cmbOrder').prop("disabled", false);
            setting_array.order = $('#cmbOrder').val();
        } else {
            $('#cmbOrder').prop("disabled", true);
            setting_array.order = null;
        }
        //switch_settings('checkSiteSearch');
    });

    $('#checkProductSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#cmbProduct').prop("disabled", false);
            setting_array.product = $('#cmbProduct').val();
        } else {
            $('#cmbProduct').prop("disabled", true);
            setting_array.product = null;
        }
        //switch_settings('checkSiteSearch');
    });

    $('#checkMachineSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#cmbMachine').prop("disabled", false);
            setting_array.machine = $('#cmbMachine').val();
        } else {
            $('#cmbMachine').prop("disabled", true);
            //setting_array.machine = null;
        }
        //switch_settings('checkSiteSearch');
    });

    $('#cmbOrder').change(function () {
        setting_array.order = $(this).val();
    });

    $('#cmbProduct').change(function () {
        setting_array.product = $(this).val();
    });

    $('#cmbMachine').change(function () {
        setting_array.machine = $(this).val();
    });



    $('#btnModalSearch').on('click', function () {


        searchGanttChart();

        var modal = document.getElementById("searchModal");
        modal.style.display = "none";

    });



    $('#dashboard-daterangepicker').daterangepicker({
        startDate: start,
        endDate: end,
        opens: 'right',
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    });

    $('#dashboard-daterangepicker span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));



    $('#dashboard-daterangepicker').on('apply.daterangepicker', function (ev, picker) {
        $('#dashboard-daterangepicker span').html(picker.startDate.format('MMMM D, YYYY') + ' - ' + picker.endDate.format('MMMM D, YYYY'));
        createGanttChart();
    });

    createGanttChart();


    $('#btnRefresh').on('click', function () {
        createGanttChart();
    });

});
$(function () {


    // $("#ganttChart").ganttView("setSlideWidth", 600);
});




function createGanttChart() {
    var startDate = $('#dashboard-daterangepicker').data('daterangepicker').startDate.format('YYYY-MM-DD');
    var endDate = $('#dashboard-daterangepicker').data('daterangepicker').endDate.format('YYYY-MM-DD');


    $.ajax({
        type: "GET",
        url: "/pd/ProductionScheduleGanttChartController/createGantChart/" + startDate + "/" + endDate,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response.data.result);
            var ganttData = [];
            ganttData = response.data.result;



            $('#ganttChart').empty();
            $("#ganttChart").ganttView({
                data: ganttData,
                slideWidth: 900,
                behavior: {

                    onClick: function (data) {
                        console.log(data);
                        if (!showGanttData) {
                            //var start_date = new Date(data.start).toISOString().split('T')[0];
                            //var end_date = new Date(data.end).toISOString().split('T')[0];

                            ganttChartModalData(data.customer_order_plan_data_id, data.machine_id, startDate, endDate);


                            showGanttData = true;
                        }
                    },
                    onResize: function (data) {
                        var msg = "You resized an event: { start: " + data.start.toString("M/d/yyyy") + ", end: " + data.end.toString("M/d/yyyy") + " }";
                        $("#eventMessage").text(msg);
                    },
                    onDrag: function (data) {
                        var msg = "You dragged an event: { start: " + data.start.toString("M/d/yyyy") + ", end: " + data.end.toString("M/d/yyyy") + " }";
                        $("#eventMessage").text(msg);
                    }
                }
            });
        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();

        },
        complete: function () {

        }

    });




}



function searchGanttChart() {
    var startDate = $('#dashboard-daterangepicker').data('daterangepicker').startDate.format('YYYY-MM-DD');
    var endDate = $('#dashboard-daterangepicker').data('daterangepicker').endDate.format('YYYY-MM-DD');
    setting_array.machine = $('#cmbMachine').val();

    $.ajax({
        type: "GET",
        url: "/pd/ProductionScheduleGanttChartController/searchGantChart/" + JSON.stringify(setting_array) + "/" + startDate + "/" + endDate,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response.data.result);
            var ganttData = [];
            ganttData = response.data.result;


            $('#ganttChart').empty();
            $("#ganttChart").ganttView({
                data: ganttData,
                slideWidth: 900,
                behavior: {

                    onClick: function (data) {
                        console.log(data);
                        if (!showGanttData) {
                            //var start_date = new Date(data.start).toISOString().split('T')[0];
                            //var end_date = new Date(data.end).toISOString().split('T')[0];

                            ganttChartModalData(data.customer_order_plan_data_id, data.machine_id, startDate, endDate);


                            showGanttData = true;
                        }
                    },
                }
            });


        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();

        },
        complete: function () {

        }

    });




}


function ganttChartModalData(customer_order_id, machine_id, start_date, end_date) {

    $.ajax({
        type: "GET",
        url: "/pd/ProductionScheduleGanttChartController/ganttChartModalData/" + customer_order_id + "/" + machine_id + "/" + start_date + "/" + end_date,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                $('#ganttModalTableBody').empty();

                for (var i = 0; i < response.data.result.length; i++) {
                    $('#modal_title').html(response.data.result[i]['machinery_no'] + " - " + response.data.result[i]['machinery_name']);
                    var row = '<tr class="gantt_tr">';
                    row += '<td class="gantt_td">' + response.data.result[i]['date'] + '</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['manufacturing_order_no'] + '</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['purchase_order'] + '</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['product_name'] + '</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['shift_name'] + '</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['quantity'] + '</td>';
                    row += '</tr>';
                    $('#ganttModalTableBody').append(row);
                }

            }


        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            var modal = document.getElementById("myModal");
            modal.style.display = "block";

            var span = document.getElementsByClassName("close")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";
                showGanttData = false;
            }
        }

    });



}


function ganttNightPlan(machine_id, start_date, end_date) {

    $.ajax({
        type: "GET",
        url: "/pd/ProductionScheduleGanttChartController/ganttNightPlan/" + machine_id + "/" + start_date + "/" + end_date,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                $('#ganttModalTableBody').empty();
                for (var i = 0; i < response.data.result.length; i++) {
                    var row = '<tr class="gantt_tr">';
                    row += '<td class="gantt_td">' + response.data.result[i]['date'] + '</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['manufacturing_order_no'] + '</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['purchase_order'] + '</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['product_name'] + '</td>';
                    row += '<td class="gantt_td">0</td>';
                    row += '<td class="gantt_td">0</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['night_quantity'] + '</td>';
                    row += '<td class="gantt_td">0</td>';
                    row += '</tr>';
                    $('#ganttModalTableBody').append(row);
                }

            }

            var modal = document.getElementById("myModal");
            modal.style.display = "block";

            var span = document.getElementsByClassName("close")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";
                showGanttData = false;
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}


function ganttDayActual(machine_id, start_date, end_date) {

    $.ajax({
        type: "GET",
        url: "/pd/ProductionScheduleGanttChartController/ganttDayActual/" + machine_id + "/" + start_date + "/" + end_date,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                $('#ganttModalTableBody').empty();
                for (var i = 0; i < response.data.result.length; i++) {
                    var row = '<tr class="gantt_tr">';
                    row += '<td class="gantt_td">' + response.data.result[i]['date'] + '</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['manufacturing_order_no'] + '</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['purchase_order'] + '</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['product_name'] + '</td>';
                    row += '<td class="gantt_td">0</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['day_quantity'] + '</td>';
                    row += '<td class="gantt_td">0</td>';
                    row += '<td class="gantt_td">0</td>';
                    row += '</tr>';
                    $('#ganttModalTableBody').append(row);
                }

            }

            var modal = document.getElementById("myModal");
            modal.style.display = "block";

            var span = document.getElementsByClassName("close")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";
                showGanttData = false;
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}


function ganttNightActual(machine_id, start_date, end_date) {

    $.ajax({
        type: "GET",
        url: "/pd/ProductionScheduleGanttChartController/ganttNightActual/" + machine_id + "/" + start_date + "/" + end_date,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                $('#ganttModalTableBody').empty();
                for (var i = 0; i < response.data.result.length; i++) {
                    var row = '<tr class="gantt_tr">';
                    row += '<td class="gantt_td">' + response.data.result[i]['date'] + '</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['manufacturing_order_no'] + '</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['purchase_order'] + '</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['product_name'] + '</td>';
                    row += '<td class="gantt_td">0</td>';
                    row += '<td class="gantt_td">0</td>';
                    row += '<td class="gantt_td">0</td>';
                    row += '<td class="gantt_td">' + response.data.result[i]['night_quantity'] + '</td>';
                    row += '</tr>';
                    $('#ganttModalTableBody').append(row);
                }

            }

            var modal = document.getElementById("myModal");
            modal.style.display = "block";

            var span = document.getElementsByClassName("close")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";
                showGanttData = false;
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}




function loadProduct() {
    $.ajax({
        type: 'GET',
        url: '/pd/ProductionScheduleGanttChartController/loadProducts',
        success: function (response) {
            console.log(response);
            $('#cmbProduct').empty();
            $.each(response.data.result, function (index, value) {
                $('#cmbProduct').append('<option value="' + value.product_primary_id + '" > ' + value.product_name + ' </option>');
            });

        }, error: function (data) {
            // console.log('something went wrong');
        }
    });
}



function loadOrder() {
    $.ajax({
        type: 'GET',
        url: '/pd/ProductionScheduleGanttChartController/loadOrder',
        success: function (response) {
            console.log(response);
            $('#cmbOrder').empty();
            $.each(response.data.result, function (index, value) {
                $('#cmbOrder').append('<option value="' + value.customer_order_plan_data_id + '" > ' + value.manufacturing_order_no + ' </option>');
            });

        }, error: function (data) {
            // console.log('something went wrong');
        }
    });
}



function loadMachine() {
    $.ajax({
        type: 'GET',
        url: '/pd/ProductionScheduleGanttChartController/loadMachine',
        success: function (response) {
            console.log(response);
            $('#cmbMachine').empty();
            $.each(response.data.result, function (index, value) {
                $('#cmbMachine').append('<option value="' + value.machinery_id + '" > ' + value.machinery_no + ' </option>');
            });

        }, error: function (data) {
            // console.log('something went wrong');
        }
    });
}