
var action = "save";
var tableData = undefined;
var tableEmployee = undefined;
var PALLET_ID = undefined;
const TOKEN = Math.floor(Math.random() * 212345);
var products = [];
$(document).ready(function () {
    $('.status_btn').hide();
    $('#txtPalletNo').val(getPalletNo());
    allFactories();
    allOrders();
    products = ongoingProducts($('#cmbOrder').val());

    $('#tblPalletAttachment').DataTable({
        responsive: true,
        "order": [],
        "columns": [
            { "data": "file" },
            { "data": "view" },
            { "data": "download" },
            { "data": "delete" },
        ],
        columnDefs: [
            { width: 80, targets: 1 },
            { width: 80, targets: 2 },
            { width: 80, targets: 3 },
        ],
    });



    $('#btnAttachment').on('click', function () {
        Dropzone.forElement('#myDropzone').removeAllFiles(true);
        $('#myDropzone').trigger('reset');
        var table = $('#tblPalletAttachment').DataTable();
        table.clear();
        $('#attachmentAddModal').modal('toggle');
        //showWarningMessage('Please save purchase order to before upload attachmnet...!');
    });

    //Employee chooser
    var employeeChooser = $('#employeeChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 300, targets: 1 },
        ],
    });

    var employee_data = allEmployees();
    console.log(employee_data);
    employeeChooser.setDataSource(employee_data);


    employeeChooser.on('select', function (event, data) {
        $('#txtSupplier').val(data[1]);
        $('#txtSupplier').attr("data-id", data[0]);
        var input = employeeChooser.getInput();
        input.focus();
    });
    //End OF Employee chooser


    //Supervisor chooser
    var supervisorChooser = $('#supervisorChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 300, targets: 1 },
        ],
    });

    var employee_data = allEmployees();
    console.log(employee_data);
    supervisorChooser.setDataSource(employee_data);


    supervisorChooser.on('select', function (event, data) {
        $('#txtSupervisor').val(data[1]);
        $('#txtSupervisor').attr("data-id", data[0]);
        var input = supervisorChooser.getInput();
        input.focus();
    });
    //End OF Supervisor chooser

    $('#txtSupervisor').on('input',function(){
        supervisorChooser.showChooser($(this));

    });


    $('#attachmnet_token').val(TOKEN);


    tableData = $('#tblData').transactionTable({
        thead: ['id', 'Layer', 'Qty', 'Product', 'Comments', 'Remove'],
        data_chooser: [{ 'col': 2 }],
        chooser: null,
        column_def: { 1: 100 },
        auto_focus: 2,
        row_type: [
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '10%' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'select', 'value': products, 'align': 'left', 'width': '350px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '100%' },
            { 'type': 'remove', 'value': 'X', 'align': 'center', 'width': '50px' }],
    });


    tableEmployee = $('#tblEmployee').transactionTable({
        thead: ['employee_id', 'Palletizing Assistant', 'Remove'],
        data_chooser: [{ 'col': 1 }],
        chooser: employeeChooser,
        column_def: { 1: 100 },
        auto_focus: 1,
        row_type: [
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '10%' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '100%' },
            { 'type': 'remove', 'value': 'X', 'align': 'center', 'width': '50px' }],
    });





    employeeChooser.on('select', function (event, data) {
        var selected_row = tableEmployee.getSelectedRow();
        var cells = selected_row.getElementsByTagName('td');
        cells[0].childNodes[0].value = data[0];
        cells[1].childNodes[0].value = data[1];
        cells[2].childNodes[0].value = data[2];
        var input = employeeChooser.getInput();
        input.focus();
    });




    $('input[name="pallatize_date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });



    $('#btnSave').on('click', function () {


        if ($(this).text() == 'Save') {
            savePallet();
        } else {
            updatePallet();
        }
    });




    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        var id = param[0].split('=')[1].split('&')[0];
        action = param[0].split('=')[2].split('&')[0];
        PALLET_ID = id;
        getPallet(id);
        if (action == 'edit') {
            $('.status_btn').hide();
            $('#btnSave').text('Update');
        } else if (action == 'view') {
            $('.status_btn').show();
            $('#btnSave').hide();
        }

    } else {
        tableData.add_empty_row();
        tableEmployee.add_empty_row();
    }




    $('#btnApprovePallet').on('click', function () {
        change_status_confirmation(PALLET_ID, 1, "Are you sure want to approve?");
    });
    $('#btnRejectPallet').on('click', function () {
        change_status_confirmation(PALLET_ID, 2, "Are you sure want to reject?");
    });


    $('#cmbOrder').on('change', function () {
        products = ongoingProducts($(this).val());
        tableData.clear();
        tableData.add_empty_row();
        var table_childs = tableData.tableChilds();
        $('#' + table_childs[0][3].id).empty();
        for (var i = 0; i < products.length; i++) {
            $('#' + table_childs[0][3].id).append('<option value="' + products[i].value + '">' + products[i].text + '</option>');
        }
    });




});



Dropzone.options.myDropzone = {
    dictDefaultMessage: 'Drop file here or click to upload!!!!!!!!',
    addRemoveLinks: true,
    init: function () {
        this.on("complete", function (file) {
            $('#attachmentAddModal').modal('hide');
            allAttachment(1, TOKEN);
        });
    }
};




function getPalletNo() {
    var pallet_no = undefined;
    $.ajax({
        type: "GET",
        url: "/pd/PallatizingController/getPalletNo",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            if (parseInt(response.result.id) == 0) {
                pallet_no = generateID(1);
            } else {
                pallet_no = generateID(parseInt(response.result.id) + 1);
            }

        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return pallet_no;
}



function allEmployees() {
    var employee_data = [];
    $.ajax({
        type: "GET",
        url: "/pd/PallatizingController/allEmployees",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            employee_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return employee_data;
}





function allFactories() {
    $.ajax({
        type: "GET",
        url: "/pd/PallatizingController/allFactories",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var factories = response.result;
            $('#cmbFactory').empty();
            for (var i = 0; i < factories.length; i++) {
                $('#cmbFactory').append('<option value="' + factories[i].site_id + '">' + factories[i].site + '</option>');
            }
            setSelectedOption('cmbFactory', 2);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}





function allOrders() {
    $.ajax({
        type: "GET",
        url: "/pd/PallatizingController/allOrders",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var orders = response.result;
            $('#cmbOrder').empty();
            for (var i = 0; i < orders.length; i++) {
                var text = orders[i].factory_po_num + ' - ' + orders[i].purchase_order;
                $('#cmbOrder').append('<option value="' + orders[i].order_id + '">' + text + '</option>');
            }

        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function ongoingProducts(order_id) {
    var products = [];
    $.ajax({
        type: "GET",
        url: "/pd/PallatizingController/ongoingProducts/" + order_id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            products = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return products;
}





function savePallet() {

    if ($('#txt_pallatize_date').val().trim() == '') {
        showWarningMessage("Please Select Date");
        return;
    }
    if ($('#txtPalletWeight').val() == '') {
        showWarningMessage("Please Enter Pallet Weight");
        return;
    }
    if ($('#txtPalletLength').val() == '') {
        showWarningMessage("Please Enter Pallet Length");
        return;
    }
    if ($('#txtPalletWidth').val() == '') {
        showWarningMessage("Please Enter Pallet Width");
        return;
    }
    if ($('#txtPalletHeight').val() == '') {
        showWarningMessage("Please Enter Pallet Height");
        return;
    }
    if ($('#txtSupervisor').attr('data-id') == '') {
        showWarningMessage("Please Select Supervisor");
        return;
    }
    var pallet_data = [];
    var pallet_data_arr = tableData.dataSource();
    if (pallet_data_arr.length == 0) {
        showWarningMessage("Invalied Pallatizing Table (Empty Table)");
        return;
    }
    for (var i = 0; i < pallet_data_arr.length; i++) {
        if (!pallet_data_arr[i][2]) {
            showWarningMessage("You shuld fill empty row in The list");
            return;
        }
        pallet_data.push(JSON.stringify({ "id": pallet_data_arr[i][0], "layer": pallet_data_arr[i][1], "total": pallet_data_arr[i][2], "product": pallet_data_arr[i][3], "comment": pallet_data_arr[i][4] }));
    }




    var employee_data = [];
    var employee_data_arr = tableEmployee.dataSource();
    if (employee_data_arr.length == 0) {
        showWarningMessage("Invalied Employee Table (Empty Table)");
        return;
    }
    for (var i = 0; i < employee_data_arr.length; i++) {
        if (!employee_data_arr[i][0]) {
            showWarningMessage("You shuld fill empty row in The list");
            return;
        }
        employee_data.push(JSON.stringify({ "employee_id": employee_data_arr[i][0] }));
    }


    $.ajax({
        type: "POST",
        url: '/pd/PallatizingController/save',
        async: false,
        data: {
            'pallet_no': $('#txtPalletNo').val(),
            'pallet_date': $('#txt_pallatize_date').val(),
            'pallet_weight': $('#txtPalletWeight').val(),
            'pallet_length': $('#txtPalletLength').val(),
            'pallet_width': $('#txtPalletWidth').val(),
            'pallet_height': $('#txtPalletHeight').val(),
            'factory': $('#cmbFactory').val(),
            'order_id': $('#cmbOrder').val(),
            'supervisor_id':$('#txtSupervisor').attr('data-id'),

            'attachment_token': TOKEN,
            'pallet_data': pallet_data,
            'employee_data': employee_data,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                toastr.success('data saved');
                location.href = '/pd/pallatizing_details';
            } else {
                showErrorMessage();
            }
            //location.reload();

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}



function getPallet(id) {
    $.ajax({
        type: "GET",
        url: "/pd/PallatizingController/getPallet/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            PALLET_ID = res.pallatizing_header_id;
            $('#txtPalletNo').val(res.pallet_no);
            $('#txt_pallatize_date').val(res.pallatize_date);
            $('#txtPalletWeight').val(res.pallet_weight);
            $('#txtPalletLength').val(res.pallet_length);
            $('#txtPalletWidth').val(res.pallet_width);
            $('#txtPalletHeight').val(res.pallet_height);
            $('#txtSupervisor').val(res.supervisor);
            $('#txtSupervisor').attr('data-id',res.supervisor_id);

            setSelectedOption('cmbFactory', res.factory_id);
            setSelectedOption('cmbOrder', res.order_id);
            products = ongoingProducts(res.order_id);


            var pallet_data = res.data;
            for (var i = 0; i < pallet_data.length; i++) {
                tableData.addRow(
                    [
                        { 'type': 'text', 'val': pallet_data[i].pallatizing_data_id, 'align': 'left', 'width': '10%' },
                        { 'type': 'text', 'val': pallet_data[i].layer, 'align': 'left', 'width': '100px' },
                        { 'type': 'text', 'val': pallet_data[i].total, 'align': 'right', 'width': '100px' },
                        { 'type': 'select', 'val': products, 'align': 'left', 'width': '350px' },
                        { 'type': 'text', 'val': pallet_data[i].comment, 'align': 'left', 'width': '100%' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );

                var table_childs = tableData.tableChilds();
                $('#' + table_childs[i][1].id).val(pallet_data[i].layer);
                setSelectedOption(table_childs[i][3].id, pallet_data[i].product_primary_id);
            }



            var pallet_employee = res.employee;
            for (var i = 0; i < pallet_employee.length; i++) {
                tableEmployee.addRow(
                    [
                        { 'type': 'text', 'val': pallet_employee[i].employee_id, 'align': 'left', 'width': '10%' },
                        { 'type': 'text', 'val': pallet_employee[i].name, 'align': 'left', 'width': '100%' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }





            var result = res.attachment;
            var data = [];
            for (var i = 0; i < result.length; i++) {
                var path = "'" + result[i].path + "'";
                var id = "'" + result[i].pallatizing_attachment_id + "'";
                data.push({
                    "file": result[i].path,
                    "view": '<button type= "button" class="btn btn-primary" onclick="viewAttachment(' + path + ');"><i class="fa fa-eye" aria-hidden="true"></i></button> ',
                    "download": '<button type= "button" class="btn btn-success" onclick="downloadAttachment(' + path + ');"><i class="fa fa-download" aria-hidden="true"></i></button> ',
                    "delete": '<button type= "button" class="btn btn-danger" onclick="deleteAttachment(' + id + ');"><i class="fa fa-trash" aria-hidden="true"></i></button> ',
                });
            }
            var table = $('#tblPalletAttachment').DataTable();
            table.clear();
            table.rows.add(data).draw();



        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {
            progress(false);
        }

    });
}






function updatePallet() {

    if ($('#txt_pallatize_date').val().trim() == '') {
        showWarningMessage("Please Select Date");
        return;
    }
    if ($('#txtPalletWeight').val() == '') {
        showWarningMessage("Please Enter Pallet Weight");
        return;
    }
    if ($('#txtPalletLength').val() == '') {
        showWarningMessage("Please Enter Pallet Length");
        return;
    }
    if ($('#txtPalletWidth').val() == '') {
        showWarningMessage("Please Enter Pallet Width");
        return;
    }
    if ($('#txtPalletHeight').val() == '') {
        showWarningMessage("Please Enter Pallet Height");
        return;
    }
    if ($('#txtSupervisor').attr('data-id') == '') {
        showWarningMessage("Please Select Supervisor");
        return;
    }
    var pallet_data = [];
    var pallet_data_arr = tableData.dataSource();
    if (pallet_data_arr.length == 0) {
        showWarningMessage("Invalied Pallatizing Table (Empty Table)");
        return;
    }
    for (var i = 0; i < pallet_data_arr.length; i++) {
        if (!pallet_data_arr[i][2]) {
            showWarningMessage("You shuld fill empty row in The list");
            return;
        }
        pallet_data.push(JSON.stringify({ "id": pallet_data_arr[i][0], "layer": pallet_data_arr[i][1], "total": pallet_data_arr[i][2], "product": pallet_data_arr[i][3], "comment": pallet_data_arr[i][4] }));
    }




    var employee_data = [];
    var employee_data_arr = tableEmployee.dataSource();
    if (employee_data_arr.length == 0) {
        showWarningMessage("Invalied Employee Table (Empty Table)");
        return;
    }
    for (var i = 0; i < employee_data_arr.length; i++) {
        if (!employee_data_arr[i][0]) {
            showWarningMessage("You shuld fill empty row in The list");
            return;
        }
        employee_data.push(JSON.stringify({ "employee_id": employee_data_arr[i][0] }));
    }

    if (PALLET_ID == undefined) {
        showWarningMessage('Grn not selected...!');
        return;
    }


    $.ajax({
        type: "PUT",
        url: '/pd/PallatizingController/update/' + PALLET_ID,
        data: {
            'pallet_no': $('#txtPalletNo').val(),
            'pallet_date': $('#txt_pallatize_date').val(),
            'pallet_weight': $('#txtPalletWeight').val(),
            'pallet_length': $('#txtPalletLength').val(),
            'pallet_width': $('#txtPalletWidth').val(),
            'pallet_height': $('#txtPalletHeight').val(),
            'factory': $('#cmbFactory').val(),
            'order_id': $('#cmbOrder').val(),
            'supervisor_id':$('#txtSupervisor').attr('data-id'),

            'attachment_token': TOKEN,
            'pallet_data': pallet_data,
            'employee_data': employee_data,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            $('#btnSave').html('<i class="fa fa-circle-o-notch fa-spin"></i>');
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                toastr.success('data updated');
                location.href = '/pd/pallatizing_details_list';
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}





function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}


function triggerRowInputs(id, selected_row) {






}




function transactionTableUpdate(table_id) { // override function from transaction_table.js

}




function allAttachment(pallatizing_id, token) {
    $.ajax({
        type: "GET",
        url: "/pd/PallatizingController/allAttachment/" + pallatizing_id + "/" + token,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var result = response.data.result;
                var data = [];
                for (var i = 0; i < result.length; i++) {
                    var path = "'" + result[i].path + "'";
                    var id = "'" + result[i].pallatizing_attachment_id + "'";
                    data.push({
                        "file": result[i].path,
                        "view": '<button type= "button" class="btn btn-primary" onclick="viewAttachment(' + path + ');"><i class="fa fa-eye" aria-hidden="true"></i></button> ',
                        "download": '<button type= "button" class="btn btn-success" onclick="downloadAttachment(' + path + ');"><i class="fa fa-download" aria-hidden="true"></i></button> ',
                        "delete": '<button type= "button" class="btn btn-danger" onclick="deleteAttachment(' + id + ');"><i class="fa fa-trash" aria-hidden="true"></i></button> ',
                    });
                }
                var table = $('#tblPalletAttachment').DataTable();
                //table.clear();
                table.rows.add(data).draw();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);

        },

    });
}


function viewAttachment(file) {
    window.open('/pallet/' + file);

}


function downloadAttachment(file) {
    var link = document.createElement("a");
    link.download = file;
    link.href = "/pallet/" + file;
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
    delete link;
}


function add_row_event(table, data) {

    if (table.ID == 'tblData') {
        var table_childs = table.tableChilds();
        $('#' + table_childs[table_childs.length - 1][1].id).val('Layer' + table_childs.length);

        $('#' + table_childs[table_childs.length - 1][3].id).empty();
        for (var i = 0; i < products.length; i++) {
            $('#' + table_childs[table_childs.length - 1][3].id).append('<option value="' + products[i].value + '">' + products[i].text + '</option>');
        }
    }

}



function deleteAttachment(id) {
    $.ajax({
        type: 'DELETE',
        url: '/pd/PallatizingController/deleteAttachment/' + id,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                showSuccessMessage("Attachment has been deleted successfully...");

                var result = response.data.result;
                var data = [];
                for (var i = 0; i < result.length; i++) {
                    var path = "'" + result[i].path + "'";
                    var id = "'" + result[i].pallatizing_attachment_id + "'";
                    data.push({
                        "file": result[i].path,
                        "view": '<button type= "button" class="btn btn-primary" onclick="viewAttachment(' + path + ');"><i class="fa fa-eye" aria-hidden="true"></i></button> ',
                        "download": '<button type= "button" class="btn btn-success" onclick="downloadAttachment(' + path + ');"><i class="fa fa-download" aria-hidden="true"></i></button> ',
                        "delete": '<button type= "button" class="btn btn-danger" onclick="deleteAttachment(' + id + ');"><i class="fa fa-trash" aria-hidden="true"></i></button> ',
                    });
                }
                var table = $('#tblPalletAttachment').DataTable();
                table.clear();
                table.rows.add(data).draw();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}





function change_status_confirmation(id, status, msg) {
    swal({
        title: msg,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                change_status(id, status);
            }
        });

}

function change_status(id, status) {

    $.ajax({
        type: "PUT",
        url: '/pd/PallatizingController/change_status/' + id,
        data: {
            status: status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            // document.getElementById('btnApproveGrn').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    toastr.success("Pallatizing Details approved.");
                } else if (status == 2) {
                    toastr.success("Pallatizing Details rejected.");
                }

            } else {
                showErrorMessage();
            }
            location.href = '/pd/pallatizing_details_list';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
            // document.getElementById('approve'+id).innerHTML = '<i class="fa fa-times" aria-hidden="true"></i>';
        }

    });
}




/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "0000",
        2: "000",
        3: "00",
        4: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}