
var setting_array = {
    "factory": null,
    "factory_order": null,
    "machine": null,
    "officer": null,
    "product": null,
};

var REPORT_ID = 1;


$(document).ready(function () {
    allSettings();
    showDate('DATE_RANGE');
    $('#selcFactory').prop("disabled", true);

    $('#checkFactorySearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcFactory').prop("disabled", false);
            setting_array.factory = $('#selcFactory').val();
        } else {
            $('#selcFactory').prop("disabled", true);
            setting_array.factory = null;
        }
        //switch_settings('checkSiteSearch');
    });
    $('#selcFactory').on('change', function () {
        setting_array.factory = $(this).val();
    });


    $('#txtFactoryPO').prop("disabled", true);

    $('#checkFactoryOrderSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#txtFactoryPO').prop("disabled", false);
            setting_array.factory_order = $('#txtFactoryPO').attr('data-id');
        } else {
            $('#txtFactoryPO').prop("disabled", true);
            setting_array.factory_order = null;
        }
        //switch_settings('checkSiteSearch');
    });
    $('#txtFactoryPO').on('change', function () {
        setting_array.factory_order = $(this).val();
    });



    $('#selcMachine').prop("disabled", true);

    $('#checkMachineSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcMachine').prop("disabled", false);
            setting_array.machine = $('#selcMachine').val();
        } else {
            $('#selcMachine').prop("disabled", true);
            setting_array.machine = null;
        }
        //switch_settings('checkSiteSearch');
    });
    $('#selcMachine').on('change', function () {
        setting_array.machine = $(this).val();
    });




    $('#selcTechnicalOfficer').prop("disabled", true);

    $('#checkTechnicalOfficerSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcTechnicalOfficer').prop("disabled", false);
            setting_array.officer = $('#selcTechnicalOfficer').val();
        } else {
            $('#selcTechnicalOfficer').prop("disabled", true);
            setting_array.officer = null;
        }
        //switch_settings('checkSiteSearch');
    });
    $('#selcTechnicalOfficer').on('change', function () {
        setting_array.officer = $(this).val();
    });



    $('#selcProduct').prop("disabled", true);

    $('#checkProductSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProduct').prop("disabled", false);
            setting_array.product = $('#selcProduct').val();
        } else {
            $('#selcProduct').prop("disabled", true);
            setting_array.product = null;
        }
        //switch_settings('checkSiteSearch');
    });
    $('#selcProduct').on('change', function () {
        setting_array.product = $(this).val();
    });

    /*$('#cmbYear').on('change', function () {
        setting_array.year = $(this).val();
    });

    $('#cmbMonth').on('change', function () {
        setting_array.month = $(this).val();
    });*/







    $('input[name="startDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    $('input[name="startDate"]').on('apply.daterangepicker', function (ev, picker) {

        setDateRangeToDatePicker('endDate', picker.startDate.format('YYYY-MM-D'));

    });

    $('input[name="endDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    setDateRangeToDatePicker('endDate', $('input[name="startDate"]').val());


    $('#cmbReport').change(function () {
        REPORT_ID = $(this).val();
        if (REPORT_ID == 1) {
            showDate('YEAR_MONTH');
        } else if (REPORT_ID == 2) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 3) {
            showDate('YEAR_MONTH');
        } else if (REPORT_ID == 4) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 5) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 6) {
            showDate('DATE_RANGE');
        } else if (REPORT_ID == 7) {
            showDate('DATE_RANGE');
        } else if (REPORT_ID == 8) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 11) {
            showDate('SINGLE_DATE');
            $('#lblEmployee').text('Supervisor');
        } else {
            showDate('DATE_RANGE');
        }
    });
});


function showDate(args) {

    if (args == 'YEAR_MONTH') {
        $('#divDate1').hide();
        $('#divDate2').show();
    } else {
        $('#divDate1').show();
        $('#divDate2').hide();
    }

    if (args == 'SINGLE_DATE') {
        $('#endDate').hide();
    } else {
        $('#endDate').show();
    }


}


function allSettings() {
    $.ajax({
        type: 'GET',
        url: '/pd/ProductionRecordsReportController/allSettings',
        async: false,
        success: function (response) {
            console.log(response.data.result);
            $('#selcFactory').empty();
            $('#selcMachine').empty();
            $('#selcTechnicalOfficer').empty();
            $('#selcProduct').empty();
            if (response.data.success) {

                var factory_html = '<option value="disabled" disabled="" selected="">Select here</option>';
                $.each(response.data.result.factory, function (index, value) {
                    factory_html += '<option value="' + value.site_id + '">' + value.site + '</option>';
                })
                $('#selcFactory').html(factory_html);


                var machine_html = '<option value="disabled" disabled="" selected="">Select here</option>';
                $.each(response.data.result.machine, function (index, value) {
                    var name = value.machinery_no + "-" + value.machinery_name;
                    machine_html += '<option value="' + value.machinery_id + '">' + name + '</option>';
                })
                $('#selcMachine').html(machine_html);


                var officer_html = '<option value="disabled" disabled="" selected="">Select here</option>';
                $.each(response.data.result.officer, function (index, value) {
                    officer_html += '<option value="' + value.employee_id + '">' + value.name_withinitial + '</option>';
                })
                $('#selcTechnicalOfficer').html(officer_html);


                var product_html = '<option value="disabled" disabled="" selected="">Select here</option>';
                $.each(response.data.result.product, function (index, value) {
                    product_html += '<option value="' + value.product_primary_id + '">' + value.product_name + '</option>';
                })
                $('#selcProduct').html(product_html);

                $('#txtFactoryPO').setData(response.data.result.factory_order);

            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}









function settings() {

    return "factory=" + setting_array.factory + "&"
        + "factory_order=" + setting_array.factory_order + "&"
        + "machine=" + setting_array.machine + "&"
        + "officer=" + setting_array.officer + "&"
        + "product=" + setting_array.product;
}


function createReport(flag) {



    if (REPORT_ID == 0) {
        showWarningMessage("Please select Report");
        return;
    }


    if (REPORT_ID == 1) {

        //showProductionRecordsReport('','PRINT');
        $.ajax({
            type: "GET",
            url: "/pd/ProductionRecordsReportController/productionRecordsReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            //url: "/pd/ProductionRecordsReportController/productionRecordsReport",
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                showProductionRecordsReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    }

}




function showProductionRecordsReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo Lanka Pvt Ltd', fontSize: 12, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 0, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Production Records (From ' + $('#txtDateFrom').val() + " To " + $('#txtDateTo').val() + ")", fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [40, 30, 50, '*', '*', '*', 40, 40, 50, '*'],
                headerRows: 1,
                body: productionRecordsReportBody(result),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function productionRecordsReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Date', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'PO NO.', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Shift', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Factory', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Machine', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Technical Officer', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Time Period', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Target Production', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Actual Production', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Remark', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (var i = 0; i < result.length; i++) {
        body.push([{ text: result[i].date, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].factory_po_num, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].shift_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].site, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].machinery_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].officer, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].time_period, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: parseFloat(result[i].target_production).toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: parseFloat(result[i].actual_production).toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].remark, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }
    return body;
}



function _export() {
    createReport('EXPORT');
}

/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}