var daily_production_id = undefined;
$(document).ready(function () {

    $('input[name="datetimes"]').daterangepicker({
        singleDatePicker: true,
        timePicker: true,
        timePicker24Hour: true,
        startDate: moment().startOf('hour'),
        endDate: moment().startOf('hour').add(32, 'hour'),
        locale: {
            format: 'YYYY-MM-DD H:mm'
        }
    });


    //productionSupervisor();
    allSite();
    allReason();


    $('#cmbSite').on('change', function () {
        machine($(this).val());
    });





    $('#btnAction').on('click', function () {

        if ($('#cmbMachine').val() == null) {
            showWarningMessage('Please select machine')
            return;
        }
        if ($('#txtBreakdownTime').val() == '') {
            showWarningMessage('Please select breakdown time..!')
            return;
        }
        if ($('#txtReasonOfBreakdown').val() == '') {
            showWarningMessage('Please enter note..!')
            return;
        }

        if ($(this).text() == 'Save') {
            save();
        } else if ($(this).text() == 'Update') {
            update();
        }
    });




});




function productionSupervisor() {
    $.ajax({
        type: "GET",
        url: "/pd/ReasonOfBreakdownController/productionSupervisor",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(response);
            $('#txtSupervisor').setData(res);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function allSite() {
    $.ajax({
        type: "GET",
        url: "/pd/ReasonOfBreakdownController/allSite",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var html = '<option selected="true" disabled>-- Select Here --</option>';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.factory_id + '">' + value.name + '</option>';
                });
                $('#cmbSite').html(html);
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}





function product(id) {
    $.ajax({
        type: "GET",
        url: "/pd/ReasonOfBreakdownController/product/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(response);
            var html = '';
            $.each(response.data.result, function (index, value) {
                html += '<option value="' + value.id + '">' + value.value + '</option>';
            });
            $('#cmbProduct').html(html);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function machine(id) {
    $.ajax({
        type: 'GET',
        url: '/pd/ReasonOfBreakdownController/machine/' + id,
        async: false,
        success: function (response) {
            console.log(response.data.result)
            if (response.data.success) {

                var html = '';
                $('#cmbMachine').empty();
                $.each(response.data.result, function (index, value) {
                    var machine = value.machinery_no + "-" + value.machinery_name;
                    html += '<option value="' + value.machinery_id + '">' + machine + '</option>';
                });
                $('#cmbMachine').html(html);


            }
        }, error: function (data) {
            console.log('something went wrong');
        }
    });
}



function save() {


    var site_id = $('#cmbSite').val();
    var machine_id = $('#cmbMachine').val();
    var breakdown_time = $('#txtBreakdownTime').val();
    var breakdown_reason_id = $('#cmbReason').val();
    var note = $('#txtReasonOfBreakdown').val();


    $.ajax({
        type: "POST",
        url: '/pd/ReasonOfBreakdownController/save',
        data: {
            "site_id": site_id,
            "machine_id": machine_id,
            "breakdown_time": breakdown_time,
            "breakdown_reason_id": breakdown_reason_id,
            "note": note,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Reason of breakdown has been save success..!');
                $('#txtSupervisor').attr("data-id", '');
                $('#txtSupervisor').val('');
                $('#cmbManuFacturingOrderNo').empty('');
                $('#cmbProduct').empty('');
                $('#cmbMachine').empty();
                $('#cmbShift').empty();
                $('#txtBreakdownTime').val('');
                $('#txtReasonOfBreakdown').val('');
                $('#txtRecoveredTime').val('');
                $('#txtRecoveryDetails').val('');
                $('#txtTechnicalInstruction').val('');
                allDailyProduction();

            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}





function getDailyProduction(id) {
    $.ajax({
        type: "GET",
        url: "/pd/ReasonOfBreakdownController/getDailyProduction/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            allSite();
            setSelectedOption("cmbSite", res.factory_id);
            machine(res.factory_id);
            setSelectedOption("cmbMachine", res.machinery_id);
            $('#txtBreakdownTime').val(res.breakdown_time);
            setSelectedOption("cmbReason", res.breakdown_reason_id);
            $('#txtReasonOfBreakdown').val(res.note);
            if (res.recovered_time != null) {
                $('#txtRecoveredTime').val(res.recovered_time);
            } else {
                $('#txtRecoveredTime').val("");
            }
            if (res.recovery_details != null) {
                $('#txtRecoveryDetails').val(res.recovery_details);
            } else {
                $('#txtRecoveryDetails').val("");
            }
            if (res.technical_instruction != null) {
                $('#txtTechnicalInstruction').val(res.technical_instruction);
            } else {
                $('#txtTechnicalInstruction').val("");
            }
            setSelectedOption("cmbStatus", res.status);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function update() {

    var site_id = $('#cmbSite').val();
    var machine_id = $('#cmbMachine').val();
    var breakdown_time = $('#txtBreakdownTime').val();
    var breakdown_reason_id = $('#cmbReason').val();
    var note = $('#txtReasonOfBreakdown').val();
    var recovered_time = $('#txtRecoveredTime').val();
    var recovery_details = $('#txtRecoveryDetails').val();
    var technical_instruction = $('#txtTechnicalInstruction').val();
    var status = $('#cmbStatus').val();

    $.ajax({
        type: "POST",
        url: '/pd/ReasonOfBreakdownController/update/' + daily_production_id,
        data: {
            "site_id": site_id,
            "machine_id": machine_id,
            "breakdown_time": breakdown_time,
            "breakdown_reason_id": breakdown_reason_id,
            "note": note,
            'recovered_time': recovered_time,
            'recovery_details': recovery_details,
            'technical_instruction': technical_instruction,
            'status': status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Reason of breakdown has been updated success..!');
                $('#txtSupervisor').attr("data-id", '');
                $('#txtSupervisor').val('');
                $('#cmbManuFacturingOrderNo').empty('');
                $('#cmbProduct').empty('');
                $('#cmbMachine').empty();
                $('#cmbShift').empty();
                $('#txtBreakdownTime').val('');
                $('#txtReasonOfBreakdown').val('');
                $('#txtRecoveredTime').val('');
                $('#txtRecoveryDetails').val('');
                $('#txtTechnicalInstruction').val('');
                allDailyProduction();

            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}




function allReason() {
    $.ajax({
        type: "GET",
        url: "/pd/ReasonOfBreakdownController/allReason",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            $('#cmbReason').empty();
            if (response.data.success) {
                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.id + '">' + value.reason + '</option>';
                });
                $('#cmbReason').html(html);


            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}