
var REASON_ID = undefined;
$(document).ready(function () {
    $('#btnShowReasonModal').on('click', function () {

        $('#btnSaveReason').text('Save');
        $('#reasonOfBreakdownModal').modal('show');
    });


    $('#btnSaveReason').on('click', function () {

        if ($(this).text() == 'Save') {
            saveReasonOfBreakdown();
        } else if ($(this).text() == 'Update') {
            updateReasonOfBreakdown();
        }


    });
});



function saveReasonOfBreakdown() {
    $.ajax({
        type: "POST",
        url: '/pd/SettingsController/saveReasonOfBreakdown',
        data: {
            "reason": $('#txtReason').val(),
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Reason of breakdown has been save success..!');

                $('#txtReason').val('');
                $('#reasonOfBreakdownModal').modal('hide');
                allReason();

            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}


function allReason() {
    $.ajax({
        type: "GET",
        url: "/pd/SettingsController/allReason",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            if (response.data.success) {
                var disable = { 0: "", 1: "checked" }
                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<tr><td>' + generateID(value.id) + '</td>';
                    html += '<td>' + value.reason + '</td>';
                    html += '<td class="edit edit_reason"><button type="button" class="btn btn-primary setting-edit-btn" id="' + value.id + '" onclick="editReason(' + value.id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></button></td>';
                    html += '<td class="disable disable_reason"><label class="switch"><input type="checkbox" id="' + value.id + '" onchange="disableReason(' + value.id + ')" ' + disable[value.status] + '><span class="slider round"></span></label></td></tr>';
                });
                $('#tblReasonOfBreakdown').html(html);


            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function editReason(id) {

    REASON_ID = id;
    $.ajax({
        type: "GET",
        url: "/pd/SettingsController/getReason/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            if (response.data.success) {
                $('#txtReason').val(res.reason);
                $('#btnSaveReason').text('Update');
                $('#reasonOfBreakdownModal').modal('show');

            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

}



function updateReasonOfBreakdown() {

    if (REASON_ID == undefined) {
        showWarningMessage("Invalied...!");
        return;
    }
    $.ajax({
        type: "PUT",
        url: '/pd/SettingsController/updateReasonOfBreakdown/' + REASON_ID,
        data: {
            "reason": $('#txtReason').val(),
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Reason of breakdown has been updated success..!');

                $('#txtReason').val('');
                $('#reasonOfBreakdownModal').modal('hide');
                allReason();

            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}


function disableReason(id) {
    $.ajax({
        type: "PUT",
        url: '/pd/SettingsController/disableReason/' + id,
        data: {
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Status change success..!');
                allReason();

            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}


/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "0000",
        2: "000",
        3: "00",
        4: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}


/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}