@extends('pd::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">

<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('pd:js/autocomplete/css/autocomplete.min.css') }}" type="text/css">

<meta name="csrf-token" content="{{ csrf_token() }}">
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">In House</h6>
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-2 mb-3">
                        <button onclick="" class="btn btn-primary mr-5" name="addDailyProductionModel" id="btnAddDailyProductionModel" type="button">+</button>
                    </div>
                </div>
                <table id="tblProductionPlan" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Factory PO</th>
                            <th>Machine</th>
                            <th>Product</th>
                            <th>Shift</th>
                            <th>Hour</th>
                            <th>Quantity</th>
                            <th>Edit</th>
                            <th>View</th>
                            <th>Approve</th>
                            <th>Delete</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>





<!--Daily Production Modal -->

<div class="modal fade" id="dailyProductionModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Daily Production</h5>
            </div>
            <div class="modal-body">
                <hr>
                <div class="row">
                    <div class="col-md-12">

                        <div class="card">
                            <div class="card-body">

                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                        <label for="txtDate">Date</label>
                                        <input type="text" id="txtDate" name="date" class="form-control">
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                        <label for="txtSupervisor">Supervisor</label>
                                        <input type="text" id="txtSupervisor" name="supervisor" class="form-control auto-complete">
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                        <label for="cmbManuFacturingOrderNo">Manufacturing Order No.</label>
                                        <select type="text" id="cmbManuFacturingOrderNo" name="manuFacturingOrderNo" class="form-control"></select>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                        <label for="txtProduct">Product</label>
                                        <!--<input type="text" id="txtProduct" name="product" class="form-control auto-complete">!-->
                                        <select type="text" id="cmbProduct" name="product" class="form-control" disabled></select>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                        <label for="cmbMachine">Machine</label>
                                        <select id="cmbMachine" name="machine" class="form-control"></select>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                        <label for="cmbMachine">Shift</label>
                                        <select id="cmbShift" name="machine" class="form-control"></select>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                        <label for="txtRefferanceNo">Refferance No.</label>
                                        <input type="text" id="txtRefferanceNo" name="refferanceNo" class="form-control">
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                                <label for="txtQuantity">Hour</label>
                                                <!--<input type="text" id="txtHour" name="dayHour" class="form-control">!-->
                                                <select id="cmbHour" name="hour" class="form-control">
                                                    <option value="1">1</option>
                                                    <option value="2">2</option>
                                                    <option value="3">3</option>
                                                    <option value="4">4</option>
                                                    <option value="5">5</option>
                                                    <option value="6">6</option>
                                                    <option value="7">7</option>
                                                    <option value="8">8</option>
                                                    <option value="9">9</option>
                                                    <option value="10">10</option>
                                                    <option value="11">11</option>
                                                    <option value="12">12</option>
                                                    <option value="13">13</option>
                                                    <option value="14">14</option>
                                                    <option value="15">15</option>
                                                    <option value="16">16</option>
                                                    <option value="17">17</option>
                                                    <option value="18">18</option>
                                                    <option value="19">19</option>
                                                    <option value="20">20</option>
                                                    <option value="21">21</option>
                                                    <option value="22">22</option>
                                                    <option value="23">23</option>
                                                    <option value="24">24</option>
                                                </select>
                                            </div>
                                            <div class="col-md-6">
                                                <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                                <label for="txtQuantity">Quantity</label>
                                                <input type="text" id="txtQuantity" name="quantity" class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                        <label for="txtRefferanceNo">Remark</label>
                                        <textarea id="txtRemark" name="remark" class="form-control"></textarea>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
            <div class="modal-footer">

                <button type="button" name="saveaddorder" id="btnAction" class="btn btn-primary">Save</button>
                <button type="button" name="canceladdorder" id="btnCancelAddOrder" class="btn btn-warning" data-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('assets/js/examples/datatable.js') }}"></script>
<!-- Datepicker -->
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<script src="{{ Module::asset('pd:js/autocomplete/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('pd:js/daily_production.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('pd:js/daily_production_list.js') }}?random=<?php echo uniqid(); ?>"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
@endsection