<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateScheduleCustomerOrderPlansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pd_schedule_customer_order_plans', function (Blueprint $table) {
            $table->id('schedule_customer_order_plan_id');
            $table->integer('customer_order_plan_id');
            $table->foreignId('order_id',25);
            $table->string('manufacturing_order_number',200);
            $table->date('trans_date');
            $table->date('from_date');
            $table->date('to_date');
            $table->string('description',300)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('schedule_customer_order_plans');
    }
}
