<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateScheduleCustomerOrderPlanDataTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pd_schedule_customer_order_plan_data', function (Blueprint $table) {
            $table->id('schedule_customer_order_plan_data_id');
            $table->integer('customer_order_plan_data_id');
            $table->foreignId('customer_order_plan_id', 25);
            $table->foreignId('order_data_id', 25);
            $table->string('manufacturing_order_no', 100);
            $table->string('product_id', 25);
            $table->string('product_name', 25);
            $table->string('quantity', 300);
            $table->boolean('status');
            $table->integer('factory_type');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('schedule_customer_order_plan_data');
    }
}
