<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateScheduleMachineryPlansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pd_schedule_machinery_plans', function (Blueprint $table) {
            $table->id('schedule_machinery_plan_id');
            $table->integer('machinery_plan_id');
            $table->integer('customer_order_plan_data_id');
            $table->integer('machinery_id');
            $table->integer('product_primary_id');
            $table->date('date');
            $table->integer('from');
            $table->integer('to');
            $table->double('quantity');
            $table->integer('shift_id');
            $table->string('completed', 45);
            $table->integer('status');
            $table->integer('breakdown_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('schedule_machinery_plans');
    }
}
