<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductionMachineBreakdownsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pd_production_machine_breakdowns', function (Blueprint $table) {
            $table->id();
            $table->integer('site_id');
            $table->integer('machinery_id');
            $table->dateTime('breakdown_time');
            $table->integer('breakdown_reason_id');
            $table->string('note',100)->nullable();
            $table->dateTime('recovered_time')->nullable();
            $table->string('recovery_details',100)->nullable();
            $table->string('technical_instruction',100)->nullable();
            $table->integer('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('production_machine_breakdowns');
    }
}
