<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePallatizingHeadersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pd_pallatizing_headers', function (Blueprint $table) {
            $table->id('pallatizing_header_id');
            $table->string('pallet_no', 45);
            $table->date('pallatize_date');
            $table->double('pallet_weight');
            $table->double('pallet_length');
            $table->double('pallet_width');
            $table->double('pallet_height');
            $table->integer('factory_id');
            $table->integer('order_id');
            $table->integer('status');
            $table->integer('user_id');
            $table->string('supervisor_id', 45);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pallatizing_headers');
    }
}
